<?php
/**
 * Popular Blogger functions and definitions.
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package popular_blogger
 */

$popular_blogger_theme_data = wp_get_theme();
if( ! defined( 'POPULAR_BLOGGER_THEME_VERSION' ) ) define ( 'POPULAR_BLOGGER_THEME_VERSION', $popular_blogger_theme_data->get( 'Version' ) );
if( ! defined( 'POPULAR_BLOGGER_THEME_NAME' ) ) define( 'POPULAR_BLOGGER_THEME_NAME', $popular_blogger_theme_data->get( 'Name' ) );

if ( ! function_exists( 'popular_blogger_setup' ) ) :
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
function popular_blogger_setup() {

	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );

	/*
	 * Let WordPress manage the document title.
	 * By adding theme support, we declare that this theme does not use a
	 * hard-coded <title> tag in the document head, and expect WordPress to
	 * provide it for us.
	 */
	add_theme_support( 'title-tag' );

	/*
	 * Enable support for Post Thumbnails on posts and pages.
	 *
	 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
	 */
	add_theme_support( 'post-thumbnails' );

	// This theme uses wp_nav_menu() in one location.
	register_nav_menus( array(
		'primary' => esc_html__( 'Primary', 'popular-blogger' ),
	) );

	/*
	 * Switch default core markup for search form, comment form, and comments
	 * to output valid HTML5.
	 */
	add_theme_support( 'html5', array(
		'search-form',
		'comment-list',
		'gallery',
		'caption',
	) );

	/*
	 * Enable support for Post Formats.
	 * See https://developer.wordpress.org/themes/functionality/post-formats/
	 */
	add_theme_support( 'post-formats', array(
		'aside',
		'image',
		'video',
		'quote',
		'link',
		'gallery',
        'status',
        'audio', 
        'chat'
	) );

	// Set up the WordPress core custom background feature.
	add_theme_support( 'custom-background', apply_filters( 'popular_blogger_custom_background_args', array(
		'default-color' => 'ffffff',
		'default-image' => '',
	) ) );

	/* Custom Logo */
    add_theme_support( 'custom-logo', array(
    	'header-text' => array( 'site-title', 'site-description' ),
    ) );

	add_theme_support( 'woocommerce' );

}
endif;
add_action( 'after_setup_theme', 'popular_blogger_setup' );

/**
 * TGM Plugin Activation
 */
require get_stylesheet_directory() . '/inc/tgm/tgm.php';

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $popular_blogger_content_width
 */
function popular_blogger_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'popular_blogger_content_width', 780 );
}
add_action( 'after_setup_theme', 'popular_blogger_content_width', 0 );


/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function popular_blogger_widgets_init() {
	register_sidebar( array(
		'name'          => esc_html__( 'Sidebar Option', 'popular-blogger' ),
		'id'            => 'right-sidebar',
		'description'   => '',
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
	register_sidebar( array(
		'name'          => esc_html__( 'Sidebar Two', 'popular-blogger' ),
		'id'            => 'sidebar-2',
		'description'   => '',
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
	register_sidebar( array(
		'name'          => esc_html__( 'Sidebar Three', 'popular-blogger' ),
		'id'            => 'sidebar-3',
		'description'   => '',
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
	register_sidebar( array(
		'name'          => esc_html__( 'Footer One', 'popular-blogger' ),
		'id'            => 'footer-one',
		'description'   => '',
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
    
    register_sidebar( array(
		'name'          => esc_html__( 'Footer Two', 'popular-blogger' ),
		'id'            => 'footer-two',
		'description'   => '',
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
    
    register_sidebar( array(
		'name'          => esc_html__( 'Footer Three', 'popular-blogger' ),
		'id'            => 'footer-three',
		'description'   => '',
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Footer Four', 'popular-blogger' ),
		'id'            => 'footer-four',
		'description'   => '',
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Shop Sidebar', 'popular-blogger' ),
		'id'            => 'woocommerce-sidebar',
		'description'   => '',
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Single Product Sidebar', 'popular-blogger' ),
		'id'            => 'woocommerce-single-sidebar',
		'description'   => '',
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );

}
add_action( 'widgets_init', 'popular_blogger_widgets_init' );

if( ! function_exists( 'popular_blogger_scripts' ) ) :

/**
 * Enqueue scripts and styles.
 */
function popular_blogger_scripts() {

    wp_enqueue_style( 'bootstrap-style', get_template_directory_uri().'/css/build/bootstrap.css' );
}
endif;
add_action( 'wp_enqueue_scripts', 'popular_blogger_scripts' );


add_action( 'wp_enqueue_scripts', 'popular_blogger_enqueue_styles' );
function popular_blogger_enqueue_styles() {
	$parent_style = 'popular-blogger-style'; // Style handle of parent theme.
	wp_enqueue_style( $parent_style, get_template_directory_uri() . '/style.css' );
	wp_enqueue_style( 'popular-blogger-style', get_stylesheet_uri(), array( $parent_style ) );
}


/**
 * Remove header text setting and control from the Customizer.
 */
function popular_blogger_remove_customizer_setting($wp_customize) {
    // Remove specific control and setting
    $wp_customize->remove_control('display_header_text');
    $wp_customize->remove_setting('display_header_text');
}
add_action('customize_register', 'popular_blogger_remove_customizer_setting', 999);


// Completely prevent wizard initialization
add_action( 'after_setup_theme', 'popular_blogger_disable_wizard', 5 );
function popular_blogger_disable_wizard() {
    // Prevent parent theme from loading wizard config
    remove_action( 'after_setup_theme', 'prime_fashion_magazine_setup' );
    
    // Re-add parent theme setup without wizard
    add_action( 'after_setup_theme', 'popular_blogger_parent_setup_without_wizard', 10 );
}

function popular_blogger_parent_setup_without_wizard() {
    // Load only essential parent theme files, skip wizard
    if ( file_exists( get_template_directory() . '/inc/template-tags.php' ) ) {
        require get_template_directory() . '/inc/template-tags.php';
    }
    if ( file_exists( get_template_directory() . '/inc/extra.php' ) ) {
        require get_template_directory() . '/inc/extra.php';
    }
    if ( file_exists( get_template_directory() . '/inc/customizer.php' ) ) {
        require get_template_directory() . '/inc/customizer.php';
    }
    if ( file_exists( get_template_directory() . '/inc/widget-social-links.php' ) ) {
        require get_template_directory() . '/inc/widget-social-links.php';
    }
    if ( file_exists( get_template_directory() . '/inc/sanitization.php' ) ) {
        require get_template_directory() . '/inc/sanitization.php';
    }
    if ( file_exists( get_template_directory() . '/inc/info.php' ) ) {
        require get_template_directory() . '/inc/info.php';
    }
    if ( file_exists( get_template_directory() . '/inc/getting-started/getting-started.php' ) ) {
        require get_template_directory() . '/inc/getting-started/getting-started.php';
    }
}

	function popular_blogger_customizer ( $wp_customize ) {

		//Featured Article
		$wp_customize->add_section('popular_blogger_article_section',array(
			'title'	=> __('Our Featured Articles','popular-blogger'),
			'priority' => 31,
			'capability' => 'edit_theme_options',
			'panel' => 'prime_fashion_magazine_home_page_settings',
		));

	    /** Classes Section control */
	    $wp_customize->add_setting( 
	        'prime_fashion_magazine_article_setting', 
	        array(
	            'default' => true,
	            'sanitize_callback' => 'prime_fashion_magazine_sanitize_checkbox',
	        ) 
	    );

	    $wp_customize->add_control(
	        'prime_fashion_magazine_article_setting',
	        array(
	            'label'       => __( 'Show Articles', 'popular-blogger' ),
	            'section'     => 'popular_blogger_article_section',
	            'type'        => 'checkbox',
	        )
	    );

		$wp_customize->add_setting('popular_blogger_article_text_section',array(
			'default'=> '',
			'sanitize_callback' => 'sanitize_text_field'
		));
		$wp_customize->add_control('popular_blogger_article_text_section',array(
			'label' => __('Article Heading','popular-blogger'),
			'section'=> 'popular_blogger_article_section',
			'type'=> 'text',
		));

		$wp_customize->add_setting('popular_blogger_article_small_text_section',array(
			'default'=> '',
			'sanitize_callback' => 'sanitize_text_field'
		));
		$wp_customize->add_control('popular_blogger_article_small_text_section',array(
			'label' => __('Add Article Sub Heading','popular-blogger'),
			'section'=> 'popular_blogger_article_section',
			'type'=> 'text',
		));

		// Fetch all posts
		$all_posts = get_posts( array(
		    'numberposts' => -1,
		    'post_type'   => 'post',
		    'post_status' => 'publish',
		) );

		$post_choices = array();
		$post_choices[''] = __( 'Select a Post', 'popular-blogger' );

		if ( ! empty( $all_posts ) ) {
		    foreach ( $all_posts as $post ) {
		        $post_choices[ $post->ID ] = $post->post_title;
		    }
		}

		$wp_customize->add_setting(
		    'popular_blogger_selected_article_post',
		    array(
		        'default'           => '',
		        'sanitize_callback'  => 'prime_fashion_magazine_sanitize_choices',
		    )
		);

		$wp_customize->add_control(
		    'popular_blogger_selected_article_post',
		    array(
		        'type'        => 'select',
		        'label'       => __( 'Select Single Post to Display', 'popular-blogger' ),
		        'description' => __( 'Choose one post to feature in the article section.', 'popular-blogger' ),
		        'section'     => 'popular_blogger_article_section',
		        'choices'     => $post_choices,
		    )
		);

	    /**  Add View all URL*/
	     $wp_customize->add_setting(
	         'popular_blogger_more_tags_url',
	         array( 
	             'default' => '',
	             'sanitize_callback' => 'esc_url_raw',
	            'transport'         => 'refresh'
	         )
	     );
	    
	     $wp_customize->add_control(
	         'popular_blogger_more_tags_url',
	         array(
	             'label' => esc_html__( 'View All Button URL', 'popular-blogger' ),
	             'section' => 'popular_blogger_article_section',
	             'type' => 'url',
	         )
	     );

	}

	add_action( 'customize_register', 'popular_blogger_customizer' );

/*-----------------------------------------------------------------------------------*/
/* Enqueue Global color style */
/*-----------------------------------------------------------------------------------*/


add_action( 'customize_register', 'popular_blogger_override_global_color_default', 20 );
function popular_blogger_override_global_color_default( $wp_customize ) {

    // Replace 'global_color' with the setting ID from the parent theme
    if ( $wp_customize->get_setting( 'prime_fashion_magazine_primary_color' ) ) {
        $wp_customize->get_setting( 'prime_fashion_magazine_primary_color' )->default = '#5A9194';
    }
}

/**
 * Display the admin notice unless dismissed.
 */
function prime_fashion_magazine_dashboard_notice_child() {
    // Check if the notice is dismissed
    $dismissed = get_user_meta( get_current_user_id(), 'prime_fashion_magazine_dismissable_notice', true );

    // Display the notice only if not dismissed
    if ( ! $dismissed ) {

        // Get the theme name dynamically
        $theme_name = wp_get_theme()->get( 'Name' );
        ?>
        <div class="updated notice notice-success is-dismissible notice-get-started-class" data-notice="get-start">
            <div class="notice-details">
                <div class="notice-content">
                    <h2>
                        <?php 
                        /* translators: %s: Theme name */
                        printf(
                            esc_html__( 'Thank you for installing %s.', 'prime-fashion-magazine' ),
                            '<strong>' . esc_html( $theme_name ) . '</strong>'
                        );
                        ?>
                    </h2>
                    <p><?php echo esc_html__( 'Your journey to a powerful and stylish website begins here. Let’s get everything set up in just a few clicks!', 'prime-fashion-magazine' ); ?></p>
                    <div class="notice-btns">
                        <a class="button button-primary getstart"
                           href="<?php echo esc_url( admin_url( 'themes.php?page=prime-fashion-magazine' ) ); ?>">
                           <?php esc_html_e( 'Getting Started', 'prime-fashion-magazine' ); ?>
                        </a>
                        <a class="button button-primary import"
                           href="<?php echo esc_url(admin_url('themes.php?page=popularblogger-wizard')); ?>"><?php esc_html_e('Demo Importer', 'prime-fashion-magazine') ?></a>                        
                        <a class="button button-primary premium"
                           target="_blank" href="<?php echo esc_url(PRIME_FASHION_MAGAZINE_URL); ?>">
                           <?php esc_html_e( 'Go To Premium', 'prime-fashion-magazine' ); ?>
                        </a>
						<a class="button button-primary demo" target="_blank" href="<?php echo esc_url(PRIME_FASHION_MAGAZINE_DEMO_URL); ?>"><?php esc_html_e('View Demo', 'prime-fashion-magazine') ?></a>
                    </div>
                </div>
                <div class="notice-img">
                    <a href="<?php echo esc_url( PRIME_FASHION_MAGAZINE_BUNDLE_URL ); ?>" target="_blank"><img src="<?php echo esc_url( get_template_directory_uri() . '/images/notice.png' ); ?>"></a>
                </div> 
            </div>
        </div>
        <?php
    }
}

function popular_blogger_template_setup() {

if ( ! defined( 'PRIME_FASHION_MAGAZINE_URL' ) ) {
    define( 'PRIME_FASHION_MAGAZINE_URL', esc_url( 'https://www.themeignite.com/products/fashion-wordpress-theme', 'popular-blogger') );
}
if ( ! defined( 'PRIME_FASHION_MAGAZINE_TEXT' ) ) {
    define( 'PRIME_FASHION_MAGAZINE_TEXT', __( 'Popular Blogger PRO','popular-blogger' ));
}
if ( ! defined( 'PRIME_FASHION_MAGAZINE_FOOTER_URL' ) ) {
  define( 'PRIME_FASHION_MAGAZINE_FOOTER_URL', esc_url( 'https://www.themeignite.com/products/popular-blogger', 'popular-blogger') );
}
if ( ! defined( 'PRIME_FASHION_MAGAZINE_FREE_DOC_URL' ) ) {
    define( 'PRIME_FASHION_MAGAZINE_FREE_DOC_URL', esc_url( 'https://demo.themeignite.com/documentation/free-popular-blogger/', 'popular-blogger') );
}
if ( ! defined( 'PRIME_FASHION_MAGAZINE_DOC_URL' ) ) {
    define( 'PRIME_FASHION_MAGAZINE_DOC_URL', esc_url( 'https://demo.themeignite.com/documentation/free-popular-blogger/', 'popular-blogger') );
}
if ( ! defined( 'PRIME_FASHION_MAGAZINE_PRO_DOC_URL' ) ) {
    define( 'PRIME_FASHION_MAGAZINE_PRO_DOC_URL', esc_url( 'https://demo.themeignite.com/documentation/prime-fashion-magazine-pro/', 'popular-blogger') );
}
if ( ! defined( 'PRIME_FASHION_MAGAZINE_DEMO_URL' ) ) {
    define( 'PRIME_FASHION_MAGAZINE_DEMO_URL', esc_url( 'https://demo.themeignite.com/prime-fashion-magazine/', 'popular-blogger') );
}
if ( ! defined( 'PRIME_FASHION_MAGAZINE_REVIEW_URL' ) ) {
    define( 'PRIME_FASHION_MAGAZINE_REVIEW_URL', esc_url( 'https://www.wordpress.org/support/theme/popular-blogger/reviews/#new-post', 'popular-blogger') );
}
if ( ! defined( 'PRIME_FASHION_MAGAZINE_SUPPORT_URL' ) ) {
    define( 'PRIME_FASHION_MAGAZINE_SUPPORT_URL', esc_url( 'https://www.wordpress.org/support/theme/popular-blogger', 'popular-blogger') );
}
if ( ! defined( 'PRIME_FASHION_MAGAZINE_BUNDLE_URL' ) ) {
	define( 'PRIME_FASHION_MAGAZINE_BUNDLE_URL', esc_url( 'https://www.themeignite.com/products/wp-theme-bundle', 'popular-blogger') );
}

/**
 * Setup Wizard
 */
if (is_child_theme() && wp_get_theme()->get('Name') === 'Popular Blogger') {
    require get_theme_file_path() . '/theme-wizard/config.php';

// Hook to display the notice
add_action( 'admin_notices', 'prime_fashion_magazine_dashboard_notice_child' );
}

}
add_action('after_setup_theme', 'popular_blogger_template_setup');