<?php
/**
 * The template for displaying the footer.
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package popular_blogger
 */
$popular_blogger_scroll_top  = get_theme_mod( 'popular_blogger_scroll_to_top', true );
$popular_blogger_footer_background = get_theme_mod('popular_blogger_footer_background_image');
$popular_blogger_footer_background_url = '';
if(!empty($popular_blogger_footer_background)){
    $popular_blogger_footer_background = absint($popular_blogger_footer_background);
    $popular_blogger_footer_background_url = wp_get_attachment_url($popular_blogger_footer_background);
}

$popular_blogger_footer_background_color = get_theme_mod('popular_blogger_footer_background_color', 'var(--primary-color)'); // New line

$popular_blogger_footer_background_style = '';
if (!empty($popular_blogger_footer_background_url)) {
    $popular_blogger_footer_background_style = ' style="background-image: url(\'' . esc_url($popular_blogger_footer_background_url) . '\'); background-repeat: no-repeat; background-size: cover;"';
} else {
    $popular_blogger_footer_background_style = ' style="background-color: ' . esc_attr($popular_blogger_footer_background_color) . ';"'; // Updated line
}
?>

</div>
</div>
</div>
</div>

<footer class="site-footer" <?php echo $popular_blogger_footer_background_style; ?>>

    <?php
    // Footer widget columns (child theme)
    $popular_blogger_active_areas = get_theme_mod(
        'prime_fashion_magazine_footer_widget_areas',
        4
    );

    if (
        is_active_sidebar('footer-one') ||
        is_active_sidebar('footer-two') ||
        is_active_sidebar('footer-three') ||
        is_active_sidebar('footer-four')
    ) :
    ?>
        <div class="footer-t">
            <div class="container">
                <div class="row">

                    <?php
                    // Dynamic column width
                    $popular_blogger_col = 12 / $popular_blogger_active_areas;

                    for ( $i = 1; $i <= $popular_blogger_active_areas; $i++ ) {

                        $sidebar_id = 'footer-' . $i;

                        if ( is_active_sidebar( $sidebar_id ) ) {
                            echo '<div class="col-xl-' . esc_attr( $popular_blogger_col ) . ' 
                                        col-lg-' . esc_attr( $popular_blogger_col ) . ' 
                                        col-md-6 col-sm-6">';
                            dynamic_sidebar( $sidebar_id );
                            echo '</div>';
                        }
                    }
                    ?>

                </div>
            </div>
        </div>

    <?php else : ?>

        <!-- Default Widgets -->
        <div class="footer-t">
            <div class="container">
                <div class="row">

                    <?php
                    $popular_blogger_col = 12 / $popular_blogger_active_areas;
                    ?>

                    <!-- Archive -->
                    <aside class="widget widget_archive col-xl-<?php echo esc_attr($popular_blogger_col); ?> col-lg-<?php echo esc_attr($popular_blogger_col); ?> col-md-6 col-sm-6">
                        <h2 class="widget-title"><?php esc_html_e('Archive List', 'popular-blogger'); ?></h2>
                        <ul><?php wp_get_archives('type=monthly'); ?></ul>
                    </aside>

                    <!-- Recent Posts -->
                    <aside class="widget widget_recent_posts col-xl-<?php echo esc_attr($popular_blogger_col); ?> col-lg-<?php echo esc_attr($popular_blogger_col); ?> col-md-6 col-sm-6">
                        <h2 class="widget-title"><?php esc_html_e('Recent Posts', 'popular-blogger'); ?></h2>
                        <ul>
                            <?php
                            $recent = new WP_Query(array(
                                'post_type'      => 'post',
                                'posts_per_page' => 5,
                            ));
                            while ( $recent->have_posts() ) : $recent->the_post();
                            ?>
                                <li><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></li>
                            <?php endwhile; wp_reset_postdata(); ?>
                        </ul>
                    </aside>

                    <!-- Categories -->
                    <aside class="widget widget_categories col-xl-<?php echo esc_attr($popular_blogger_col); ?> col-lg-<?php echo esc_attr($popular_blogger_col); ?> col-md-6 col-sm-6">
                        <h2 class="widget-title"><?php esc_html_e('Categories', 'popular-blogger'); ?></h2>
                        <ul><?php wp_list_categories(array('title_li' => '')); ?></ul>
                    </aside>

                    <!-- Tags -->
                    <aside class="widget widget_tags col-xl-<?php echo esc_attr($popular_blogger_col); ?> col-lg-<?php echo esc_attr($popular_blogger_col); ?> col-md-6 col-sm-6">
                        <h2 class="widget-title"><?php esc_html_e('Tags', 'popular-blogger'); ?></h2>
                        <div class="tag-cloud"><?php wp_tag_cloud(); ?></div>
                    </aside>

                </div>
            </div>
        </div>

    <?php endif; ?>

    <?php do_action( 'prime_fashion_magazine_footer' ); ?>

    <?php if ( $popular_blogger_scroll_top ) : ?>
        <a id="button">
            <i class="<?php echo esc_attr(
                get_theme_mod('prime_fashion_magazine_scroll_icon','fas fa-arrow-up')
            ); ?>"></i>
        </a>
    <?php endif; ?>

</footer>
</div>
</div>

<?php wp_footer(); ?>

</body>
</html>