<?php
/**
 * Title: Features grid with a title and description.
 * Slug: poe/portfolio-features
 * Categories: poe-portfolio
 */
?>
<!-- wp:group {"align":"wide"} -->
<div class="wp-block-group alignwide">
	<!-- wp:group -->
	<div class="wp-block-group">
		<!-- wp:separator {"backgroundColor":"tertiary","className":"is-style-wide"} -->
		<hr
			class="wp-block-separator has-text-color has-tertiary-color has-alpha-channel-opacity has-tertiary-background-color has-background is-style-wide" />
		<!-- /wp:separator -->

		<!-- wp:columns {"verticalAlignment":"center","style":{"spacing":{"margin":{"bottom":"32px"}}}} -->
		<div class="wp-block-columns are-vertically-aligned-center" style="margin-bottom:32px">
			<!-- wp:column {"verticalAlignment":"center"} -->
			<div class="wp-block-column is-vertically-aligned-center">
				<!-- wp:heading {"level":4} -->
				<h4 id="features">Features</h4>
				<!-- /wp:heading -->
			</div>
			<!-- /wp:column -->

			<!-- wp:column {"verticalAlignment":"center"} -->
			<div class="wp-block-column is-vertically-aligned-center">
				<!-- wp:paragraph -->
				<p>Learn what you can expect from us.</p>
				<!-- /wp:paragraph -->
			</div>
			<!-- /wp:column -->
		</div>
		<!-- /wp:columns -->
	</div>
	<!-- /wp:group -->

	<!-- wp:columns -->
	<div class="wp-block-columns">
		<!-- wp:column {"backgroundColor":"quaternary"} -->
		<div class="wp-block-column has-quaternary-background-color has-background">
			<!-- wp:group -->
			<div class="wp-block-group">
				<!-- wp:image {"linkDestination":"none"} -->
				<figure class="wp-block-image"><img
						src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/illustrations/feature-1.png"
						alt="" /></figure>
				<!-- /wp:image -->

				<!-- wp:group {"style":{"spacing":{"margin":{"top":"0px","bottom":"0px"}}},"backgroundColor":"quaternary"} -->
				<div class="wp-block-group has-quaternary-background-color has-background"
					style="margin-top:0px;margin-bottom:0px">
					<!-- wp:heading {"level":6,"textColor":"primary"} -->
					<h6 class="has-primary-color has-text-color" id="clean-design">Clean Design</h6>
					<!-- /wp:heading -->

					<!-- wp:paragraph {"fontSize":"small"} -->
					<p class="has-small-font-size">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do
						eiusmod tempor incididunt ut labore et dolore magna aliqua.
					</p>
					<!-- /wp:paragraph -->
				</div>
				<!-- /wp:group -->
			</div>
			<!-- /wp:group -->
		</div>
		<!-- /wp:column -->

		<!-- wp:column {"backgroundColor":"quaternary"} -->
		<div class="wp-block-column has-quaternary-background-color has-background">
			<!-- wp:group -->
			<div class="wp-block-group">
				<!-- wp:image {"linkDestination":"none"} -->
				<figure class="wp-block-image"><img
						src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/illustrations/feature-2.png"
						alt="" /></figure>
				<!-- /wp:image -->

				<!-- wp:group {"style":{"spacing":{"margin":{"top":"0px","bottom":"0px"}}},"backgroundColor":"quaternary"} -->
				<div class="wp-block-group has-quaternary-background-color has-background"
					style="margin-top:0px;margin-bottom:0px">
					<!-- wp:heading {"level":6,"textColor":"primary"} -->
					<h6 class="has-primary-color has-text-color" id="full-site-editing">Flexible Solutions</h6>
					<!-- /wp:heading -->

					<!-- wp:paragraph {"fontSize":"small"} -->
					<p class="has-small-font-size">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do
						eiusmod tempor incididunt ut labore et dolore magna aliqua.</p>
					<!-- /wp:paragraph -->
				</div>
				<!-- /wp:group -->
			</div>
			<!-- /wp:group -->
		</div>
		<!-- /wp:column -->

		<!-- wp:column {"backgroundColor":"quaternary"} -->
		<div class="wp-block-column has-quaternary-background-color has-background">
			<!-- wp:group -->
			<div class="wp-block-group">
				<!-- wp:image {"linkDestination":"none"} -->
				<figure class="wp-block-image"><img
						src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/illustrations/feature-3.png"
						alt="" /></figure>
				<!-- /wp:image -->

				<!-- wp:group {"style":{"spacing":{"margin":{"top":"0px","bottom":"0px"}}},"backgroundColor":"quaternary"} -->
				<div class="wp-block-group has-quaternary-background-color has-background"
					style="margin-top:0px;margin-bottom:0px">
					<!-- wp:heading {"level":6,"textColor":"primary"} -->
					<h6 class="has-primary-color has-text-color" id="global-styles">Reliable Support</h6>
					<!-- /wp:heading -->

					<!-- wp:paragraph {"fontSize":"small"} -->
					<p class="has-small-font-size">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do
						eiusmod tempor incididunt ut labore et dolore magna aliqua.
					</p>
					<!-- /wp:paragraph -->
				</div>
				<!-- /wp:group -->
			</div>
			<!-- /wp:group -->
		</div>
		<!-- /wp:column -->
	</div>
	<!-- /wp:columns -->

</div>
<!-- /wp:group -->