<?php
/**
 * Title: Hero with a background image, a heading and buttons.
 * Slug: poe/hero-cover
 * Categories: poe-hero
 */
?>
<!-- wp:cover {"url":"<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/illustrations/illustration.png","id":24842,"dimRatio":30,"minHeight":75,"minHeightUnit":"vh","contentPosition":"top left","isDark":false,"align":"full"} -->
<div class="wp-block-cover alignfull is-light has-custom-content-position is-position-top-left" style="min-height:75vh">
	<span aria-hidden="true" class="wp-block-cover__background has-background-dim-30 has-background-dim"></span><img
		class="wp-block-cover__image-background wp-image-24842" alt=""
		src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/illustrations/illustration.png"
		data-object-fit="cover" />
	<div class="wp-block-cover__inner-container">
		<!-- wp:group {"layout":{"inherit":true}} -->
		<div class="wp-block-group">
			<!-- wp:group {"align":"wide"} -->
			<div class="wp-block-group alignwide">
				<!-- wp:heading {"level":6,"style":{"typography":{"fontStyle":"normal","fontWeight":"700","textTransform":"uppercase","letterSpacing":"0.075em"}},"textColor":"primary","fontSize":"small"} -->
				<h6 class="has-primary-color has-text-color has-small-font-size"
					style="font-style:normal;font-weight:700;text-transform:uppercase;letter-spacing:0.075em">What We Do
				</h6>
				<!-- /wp:heading -->

				<!-- wp:heading {"level":1,"style":{"spacing":{"margin":{"top":"0.25em","bottom":"0.5em"}},"typography":{"fontStyle":"normal","letterSpacing":"-0.04em"}},"textColor":"foreground","fontSize":"gigantic"} -->
				<h1 class="has-foreground-color has-text-color has-gigantic-font-size"
					style="font-style:normal;letter-spacing:-0.04em;margin-top:0.25em;margin-bottom:0.5em">Fun by Design
				</h1>
				<!-- /wp:heading -->

				<!-- wp:buttons -->
				<div class="wp-block-buttons">
					<!-- wp:button {"className":"has-custom-font-size"} -->
					<div class="wp-block-button has-custom-font-size"><a class="wp-block-button__link">Learn More</a>
					</div>
					<!-- /wp:button -->
				</div>
				<!-- /wp:buttons -->
			</div>
			<!-- /wp:group -->
		</div>
		<!-- /wp:group -->
	</div>
</div>
<!-- /wp:cover -->