<?php
/**
 * Header Layout
 * @package Plumbing Technician
 */

$plumbing_technician_defaults = plumbing_technician_get_default_theme_options();

$plumbing_technician_header_layout_email_address = esc_html( get_theme_mod( 'plumbing_technician_header_layout_email_address',
$plumbing_technician_defaults['plumbing_technician_header_layout_email_address'] ) );

$plumbing_technician_header_layout_location_address = esc_html( get_theme_mod( 'plumbing_technician_header_layout_location_address',
$plumbing_technician_defaults['plumbing_technician_header_layout_location_address'] ) );

$plumbing_technician_header_layout_working_hour = esc_html( get_theme_mod( 'plumbing_technician_header_layout_working_hour',
$plumbing_technician_defaults['plumbing_technician_header_layout_working_hour'] ) );

$plumbing_technician_header_layout_phone_number = esc_html( get_theme_mod( 'plumbing_technician_header_layout_phone_number',
$plumbing_technician_defaults['plumbing_technician_header_layout_phone_number'] ) );

?>

<div class="headerbox">
    <header id="site-header" class="site-header-layout header-layout" role="banner">
        <div class="header-navbar">
            <div class="wrapper">
                <div class="header-titles">
                    <?php
                    plumbing_technician_site_logo();
                    plumbing_technician_site_description();
                    ?>
                </div>
                <div class="site-navigation">
                    <nav class="primary-menu-wrapper" aria-label="<?php esc_attr_e('Horizontal', 'plumbing-technician'); ?>" role="navigation">
                        <ul class="primary-menu theme-menu">
                            <?php
                            if (has_nav_menu('plumbing-technician-primary-menu')) {
                                wp_nav_menu(
                                    array(
                                        'container' => '',
                                        'items_wrap' => '%3$s',
                                        'theme_location' => 'plumbing-technician-primary-menu',
                                    )
                                );
                            } else {
                                wp_list_pages(
                                    array(
                                        'match_menu_classes' => true,
                                        'show_sub_menu_icons' => true,
                                        'title_li' => false,
                                        'walker' => new Plumbing_Technician_Walker_Page(),
                                    )
                                );
                            } ?>
                        </ul>
                    </nav>
                </div>
                <div class="navbar-controls twp-hide-js">
                    <button type="button" class="navbar-control navbar-control-offcanvas">
                        <span class="navbar-control-trigger" tabindex="-1">
                            <?php plumbing_technician_the_theme_svg('menu'); ?>
                        </span>
                    </button>
                </div>
            </div>
        </div>
    </header>
</div>

<section id="info-header">
    <div class="wrapper header-wrapper">
        <div class="theme-header-areas header-areas-right">
            <svg xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 512 512"><!--! Font Awesome Free 6.4.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2023 Fonticons, Inc. --><path d="M493.4 24.6l-104-24c-11.3-2.6-22.9 3.3-27.5 13.9l-48 112c-4.2 9.8-1.4 21.3 6.9 28l60.6 49.6c-36 76.7-98.9 140.5-177.2 177.2l-49.6-60.6c-6.8-8.3-18.2-11.1-28-6.9l-112 48C3.9 366.5-2 378.1.6 389.4l24 104C27.1 504.2 36.7 512 48 512c256.1 0 464-207.5 464-464 0-11.2-7.7-20.9-18.6-23.4z"/></svg>
            <div class="header-areas-box">
                <?php if( $plumbing_technician_header_layout_phone_number ){ ?>
                    <p><a href="tel:<?php echo esc_attr( $plumbing_technician_header_layout_phone_number ); ?>"><?php echo esc_html( $plumbing_technician_header_layout_phone_number ); ?></a></p>
                <?php } ?>
            </div>
        </div>
        <div class="theme-header-areas header-areas-right">
            <svg xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 512 512"><!--! Font Awesome Free 6.4.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2023 Fonticons, Inc. --><path d="M502.3 190.8c3.9-3.1 9.7-.2 9.7 4.7V400c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V195.6c0-5 5.7-7.8 9.7-4.7 22.4 17.4 52.1 39.5 154.1 113.6 21.1 15.4 56.7 47.8 92.2 47.6 35.7.3 72-32.8 92.3-47.6 102-74.1 131.6-96.3 154-113.7zM256 320c23.2.4 56.6-29.2 73.4-41.4 132.7-96.3 142.8-104.7 173.4-128.7 5.8-4.5 9.2-11.5 9.2-18.9v-19c0-26.5-21.5-48-48-48H48C21.5 64 0 85.5 0 112v19c0 7.4 3.4 14.3 9.2 18.9 30.6 23.9 40.7 32.4 173.4 128.7 16.8 12.2 50.2 41.8 73.4 41.4z"/></svg>
            <div class="header-areas-box">
                <?php if( $plumbing_technician_header_layout_email_address ){ ?>
                    <p><a href="mailto:<?php echo esc_attr( $plumbing_technician_header_layout_email_address ); ?>"><?php echo esc_html( $plumbing_technician_header_layout_email_address ); ?></a></p>
                <?php } ?>
            </div>
        </div>
        <div class="theme-header-areas header-areas-right">
            <svg xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 384 512"><!--! Font Awesome Free 6.4.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2023 Fonticons, Inc. --><path d="M172.268 501.67C26.97 291.031 0 269.413 0 192 0 85.961 85.961 0 192 0s192 85.961 192 192c0 77.413-26.97 99.031-172.268 309.67-9.535 13.774-29.93 13.773-39.464 0zM192 272c44.183 0 80-35.817 80-80s-35.817-80-80-80-80 35.817-80 80 35.817 80 80 80z"/></svg>
            <div class="header-areas-box">
                <?php if( $plumbing_technician_header_layout_location_address ){ ?>
                    <p><?php echo esc_html( $plumbing_technician_header_layout_location_address ); ?></p>
                <?php } ?>
            </div>
        </div>
        <div class="theme-header-areas header-areas-right">
            <svg xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 512 512"><!--! Font Awesome Free 6.4.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2023 Fonticons, Inc. --><path d="M256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8zm0 448c-110.5 0-200-89.5-200-200S145.5 56 256 56s200 89.5 200 200-89.5 200-200 200zm61.8-104.4l-84.9-61.7c-3.1-2.3-4.9-5.9-4.9-9.7V116c0-6.6 5.4-12 12-12h32c6.6 0 12 5.4 12 12v141.7l66.8 48.6c5.4 3.9 6.5 11.4 2.6 16.8L334.6 349c-3.9 5.3-11.4 6.5-16.8 2.6z"/></svg>
            <div class="header-areas-box">
                <?php if( $plumbing_technician_header_layout_working_hour ){ ?>
                    <p><?php echo esc_html( $plumbing_technician_header_layout_working_hour ); ?></p>
                <?php } ?>
            </div>
        </div>
    </div>
</section>