<?php
/**
 * The default template for displaying content
 * @package Plumbing Technician
 * @since 1.0.0
 */

$plumbing_technician_default = plumbing_technician_get_default_theme_options();
$plumbing_technician_image_size = get_theme_mod('plumbing_technician_archive_image_size', 'medium');
global $plumbing_technician_archive_first_class; 
$plumbing_technician_archive_classes = [
    'theme-article-post',
    'theme-article-animate',
    $plumbing_technician_archive_first_class
];?>

<article id="post-<?php the_ID(); ?>" <?php post_class($plumbing_technician_archive_classes); ?>>
    <div class="theme-article-image">
        <?php if ( get_theme_mod('plumbing_technician_display_archive_post_image', true) == true ) : ?>
            <div class="entry-thumbnail">
                <?php
                if ( is_search() || is_archive() || is_front_page() ) {

                    $plumbing_technician_image_size = get_theme_mod('plumbing_technician_archive_image_size', 'medium');

                    $plumbing_technician_image_size_class_map = array(
                        'full'      => 'data-bg-large',
                        'large'     => 'data-bg-big',
                        'medium'    => 'data-bg-medium',
                        'small'     => 'data-bg-small',
                        'xsmall'    => 'data-bg-xsmall',
                        'thumbnail' => 'data-bg-thumbnail',
                    );

                    $plumbing_technician_image_size_class = isset( $plumbing_technician_image_size_class_map[ $plumbing_technician_image_size ] )
                        ? $plumbing_technician_image_size_class_map[ $plumbing_technician_image_size ]
                        : 'data-bg-medium';

                    if ( has_post_thumbnail() ) {
                        $plumbing_technician_featured_image = wp_get_attachment_image_src( get_post_thumbnail_id(), $plumbing_technician_image_size );
                        $plumbing_technician_featured_image = isset( $plumbing_technician_featured_image[0] ) ? $plumbing_technician_featured_image[0] : '';
                    } else {
                        $plumbing_technician_featured_image = get_template_directory_uri() . '/assets/images/service.png';
                    }
                    ?>
                    <div class="post-thumbnail data-bg <?php echo esc_attr( $plumbing_technician_image_size_class ); ?>"
                        data-background="<?php echo esc_url( $plumbing_technician_featured_image ); ?>">
                        <a href="<?php the_permalink(); ?>" class="theme-image-responsive" tabindex="0"></a>
                    </div>
                    <?php
                } else {
                    plumbing_technician_post_thumbnail( $plumbing_technician_image_size );
                }

                if ( get_theme_mod( 'plumbing_technician_display_archive_post_format_icon', true ) ) :
                    plumbing_technician_post_format_icon();
                endif;
                ?>
            </div>
        <?php endif; ?>
    </div>
    <div class="theme-article-details">
        <?php if ( get_theme_mod('plumbing_technician_display_archive_post_category', true) == true ) : ?>  
            <div class="entry-meta-top">
                <div class="entry-meta">
                    <?php plumbing_technician_entry_footer($cats = true, $tags = false, $edits = false); ?>
                </div>
            </div>
        <?php endif; ?>
        <?php if ( get_theme_mod('plumbing_technician_display_archive_post_title', true) == true ) : ?>
            <header class="entry-header">
                <h2 class="entry-title entry-title-medium">
                    <a href="<?php the_permalink(); ?>" rel="bookmark">
                        <span><?php the_title(); ?></span>
                    </a>
                </h2>
            </header>
        <?php endif; ?>
        <?php if ( get_theme_mod('plumbing_technician_display_archive_post_content', true) == true ) : ?>
            <div class="entry-content">

                <?php
                if (has_excerpt()) {

                    the_excerpt();

                } else {

                    echo '<p>';
                    echo esc_html(wp_trim_words(get_the_content(), get_theme_mod('plumbing_technician_excerpt_limit', 20), '...'));
                    echo '</p>';
                }

                wp_link_pages(array(
                    'before' => '<div class="page-links">' . esc_html__('Pages:', 'plumbing-technician'),
                    'after' => '</div>',
                )); ?>
            </div>
        <?php endif; ?>
        <?php if ( get_theme_mod('plumbing_technician_display_archive_post_button', true) == true ) : ?>
            <a href="<?php the_permalink(); ?>" rel="bookmark" class="theme-btn-link">
            <span> <?php esc_html_e('Read More', 'plumbing-technician'); ?> </span>
            <span class="topbar-info-icon"><?php plumbing_technician_the_theme_svg('arrow-right-1'); ?></span>
            </a>
        <?php endif; ?>
    </div>
</article>