<?php
/**
 * The template for displaying single posts and pages.
 * @package Plumbing Technician
 * @since 1.0.0
 */

get_header();

$plumbing_technician_default = plumbing_technician_get_default_theme_options();
$plumbing_technician_global_layout = get_theme_mod('plumbing_technician_global_sidebar_layout', $plumbing_technician_default['plumbing_technician_global_sidebar_layout']);
$plumbing_technician_page_layout = get_theme_mod('plumbing_technician_page_sidebar_layout', $plumbing_technician_global_layout);
$plumbing_technician_post_layout = get_theme_mod('plumbing_technician_post_sidebar_layout', $plumbing_technician_global_layout);
$plumbing_technician_post_meta = get_post_meta(get_the_ID(), 'plumbing_technician_post_sidebar_option', true);

$plumbing_technician_final_layout = $plumbing_technician_global_layout;
if (!empty($plumbing_technician_post_meta) && $plumbing_technician_post_meta !== 'default') {
    $plumbing_technician_final_layout = $plumbing_technician_post_meta;
} elseif (is_page() || (function_exists('is_shop') && is_shop())) {
    $plumbing_technician_final_layout = $plumbing_technician_page_layout;
} elseif (is_single()) {
    $plumbing_technician_final_layout = $plumbing_technician_post_layout;
}

// Set content column order based on sidebar layout
$plumbing_technician_sidebar_column_class = 'column-order-1';
if ($plumbing_technician_final_layout === 'left-sidebar') {
    $plumbing_technician_sidebar_column_class = 'column-order-2';
}

?>

<div id="single-page" class="singular-main-block">
    <div class="wrapper">
        <div class="column-row <?php echo esc_attr($plumbing_technician_final_layout === 'no-sidebar' ? 'no-sidebar-layout' : ''); ?>">

            <?php if ($plumbing_technician_final_layout === 'left-sidebar') : ?>
                <?php get_sidebar(); ?>
            <?php endif; ?>

            <div id="primary" class="content-area <?php echo esc_attr($plumbing_technician_final_layout === 'no-sidebar' ? 'full-width-content' : $plumbing_technician_sidebar_column_class); ?>">
                <main id="site-content" role="main">

                    <?php
                    plumbing_technician_breadcrumb(); // Display breadcrumb

                    if (have_posts()) : ?>

                        <div class="article-wraper">
                            <?php while (have_posts()) : the_post(); ?>

                                <?php get_template_part('template-parts/content', 'single'); ?>

                                <?php if ((is_single() || is_page()) && (comments_open() || get_comments_number()) && !post_password_required()) : ?>
                                    <div class="comments-wrapper">
                                        <?php comments_template(); ?>
                                    </div>
                                <?php endif; ?>

                            <?php endwhile; ?>
                        </div>

                    <?php else : ?>

                        <?php get_template_part('template-parts/content', 'none'); ?>

                    <?php endif;

                    do_action('plumbing_technician_navigation_action');
                    ?>

                </main>
            </div>

            <?php if ($plumbing_technician_final_layout === 'right-sidebar') : ?>
                <?php get_sidebar(); ?>
            <?php endif; ?>

        </div>
    </div>
</div>

<?php get_footer(); ?>