<?php
$plumbing_technician_layout = plumbing_technician_get_final_sidebar_layout();
$plumbing_technician_sidebar_class = 'column-order-1';

if ( $plumbing_technician_layout === 'left-sidebar' ) {
    $plumbing_technician_sidebar_class = 'column-order-1';
} elseif ( $plumbing_technician_layout === 'right-sidebar' ) {
    $plumbing_technician_sidebar_class = 'column-order-2';
}

if ( $plumbing_technician_layout !== 'no-sidebar' ) : ?>
    <aside id="secondary" class="widget-area <?php echo esc_attr( $plumbing_technician_sidebar_class ); ?>">
        <div class="widget-area-wrapper">
            <?php if ( is_active_sidebar('sidebar-1') ) : ?>
                <?php dynamic_sidebar( 'sidebar-1' ); ?>
            <?php else : ?>
                <!-- Default widgets -->
                <div class="widget widget_block widget_search">
                    <h3 class="widget-title"><?php esc_html_e('Search', 'plumbing-technician'); ?></h3>
                    <?php get_search_form(); ?>
                </div>

                <div class="widget widget_pages">
                    <h3 class="widget-title"><?php esc_html_e('Pages', 'plumbing-technician'); ?></h3>
                    <ul>
                        <?php
                        wp_list_pages(array(
                            'title_li' => '',
                        ));
                        ?>
                    </ul>
                </div>

                <div class="widget widget_archive">
                    <h3 class="widget-title"><?php esc_html_e('Archives', 'plumbing-technician'); ?></h3>
                    <ul>
                        <?php wp_get_archives(['type' => 'monthly', 'show_post_count' => true]); ?>
                    </ul>
                </div>

                <div class="widget widget_categories">
                    <h3 class="widget-title"><?php esc_html_e('Categories', 'plumbing-technician'); ?></h3>
                    <ul class="wp-block-categories-list wp-block-categories">
                        <?php wp_list_categories(['orderby' => 'name', 'title_li' => '', 'show_count' => true]); ?>
                    </ul>
                </div>

                <div class="widget widget_tag_cloud">
                    <h3 class="widget-title"><?php esc_html_e('Tags', 'plumbing-technician'); ?></h3>
                    <?php
                    $plumbing_technician_tags = get_tags();
                    if ( $plumbing_technician_tags ) {
                        echo '<div class="tagcloud">';
                        foreach ( $plumbing_technician_tags as $plumbing_technician_tag ) {
                            $plumbing_technician_link = get_tag_link($plumbing_technician_tag->term_id);
                            echo '<a href="' . esc_url($plumbing_technician_link) . '" class="tag-cloud-link">' . esc_html($plumbing_technician_tag->name) . '</a> ';
                        }
                        echo '</div>';
                    } else {
                        echo '<p>' . esc_html__('No tags found.', 'plumbing-technician') . '</p>';
                    }
                    ?>
                </div>

            <?php endif; ?>
        </div>
    </aside>
<?php endif; ?>
