<?php
/**
* Widget Functions.
*
* @package Plumbing Technician
*/

function plumbing_technician_widgets_init(){

	register_sidebar(array(
	    'name' => esc_html__('Main Sidebar', 'plumbing-technician'),
	    'id' => 'sidebar-1',
	    'description' => esc_html__('Add widgets here.', 'plumbing-technician'),
	    'before_widget' => '<div id="%1$s" class="widget %2$s">',
	    'after_widget' => '</div>',
	    'before_title' => '<h3 class="widget-title"><span>',
	    'after_title' => '</span></h3>',
	));


    $plumbing_technician_default = plumbing_technician_get_default_theme_options();
    $plumbing_technician_footer_column_layout = absint( get_theme_mod( 'plumbing_technician_footer_column_layout',$plumbing_technician_default['plumbing_technician_footer_column_layout'] ) );

    for( $i = 0; $i < $plumbing_technician_footer_column_layout; $i++ ){
    	
    	if( $i == 0 ){ $count = esc_html__('One','plumbing-technician'); }
    	if( $i == 1 ){ $count = esc_html__('Two','plumbing-technician'); }
    	if( $i == 2 ){ $count = esc_html__('Three','plumbing-technician'); }

	    register_sidebar( array(
	        'name' => esc_html__('Footer Widget ', 'plumbing-technician').$count,
	        'id' => 'plumbing-technician-footer-widget-'.$i,
	        'description' => esc_html__('Add widgets here.', 'plumbing-technician'),
	        'before_widget' => '<div id="%1$s" class="widget %2$s">',
	        'after_widget' => '</div>',
	        'before_title' => '<h2 class="widget-title">',
	        'after_title' => '</h2>',
	    ));
	}

}

add_action('widgets_init', 'plumbing_technician_widgets_init');