<?php
/**
 *
 * Pagination Functions
 *
 * @package  Plumbing Technician
 */

/**
 * Pagination for archive.
 */
function plumbing_technician_render_posts_pagination() {
    // Get the setting to check if pagination is enabled
    $plumbing_technician_is_pagination_enabled = get_theme_mod( 'plumbing_technician_enable_pagination', true );

    // Check if pagination is enabled
    if ( $plumbing_technician_is_pagination_enabled ) {
        // Get the selected pagination type from the Customizer
        $plumbing_technician_pagination_type = get_theme_mod( 'plumbing_technician_theme_pagination_type', 'numeric' );

        // Check if the pagination type is "newer_older" (Previous/Next) or "numeric"
        if ( 'newer_older' === $plumbing_technician_pagination_type ) :
            // Display "Newer/Older" pagination (Previous/Next navigation)
            the_posts_navigation(
                array(
                    'prev_text' => __( '&laquo; Newer', 'plumbing-technician' ),  // Change the label for "previous"
                    'next_text' => __( 'Older &raquo;', 'plumbing-technician' ),  // Change the label for "next"
                    'screen_reader_text' => __( 'Posts navigation', 'plumbing-technician' ),
                )
            );
        else :
            // Display numeric pagination (Page numbers)
            the_posts_pagination(
                array(
                    'prev_text' => __( '&laquo; Previous', 'plumbing-technician' ),
                    'next_text' => __( 'Next &raquo;', 'plumbing-technician' ),
                    'type'      => 'list', // Display as <ul> <li> tags
                    'screen_reader_text' => __( 'Posts navigation', 'plumbing-technician' ),
                )
            );
        endif;
    }
}
add_action( 'plumbing_technician_posts_pagination', 'plumbing_technician_render_posts_pagination', 10 );