<?php
/**
 * Settings for demo import
 *
 */

/**
 * Define constants
 **/
if ( ! defined( 'WHIZZIE_DIR' ) ) {
	define( 'WHIZZIE_DIR', dirname( __FILE__ ) );
}
require trailingslashit( WHIZZIE_DIR ) . 'homepage-setup-contents.php';
$plumbing_technician_current_theme = wp_get_theme();
$plumbing_technician_theme_title = $plumbing_technician_current_theme->get( 'Name' );


/**
 * Make changes below
 **/

// Change the title and slug of your wizard page
$config['plumbing_technician_page_slug'] 	= 'plumbing-technician';
$config['plumbing_technician_page_title']	= 'Homepage Setup';

$config['steps'] = array(
	'widgets' => array(
		'id'			=> 'widgets',
		'title'			=> __( 'Setup Home Page', 'plumbing-technician' ),
		'icon'			=> 'welcome-widgets-menus',
		'button_text'	=> __( 'Start Home Page Setup', 'plumbing-technician' ),
		'can_skip'		=> true
	),
	'done' => array(
		'id'			=> 'done',
		'title'			=> __( 'Customize Your Site', 'plumbing-technician' ),
		'icon'			=> 'yes',
	)
);

/**
 * This kicks off the wizard
 **/
if( class_exists( 'Plumbing_Technician_Whizzie' ) ) {
	$Plumbing_Technician_Whizzie = new Plumbing_Technician_Whizzie( $config );
}