<?php
/**
 * Wizard
 *
 * @package Plumbing_Technician_Whizzie
 * @author Catapult Themes
 * @since 1.0.0
 */

class Plumbing_Technician_Whizzie {
	
	protected $version = '1.1.0';
	
	/** @var string Current theme name, used as namespace in actions. */
	protected $plumbing_technician_theme_name = '';
	protected $plumbing_technician_theme_title = '';
	
	/** @var string Wizard page slug and title. */
	protected $plumbing_technician_page_slug = '';
	protected $plumbing_technician_page_title = '';
	
	/** @var array Wizard steps set by user. */
	protected $config_steps = array();
	
	public $parent_slug;
	
	/**
	 * Constructor
	 *
	 * @param $config	Our config parameters
	 */
	public function __construct( $config ) {
		$this->set_vars( $config );
		$this->init();
	}
	
	/**
	 * Set some settings
	 * @since 1.0.0
	 * @param $config	Our config parameters
	 */
	public function set_vars( $config ) {

		if( isset( $config['plumbing_technician_page_slug'] ) ) {
			$this->plumbing_technician_page_slug = esc_attr( $config['plumbing_technician_page_slug'] );
		}
		if( isset( $config['plumbing_technician_page_title'] ) ) {
			$this->plumbing_technician_page_title = esc_attr( $config['plumbing_technician_page_title'] );
		}
		if( isset( $config['steps'] ) ) {
			$this->config_steps = $config['steps'];
		}

		$plumbing_technician_current_theme = wp_get_theme();
		$this->plumbing_technician_theme_title = $plumbing_technician_current_theme->get( 'Name' );
		$this->plumbing_technician_theme_name = strtolower( preg_replace( '#[^a-zA-Z]#', '', $plumbing_technician_current_theme->get( 'Name' ) ) );
		$this->plumbing_technician_page_slug = apply_filters( $this->plumbing_technician_theme_name . '_theme_setup_wizard_plumbing_technician_page_slug', $this->plumbing_technician_theme_name . '-wizard' );
		$this->parent_slug = apply_filters( $this->plumbing_technician_theme_name . '_theme_setup_wizard_parent_slug', '' );

	}
	
	/**
	 * Hooks and filters
	 * @since 1.0.0
	 */	
	public function init() {

		add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_scripts' ) );
		add_action( 'admin_menu', array( $this, 'menu_page' ) );
		add_action( 'wp_ajax_plumbing_technician_setup_widgets', array( $this, 'plumbing_technician_setup_widgets' ) );
		
	}
	
	public function enqueue_scripts() {
		wp_enqueue_style( 'plumbing-technician-homepage-setup-style', get_template_directory_uri() . '/inc/homepage-setup/assets/css/homepage-setup-style.css');
		wp_register_script( 'plumbing-technician-homepage-setup-script', get_template_directory_uri() . '/inc/homepage-setup/assets/js/homepage-setup-script.js', array( 'jquery' ), time() );
		wp_localize_script( 
			'plumbing-technician-homepage-setup-script',
			'whizzie_params',
			array(
				'ajaxurl' 		=> admin_url( 'admin-ajax.php' ),
				'wpnonce' 		=> wp_create_nonce( 'whizzie_nonce' ),
				'verify_text'	=> esc_html( 'verifying', 'plumbing-technician' )
			)
		);
		wp_enqueue_script( 'plumbing-technician-homepage-setup-script' );
	}
	
	public static function get_instance() {
		if ( ! self::$instance ) {
			self::$instance = new self;
		}
		return self::$instance;
	}
	
	/**
	 * Make a modal screen for the wizard
	 */
	public function menu_page() {
		add_theme_page( esc_html( $this->plumbing_technician_page_title ), esc_html( $this->plumbing_technician_page_title ), 'manage_options', $this->plumbing_technician_page_slug, array( $this, 'wizard_page' ) );
	}
	
	/**
	 * Make an interface for the wizard
	 */
	public function wizard_page() {

		$url = wp_nonce_url( add_query_arg( array( 'plugins' => 'go' ) ), 'whizzie-setup' );
		$method = '';
		$fields = array_keys( $_POST );

		if ( false === ( $creds = request_filesystem_credentials( esc_url_raw( $url ), $method, false, false, $fields ) ) ) {
			return true;
		}

		if ( ! WP_Filesystem( $creds ) ) {
			request_filesystem_credentials( esc_url_raw( $url ), $method, true, false, $fields );
			return true;
		}

		$plumbing_technician_theme = wp_get_theme();
		$plumbing_technician_theme_title = $plumbing_technician_theme->get( 'Name' );
		$plumbing_technician_theme_version = $plumbing_technician_theme->get( 'Version' );

		?>
		<div class="wrap">
			<?php
				printf( '<h1>%s %s</h1>', esc_html( $plumbing_technician_theme_title ), esc_html( '(Version :- ' . $plumbing_technician_theme_version . ')' ) );
			?>
			<div class="homepage-setup">
				<div class="homepage-setup-theme-bundle">
					<div class="homepage-setup-theme-bundle-one">
						<h1><?php echo esc_html__( 'WP Theme Bundle', 'plumbing-technician' ); ?></h1>
						<p><?php echo wp_kses_post( 'Get <span>15% OFF</span> on all WordPress themes! Use code <span>"BNDL15OFF"</span> at checkout. Limited time offer!' ); ?></p>
					</div>
					<div class="homepage-setup-theme-bundle-two">
						<p><?php echo wp_kses_post( 'Extra <span>15%</span> OFF' ); ?></p>
					</div>
					<div class="homepage-setup-theme-bundle-three">
						<img src="<?php echo esc_url( get_template_directory_uri() . '/inc/homepage-setup/assets/homepage-setup-images/bundle-banner.png' ); ?>" alt="<?php echo esc_attr__( 'Theme Bundle Image', 'plumbing-technician' ); ?>">
					</div>
					<div class="homepage-setup-theme-bundle-four">
						<p><?php echo wp_kses_post( '<span>$2795</span>$69' ); ?></p>
						<a target="_blank" href="<?php echo esc_url( PLUMBING_TECHNICIAN_BUNDLE_BUTTON ); ?>"><?php echo esc_html__( 'SHOP NOW', 'plumbing-technician' ); ?> <span class="dashicons dashicons-arrow-right-alt2"></span></a>
					</div>
				</div>
			</div>
			
			<div class="card whizzie-wrap">
				<div class="demo_content_image">
					<div class="demo_content">
						<?php
							$plumbing_technician_steps = $this->get_steps();
							echo '<ul class="whizzie-menu">';
							foreach ( $plumbing_technician_steps as $plumbing_technician_step ) {
								$class = 'step step-' . esc_attr( $plumbing_technician_step['id'] );
								echo '<li data-step="' . esc_attr( $plumbing_technician_step['id'] ) . '" class="' . esc_attr( $class ) . '">';
								printf( '<h2>%s</h2>', esc_html( $plumbing_technician_step['title'] ) );

								$content = call_user_func( array( $this, $plumbing_technician_step['view'] ) );
								if ( isset( $content['summary'] ) ) {
									printf(
										'<div class="summary">%s</div>',
										wp_kses_post( $content['summary'] )
									);
								}
								if ( isset( $content['detail'] ) ) {
									printf(
										'<div class="detail">%s</div>',
										wp_kses_post( $content['detail'] )
									);
								}
								if ( isset( $plumbing_technician_step['button_text'] ) && $plumbing_technician_step['button_text'] ) {
									printf( 
										'<div class="button-wrap"><a href="#" class="button button-primary do-it" data-callback="%s" data-step="%s">%s</a></div>',
										esc_attr( $plumbing_technician_step['callback'] ),
										esc_attr( $plumbing_technician_step['id'] ),
										esc_html( $plumbing_technician_step['button_text'] )
									);
								}
								echo '</li>';
							}
							echo '</ul>';
						?>
						
						<ul class="whizzie-nav">
							<?php
							$step_number = 1;	
							foreach ( $plumbing_technician_steps as $plumbing_technician_step ) {
								echo '<li class="nav-step-' . esc_attr( $plumbing_technician_step['id'] ) . '">';
								echo '<span class="step-number">' . esc_html( $step_number ) . '</span>';
								echo '</li>';
								$step_number++;
							}
							?>
							<div class="blank-border"></div>
						</ul>

						<div class="homepage-setup-links">
							<div class="homepage-setup-links buttons">
								<a href="<?php echo esc_url( PLUMBING_TECHNICIAN_LITE_DOCS_PRO ); ?>" target="_blank" class="button button-primary"><?php echo esc_html__( 'Free Documentation', 'plumbing-technician' ); ?></a>
								<a href="<?php echo esc_url( PLUMBING_TECHNICIAN_BUY_NOW ); ?>" class="button button-primary" target="_blank"><?php echo esc_html__( 'Get Premium', 'plumbing-technician' ); ?></a>
								<a href="<?php echo esc_url( PLUMBING_TECHNICIAN_DEMO_PRO ); ?>" class="button button-primary" target="_blank"><?php echo esc_html__( 'Premium Demo', 'plumbing-technician' ); ?></a>
								<a href="<?php echo esc_url( PLUMBING_TECHNICIAN_SUPPORT_FREE ); ?>" target="_blank" class="button button-primary"><?php echo esc_html__( 'Support Forum', 'plumbing-technician' ); ?></a>
							</div>
						</div> <!-- .demo_image -->

						<div class="step-loading"><span class="spinner"></span></div>
					</div> <!-- .demo_content -->

					<div class="homepage-setup-image">
						<div class="homepage-setup-theme-buynow">
							<div class="homepage-setup-theme-buynow-one">
								<h1><?php echo wp_kses_post( 'Plumber<br>WordPress Theme' ); ?></h1>
								<p><?php echo wp_kses_post( '<span>25%<br>Off</span> SHOP NOW' ); ?></p>
							</div>
							<div class="homepage-setup-theme-buynow-two">
								<img src="<?php echo esc_url( get_template_directory_uri() . '/inc/homepage-setup/assets/homepage-setup-images/plumbing-technician.png' ); ?>" alt="<?php echo esc_attr__( 'Theme Bundle Image', 'plumbing-technician' ); ?>">
							</div>
							<div class="homepage-setup-theme-buynow-three">
								<p><?php echo wp_kses_post( 'Get <span>25% OFF</span> on Premium Plumber WordPress Theme Use code <span>"NYTHEMES25"</span> at checkout.' ); ?></p>
							</div>
							<div class="homepage-setup-theme-buynow-four">
								<a target="_blank" href="<?php echo esc_url( PLUMBING_TECHNICIAN_BUY_NOW ); ?>"><?php echo esc_html__( 'Upgrade To Pro With Just $40', 'plumbing-technician' ); ?></a>
							</div>
						</div>
					</div> <!-- .demo_image -->

				</div> <!-- .demo_content_image -->
			</div> <!-- .whizzie-wrap -->
		</div> <!-- .wrap -->
		<?php
	}


	/**
	 * Set options for the steps
	 * Incorporate any options set by the theme dev
	 * Return the array for the steps
	 * @return Array
	 */
	public function get_steps() {
		$plumbing_technician_dev_steps = $this->config_steps;
		$plumbing_technician_steps = array(
			'widgets' => array(
				'id'			=> 'widgets',
				'title'			=> __( 'Setup Home Page', 'plumbing-technician' ),
				'icon'			=> 'welcome-widgets-menus',
				'view'			=> 'get_step_widgets',
				'callback'		=> 'plumbing_technician_install_widgets',
				'button_text'	=> __( 'Start Home Page Setup', 'plumbing-technician' ),
				'can_skip'		=> false
			),
			'done' => array(
				'id'			=> 'done',
				'title'			=> __( 'Customize Your Site', 'plumbing-technician' ),
				'icon'			=> 'yes',
				'view'			=> 'get_step_done',
				'callback'		=> ''
			)
		);
		
		// Iterate through each step and replace with dev config values
		if( $plumbing_technician_dev_steps ) {
			// Configurable elements - these are the only ones the dev can update from homepage-setup-settings.php
			$can_config = array( 'title', 'icon', 'button_text', 'can_skip' );
			foreach( $plumbing_technician_dev_steps as $plumbing_technician_dev_step ) {
				// We can only proceed if an ID exists and matches one of our IDs
				if( isset( $plumbing_technician_dev_step['id'] ) ) {
					$id = $plumbing_technician_dev_step['id'];
					if( isset( $plumbing_technician_steps[$id] ) ) {
						foreach( $can_config as $element ) {
							if( isset( $plumbing_technician_dev_step[$element] ) ) {
								$plumbing_technician_steps[$id][$element] = $plumbing_technician_dev_step[$element];
							}
						}
					}
				}
			}
		}
		return $plumbing_technician_steps;
	}
	
	/**
	 * Print the content for the widgets step
	 * @since 1.1.0
	 */
	public function get_step_widgets() { ?> <?php }
	
	/**
	 * Print the content for the final step
	 */
	public function get_step_done() { ?>
		<div id="plumbing-technician-demo-setup-guid">
			<div class="customize_div">
				<div class="customize_div finish">
					<div class="customize_div finish btns">
						<h3><?php echo esc_html( 'Your Site Is Ready To View' ); ?></h3>
						<div class="btnsss">
							<a target="_blank" href="<?php echo esc_url( get_home_url() ); ?>" class="button button-primary">
								<?php esc_html_e( 'View Your Site', 'plumbing-technician' ); ?>
							</a>
							<a target="_blank" href="<?php echo esc_url( admin_url( 'customize.php' ) ); ?>" class="button button-primary">
								<?php esc_html_e( 'Customize Your Site', 'plumbing-technician' ); ?>
							</a>
							<a href="<?php echo esc_url(admin_url()); ?>" class="button button-primary">
								<?php esc_html_e( 'Finsh', 'plumbing-technician' ); ?>
							</a>
						</div>
					</div>
					<div class="plumbing-technician-setup-finish">
						<img src="<?php echo esc_url( get_template_directory_uri() . '/screenshot.png' ); ?>"/>
					</div>
				</div>
			</div>
		</div>
	<?php }


	public function plumbing_technician_customizer_nav_menu() {

		/* -+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+- Plumbing Technician Primary Menu -+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*/

		$plumbing_technician_themename = 'Plumbing Technician';
		$plumbing_technician_menuname = $plumbing_technician_themename . ' Primary Menu';
		$plumbing_technician_menulocation = 'plumbing-technician-primary-menu';
		$plumbing_technician_menu_exists = wp_get_nav_menu_object($plumbing_technician_menuname);

		if (!$plumbing_technician_menu_exists) {
			$plumbing_technician_menu_id = wp_create_nav_menu($plumbing_technician_menuname);

			// Home
			wp_update_nav_menu_item($plumbing_technician_menu_id, 0, array(
				'menu-item-title' => __('Home', 'plumbing-technician'),
				'menu-item-classes' => 'home',
				'menu-item-url' => home_url('/'),
				'menu-item-status' => 'publish'
			));

			// About
			$plumbing_technician_page_about = get_page_by_path('about');
			if($plumbing_technician_page_about){
				wp_update_nav_menu_item($plumbing_technician_menu_id, 0, array(
					'menu-item-title' => __('About', 'plumbing-technician'),
					'menu-item-classes' => 'about',
					'menu-item-url' => get_permalink($plumbing_technician_page_about),
					'menu-item-status' => 'publish'
				));
			}

			// Services
			$plumbing_technician_page_services = get_page_by_path('services');
			if($plumbing_technician_page_services){
				wp_update_nav_menu_item($plumbing_technician_menu_id, 0, array(
					'menu-item-title' => __('Services', 'plumbing-technician'),
					'menu-item-classes' => 'services',
					'menu-item-url' => get_permalink($plumbing_technician_page_services),
					'menu-item-status' => 'publish'
				));
			}

			// Shop Page (WooCommerce)
			if (class_exists('WooCommerce')) {
				$plumbing_technician_shop_page_id = wc_get_page_id('shop');
				if ($plumbing_technician_shop_page_id) {
					wp_update_nav_menu_item($plumbing_technician_menu_id, 0, array(
						'menu-item-title' => __('Shop', 'plumbing-technician'),
						'menu-item-classes' => 'shop',
						'menu-item-url' => get_permalink($plumbing_technician_shop_page_id),
						'menu-item-status' => 'publish'
					));
				}
			}

			// Blog
			$plumbing_technician_page_blog = get_page_by_path('blog');
			if($plumbing_technician_page_blog){
				wp_update_nav_menu_item($plumbing_technician_menu_id, 0, array(
					'menu-item-title' => __('Blog', 'plumbing-technician'),
					'menu-item-classes' => 'blog',
					'menu-item-url' => get_permalink($plumbing_technician_page_blog),
					'menu-item-status' => 'publish'
				));
			}

			// 404 Page
			$plumbing_technician_notfound = get_page_by_path('404 Page');
			if($plumbing_technician_notfound){
				wp_update_nav_menu_item($plumbing_technician_menu_id, 0, array(
					'menu-item-title' => __('404 Page', 'plumbing-technician'),
					'menu-item-classes' => '404',
					'menu-item-url' => get_permalink($plumbing_technician_notfound),
					'menu-item-status' => 'publish'
				));
			}

			if (!has_nav_menu($plumbing_technician_menulocation)) {
				$plumbing_technician_locations = get_theme_mod('nav_menu_locations');
				$plumbing_technician_locations[$plumbing_technician_menulocation] = $plumbing_technician_menu_id;
				set_theme_mod('nav_menu_locations', $plumbing_technician_locations);
			}
		}
	}

	
	/**
	 * Imports the Demo Content
	 * @since 1.1.0
	 */
	public function plumbing_technician_setup_widgets(){

		/* -+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+- MENUS PAGES -+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*/
		
			// Creation of home page //
			$plumbing_technician_home_content = '';
			$plumbing_technician_home_title = 'Home';
			$plumbing_technician_home = array(
					'post_type' => 'page',
					'post_title' => $plumbing_technician_home_title,
					'post_content'  => $plumbing_technician_home_content,
					'post_status' => 'publish',
					'post_author' => 1,
					'post_slug' => 'home'
			);
			$plumbing_technician_home_id = wp_insert_post($plumbing_technician_home);

			add_post_meta( $plumbing_technician_home_id, '_wp_page_template', 'frontpage.php' );

			$plumbing_technician_home = get_page_by_path( 'Home' );
			update_option( 'page_on_front', $plumbing_technician_home->ID );
			update_option( 'show_on_front', 'page' );

			// Creation of blog page //
			$plumbing_technician_blog_title = 'Blog';
			$plumbing_technician_blog_check = get_page_by_path('blog');
			if (!$plumbing_technician_blog_check) {
				$plumbing_technician_blog = array(
					'post_type'    => 'page',
					'post_title'   => $plumbing_technician_blog_title,
					'post_status'  => 'publish',
					'post_author'  => 1,
					'post_name'    => 'blog'
				);
				$plumbing_technician_blog_id = wp_insert_post($plumbing_technician_blog);

				if (!is_wp_error($plumbing_technician_blog_id)) {
					update_option('page_for_posts', $plumbing_technician_blog_id);
				}
			}

			// Creation of about page //
			$plumbing_technician_about_title = 'About';
			$plumbing_technician_about_content = 'What is Lorem Ipsum?
														Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.
														&nbsp;
														Why do we use it?
														It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout. The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters, as opposed to using Content here, content here, making it look like readable English. Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for lorem ipsum will uncover many web sites still in their infancy. Various versions have evolved over the years, sometimes by accident, sometimes on purpose (injected humour and the like).
														&nbsp;
														Where does it come from?
														There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which dont look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isnt anything embarrassing hidden in the middle of text. All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.
														&nbsp;
														Why do we use it?
														It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout. The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters, as opposed to using Content here, content here, making it look like readable English. Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for lorem ipsum will uncover many web sites still in their infancy. Various versions have evolved over the years, sometimes by accident, sometimes on purpose (injected humour and the like).
														&nbsp;
														Where does it come from?
														There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which dont look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isnt anything embarrassing hidden in the middle of text. All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.';
			$plumbing_technician_about_check = get_page_by_path('about');
			if (!$plumbing_technician_about_check) {
				$plumbing_technician_about = array(
					'post_type'    => 'page',
					'post_title'   => $plumbing_technician_about_title,
					'post_content'   => $plumbing_technician_about_content,
					'post_status'  => 'publish',
					'post_author'  => 1,
					'post_name'    => 'about'
				);
				wp_insert_post($plumbing_technician_about);
			}

			// Creation of services page //
			$plumbing_technician_services_title = 'Services';
			$plumbing_technician_services_content = 'What is Lorem Ipsum?
														Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.
														&nbsp;
														Why do we use it?
														It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout. The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters, as opposed to using Content here, content here, making it look like readable English. Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for lorem ipsum will uncover many web sites still in their infancy. Various versions have evolved over the years, sometimes by accident, sometimes on purpose (injected humour and the like).
														&nbsp;
														Where does it come from?
														There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which dont look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isnt anything embarrassing hidden in the middle of text. All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.
														&nbsp;
														Why do we use it?
														It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout. The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters, as opposed to using Content here, content here, making it look like readable English. Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for lorem ipsum will uncover many web sites still in their infancy. Various versions have evolved over the years, sometimes by accident, sometimes on purpose (injected humour and the like).
														&nbsp;
														Where does it come from?
														There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which dont look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isnt anything embarrassing hidden in the middle of text. All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.';
			$plumbing_technician_services_check = get_page_by_path('services');
			if (!$plumbing_technician_services_check) {
				$plumbing_technician_services = array(
					'post_type'    => 'page',
					'post_title'   => $plumbing_technician_services_title,
					'post_content'   => $plumbing_technician_services_content,
					'post_status'  => 'publish',
					'post_author'  => 1,
					'post_name'    => 'services'
				);
				wp_insert_post($plumbing_technician_services);
			}

			// Creation of 404 page //
			$plumbing_technician_notfound_title = '404 Page';
			$plumbing_technician_notfound = array(
				'post_type'   => 'page',
				'post_title'  => $plumbing_technician_notfound_title,
				'post_status' => 'publish',
				'post_author' => 1,
				'post_slug'   => '404'
			);
			$plumbing_technician_notfound_id = wp_insert_post($plumbing_technician_notfound);
			add_post_meta($plumbing_technician_notfound_id, '_wp_page_template', '404.php');


		/* -+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+- SLIDER POST -+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*/

			$plumbing_technician_slider_title = array('Quality Solution For Your Plumbing');
			for($plumbing_technician_i=1;$plumbing_technician_i<=1;$plumbing_technician_i++){

				$plumbing_technician_title = $plumbing_technician_slider_title[$plumbing_technician_i-1];
				$plumbing_technician_content = 'In id enim odio. Nunc aliquet diam tortor, at venenatis urna sagittis Suspendisse sodales nulla sit amet sem condimentum.';

				// Create post object
				$plumbing_technician_my_post = array(
						'post_title'    => wp_strip_all_tags( $plumbing_technician_title ),
						'post_content'  => $plumbing_technician_content,
						'post_status'   => 'publish',
						'post_type'     => 'post',
				);
				// Insert the post into the database
				$plumbing_technician_post_id = wp_insert_post( $plumbing_technician_my_post );

				wp_set_object_terms($plumbing_technician_post_id, 'Slider', 'category', true);

				wp_set_object_terms($plumbing_technician_post_id, 'Slider', 'post_tag', true);

				$plumbing_technician_image_url = get_template_directory_uri().'/inc/homepage-setup/assets/homepage-setup-images/slider-img'.$plumbing_technician_i.'.png';

				$plumbing_technician_image_name= 'slider-img'.$plumbing_technician_i.'.png';
				$upload_dir       = wp_upload_dir();
				// Set upload folder
				$plumbing_technician_image_data       = file_get_contents($plumbing_technician_image_url);
				// Get image data
				$unique_file_name = wp_unique_filename( $upload_dir['path'], $plumbing_technician_image_name );

				$plumbing_technician_filename = basename( $unique_file_name ); 
				
				// Check folder permission and define file location
				if( wp_mkdir_p( $upload_dir['path'] ) ) {
						$plumbing_technician_file = $upload_dir['path'] . '/' . $plumbing_technician_filename;
				} else {
						$plumbing_technician_file = $upload_dir['basedir'] . '/' . $plumbing_technician_filename;
				}
				// Create the image  file on the server
				// Generate unique name
				if ( ! function_exists( 'WP_Filesystem' ) ) {
					require_once( ABSPATH . 'wp-admin/includes/file.php' );
				}
				
				WP_Filesystem();
				global $wp_filesystem;
				
				if ( ! $wp_filesystem->put_contents( $plumbing_technician_file, $plumbing_technician_image_data, FS_CHMOD_FILE ) ) {
					wp_die( 'Error saving file!' );
				}
				// Check image file type
				$wp_filetype = wp_check_filetype( $plumbing_technician_filename, null );
				// Set attachment data
				$plumbing_technician_attachment = array(
						'post_mime_type' => $wp_filetype['type'],
						'post_title'     => sanitize_file_name( $plumbing_technician_filename ),
						'post_content'   => '',
						'post_type'     => 'post',
						'post_status'    => 'inherit'
				);
				// Create the attachment
				$plumbing_technician_attach_id = wp_insert_attachment( $plumbing_technician_attachment, $plumbing_technician_file, $plumbing_technician_post_id );
				// Include image.php
				require_once(ABSPATH . 'wp-admin/includes/image.php');
				// Define attachment metadata
				$plumbing_technician_attach_data = wp_generate_attachment_metadata( $plumbing_technician_attach_id, $plumbing_technician_file );
				// Assign metadata to attachment
					wp_update_attachment_metadata( $plumbing_technician_attach_id, $plumbing_technician_attach_data );
				// And finally assign featured image to post
				set_post_thumbnail( $plumbing_technician_post_id, $plumbing_technician_attach_id );

			 }


		/* -+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+- SECOND SECTION POST -+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*/

			$plumbing_technician_second_section_title = array('Professional Team','Total Project','Happy Clients','Years Experiance');
			for($plumbing_technician_i=1;$plumbing_technician_i<=4;$plumbing_technician_i++){

				$plumbing_technician_title = $plumbing_technician_second_section_title[$plumbing_technician_i-1];
				$plumbing_technician_content = 'Lorem ipsum dolor sit met elit.';

				// Create post object
				$plumbing_technician_my_post = array(
						'post_title'    => wp_strip_all_tags( $plumbing_technician_title ),
						'post_content'  => $plumbing_technician_content,
						'post_status'   => 'publish',
						'post_type'     => 'post',
				);
					// Insert the post into the database
				$plumbing_technician_post_id = wp_insert_post( $plumbing_technician_my_post );

				wp_set_object_terms($plumbing_technician_post_id, 'Second', 'category', true);

				wp_set_object_terms($plumbing_technician_post_id, 'Second', 'post_tag', true);

				$plumbing_technician_image_url = get_template_directory_uri().'/inc/homepage-setup/assets/homepage-setup-images/post-img'.$plumbing_technician_i.'.png';

				$plumbing_technician_image_name= 'post-img'.$plumbing_technician_i.'.png';
				$upload_dir       = wp_upload_dir();
				// Set upload folder
				$plumbing_technician_image_data       = file_get_contents($plumbing_technician_image_url);
				// Get image data
				$unique_file_name = wp_unique_filename( $upload_dir['path'], $plumbing_technician_image_name );

				$plumbing_technician_filename = basename( $unique_file_name ); 
				
				// Check folder permission and define file location
				if( wp_mkdir_p( $upload_dir['path'] ) ) {
						$plumbing_technician_file = $upload_dir['path'] . '/' . $plumbing_technician_filename;
				} else {
						$plumbing_technician_file = $upload_dir['basedir'] . '/' . $plumbing_technician_filename;
				}
				// Create the image  file on the server
				// Generate unique name
				if ( ! function_exists( 'WP_Filesystem' ) ) {
					require_once( ABSPATH . 'wp-admin/includes/file.php' );
				}
				
				WP_Filesystem();
				global $wp_filesystem;
				
				if ( ! $wp_filesystem->put_contents( $plumbing_technician_file, $plumbing_technician_image_data, FS_CHMOD_FILE ) ) {
					wp_die( 'Error saving file!' );
				}
				// Check image file type
				$wp_filetype = wp_check_filetype( $plumbing_technician_filename, null );
				// Set attachment data
				$plumbing_technician_attachment = array(
						'post_mime_type' => $wp_filetype['type'],
						'post_title'     => sanitize_file_name( $plumbing_technician_filename ),
						'post_content'   => '',
						'post_type'     => 'post',
						'post_status'    => 'inherit'
				);
				// Create the attachment
				$plumbing_technician_attach_id = wp_insert_attachment( $plumbing_technician_attachment, $plumbing_technician_file, $plumbing_technician_post_id );
				// Include image.php
				require_once(ABSPATH . 'wp-admin/includes/image.php');
				// Define attachment metadata
				$plumbing_technician_attach_data = wp_generate_attachment_metadata( $plumbing_technician_attach_id, $plumbing_technician_file );
				// Assign metadata to attachment
					wp_update_attachment_metadata( $plumbing_technician_attach_id, $plumbing_technician_attach_data );
				// And finally assign featured image to post
				set_post_thumbnail( $plumbing_technician_post_id, $plumbing_technician_attach_id );

			}


		/* -+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+- THIRD SECTION POST -+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*/

			$plumbing_technician_third_section_title = array('Drain Cleaning','Plumbing Design','Sewer Line Repair','Plumbing Fittings');
			for($plumbing_technician_i=1;$plumbing_technician_i<=4;$plumbing_technician_i++){

				$plumbing_technician_title = $plumbing_technician_third_section_title[$plumbing_technician_i-1];
				$plumbing_technician_content = 'Lorem ipsum dolor sit met elit.';

				// Create post object
				$plumbing_technician_my_post = array(
						'post_title'    => wp_strip_all_tags( $plumbing_technician_title ),
						'post_content'  => $plumbing_technician_content,
						'post_status'   => 'publish',
						'post_type'     => 'post',
				);
					// Insert the post into the database
				$plumbing_technician_post_id = wp_insert_post( $plumbing_technician_my_post );

				wp_set_object_terms($plumbing_technician_post_id, 'Third', 'category', true);

				wp_set_object_terms($plumbing_technician_post_id, 'Third', 'post_tag', true);

				$plumbing_technician_image_url = get_template_directory_uri().'/inc/homepage-setup/assets/homepage-setup-images/post-img'.$plumbing_technician_i.'.png';

				$plumbing_technician_image_name= 'post-img'.$plumbing_technician_i.'.png';
				$upload_dir       = wp_upload_dir();
				// Set upload folder
				$plumbing_technician_image_data       = file_get_contents($plumbing_technician_image_url);
				// Get image data
				$unique_file_name = wp_unique_filename( $upload_dir['path'], $plumbing_technician_image_name );

				$plumbing_technician_filename = basename( $unique_file_name ); 
				
				// Check folder permission and define file location
				if( wp_mkdir_p( $upload_dir['path'] ) ) {
						$plumbing_technician_file = $upload_dir['path'] . '/' . $plumbing_technician_filename;
				} else {
						$plumbing_technician_file = $upload_dir['basedir'] . '/' . $plumbing_technician_filename;
				}
				// Create the image  file on the server
				// Generate unique name
				if ( ! function_exists( 'WP_Filesystem' ) ) {
					require_once( ABSPATH . 'wp-admin/includes/file.php' );
				}
				
				WP_Filesystem();
				global $wp_filesystem;
				
				if ( ! $wp_filesystem->put_contents( $plumbing_technician_file, $plumbing_technician_image_data, FS_CHMOD_FILE ) ) {
					wp_die( 'Error saving file!' );
				}
				// Check image file type
				$wp_filetype = wp_check_filetype( $plumbing_technician_filename, null );
				// Set attachment data
				$plumbing_technician_attachment = array(
						'post_mime_type' => $wp_filetype['type'],
						'post_title'     => sanitize_file_name( $plumbing_technician_filename ),
						'post_content'   => '',
						'post_type'     => 'post',
						'post_status'    => 'inherit'
				);
				// Create the attachment
				$plumbing_technician_attach_id = wp_insert_attachment( $plumbing_technician_attachment, $plumbing_technician_file, $plumbing_technician_post_id );
				// Include image.php
				require_once(ABSPATH . 'wp-admin/includes/image.php');
				// Define attachment metadata
				$plumbing_technician_attach_data = wp_generate_attachment_metadata( $plumbing_technician_attach_id, $plumbing_technician_file );
				// Assign metadata to attachment
					wp_update_attachment_metadata( $plumbing_technician_attach_id, $plumbing_technician_attach_data );
				// And finally assign featured image to post
				set_post_thumbnail( $plumbing_technician_post_id, $plumbing_technician_attach_id );

			}


			$plumbing_technician_slider_count=array('150+','90+','200+','100+','900+','20+','130+','190+','110+');
			for($plumbing_technician_i=1;$plumbing_technician_i<=9;$plumbing_technician_i++) {
				set_theme_mod( 'plumbing_technician_header_layout_slider_count'.$plumbing_technician_i, $plumbing_technician_slider_count[$plumbing_technician_i-1] );
			}

        
        $this->plumbing_technician_customizer_nav_menu();

	    exit;
	}
}