<?php

function plumbing_technician_enqueue_fonts() {
    $plumbing_technician_default_font_content = 'Lato';
    $plumbing_technician_default_font_heading = 'Kanit';

    $plumbing_technician_font_content = esc_attr(get_theme_mod('plumbing_technician_content_typography_font', $plumbing_technician_default_font_content));
    $plumbing_technician_font_heading = esc_attr(get_theme_mod('plumbing_technician_heading_typography_font', $plumbing_technician_default_font_heading));

    $plumbing_technician_css = '';

    // Always enqueue main font
    $plumbing_technician_css .= '
    :root {
        --font-main: ' . $plumbing_technician_font_content . ', ' . (in_array($plumbing_technician_font_content, ['bitter', '']) ? 'serif' : 'sans-serif') . '!important;
    }';
    wp_enqueue_style('plumbing-technician-style-font-general', get_template_directory_uri() . '/fonts/' . $plumbing_technician_font_content . '/font.css');

    // Always enqueue header font
    $plumbing_technician_css .= '
    :root {
        --font-head: ' . $plumbing_technician_font_heading . ', ' . (in_array($plumbing_technician_font_heading, ['bitter', '']) ? 'serif' : 'sans-serif') . '!important;
    }';
    wp_enqueue_style('plumbing-technician-style-font-h', get_template_directory_uri() . '/fonts/' . $plumbing_technician_font_heading . '/font.css');

    // Add inline style
    wp_add_inline_style('plumbing-technician-style-font-general', $plumbing_technician_css);
}
add_action('wp_enqueue_scripts', 'plumbing_technician_enqueue_fonts', 50);