<?php
/**
* Typography Settings.
*
* @package Plumbing Technician
*/

$plumbing_technician_default = plumbing_technician_get_default_theme_options();

// Layout Section.
$wp_customize->add_section( 'plumbing_technician_typography_setting',
	array(
	'title'      => esc_html__( 'Typography Settings', 'plumbing-technician' ),
	'priority'   => 21,
	'capability' => 'edit_theme_options',
	'panel'      => 'plumbing_technician_theme_option_panel',
	)
);

// -----------------  Font array
$plumbing_technician_fonts = array(
    'Select'           => __('Default Font', 'plumbing-technician'),
    'bad-script' => 'Bad Script',
    'bitter'     => 'Bitter',
    'cuprum'     => 'Cuprum',
    'exo-2'      => 'Exo 2',
    'jost'       => 'Jost',
    'open-sans'  => 'Open Sans',
    'oswald'     => 'Oswald',
    'play'       => 'Play',
    'roboto'     => 'Roboto',
    'outfit'     => 'Outfit',
    'ubuntu'     => 'Ubuntu',
    'Lato'     => 'Lato',
    'Kanit'     => 'Kanit',
);

 // -----------------  General text font
 $wp_customize->add_setting( 'plumbing_technician_content_typography_font', array(
    'default'           => 'Lato',
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'plumbing_technician_radio_sanitize',
) );
$wp_customize->add_control( 'plumbing_technician_content_typography_font', array(
    'type'     => 'select',
    'label'    => esc_html__( 'General Content Font', 'plumbing-technician' ),
    'section'  => 'plumbing_technician_typography_setting',
    'settings' => 'plumbing_technician_content_typography_font',
    'choices'  => $plumbing_technician_fonts,
) );

 // -----------------  General Heading Font
$wp_customize->add_setting( 'plumbing_technician_heading_typography_font', array(
    'default'           => 'Kanit',
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'plumbing_technician_radio_sanitize',
) );
$wp_customize->add_control( 'plumbing_technician_heading_typography_font', array(
    'type'     => 'select',
    'label'    => esc_html__( 'General Heading Font', 'plumbing-technician' ),
    'section'  => 'plumbing_technician_typography_setting',
    'settings' => 'plumbing_technician_heading_typography_font',
    'choices'  => $plumbing_technician_fonts,
) );