<?php
/**
* Custom Functions.
*
* @package Plumbing Technician
*/

if( !function_exists( 'plumbing_technician_sanitize_sidebar_option' ) ) :

    // Sidebar Option Sanitize.
    function plumbing_technician_sanitize_sidebar_option( $plumbing_technician_input ){
        $plumbing_technician_metabox_options = array( 'global-sidebar','left-sidebar','right-sidebar','no-sidebar' );
        if( in_array( $plumbing_technician_input,$plumbing_technician_metabox_options ) ){

            return $plumbing_technician_input;

        }
        return;
    }

endif;

if ( ! function_exists( 'plumbing_technician_sanitize_checkbox' ) ) :

	/**
	 * Sanitize checkbox.
	 */
	function plumbing_technician_sanitize_checkbox( $plumbing_technician_checked ) {

		return ( ( isset( $plumbing_technician_checked ) && true === $plumbing_technician_checked ) ? true : false );

	}

endif;


if ( ! function_exists( 'plumbing_technician_sanitize_select' ) ) :

    /**
     * Sanitize select.
     */
    function plumbing_technician_sanitize_select( $plumbing_technician_input, $plumbing_technician_setting ) {
        $plumbing_technician_input = sanitize_text_field( $plumbing_technician_input );
        $choices = $plumbing_technician_setting->manager->get_control( $plumbing_technician_setting->id )->choices;
        return ( array_key_exists( $plumbing_technician_input, $choices ) ? $plumbing_technician_input : $plumbing_technician_setting->default );
    }

endif;