<?php
/**
* Posts Settings.
*
* @package Plumbing Technician
*/

$plumbing_technician_default = plumbing_technician_get_default_theme_options();

// Single Post Section.
$wp_customize->add_section( 'plumbing_technician_single_posts_settings',
    array(
    'title'      => esc_html__( 'Single Meta Information Settings', 'plumbing-technician' ),
    'priority'   => 35,
    'capability' => 'edit_theme_options',
    'panel'      => 'plumbing_technician_theme_option_panel',
    )
);

$wp_customize->add_setting('plumbing_technician_display_single_post_image',
    array(
        'default' => $plumbing_technician_default['plumbing_technician_display_single_post_image'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'plumbing_technician_sanitize_checkbox',
    )
);
$wp_customize->add_control('plumbing_technician_display_single_post_image',
    array(
        'label' => esc_html__('Enable Single Posts Image', 'plumbing-technician'),
        'section' => 'plumbing_technician_single_posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('plumbing_technician_post_author',
    array(
        'default' => $plumbing_technician_default['plumbing_technician_post_author'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'plumbing_technician_sanitize_checkbox',
    )
);
$wp_customize->add_control('plumbing_technician_post_author',
    array(
        'label' => esc_html__('Enable Posts Author', 'plumbing-technician'),
        'section' => 'plumbing_technician_single_posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('plumbing_technician_post_date',
    array(
        'default' => $plumbing_technician_default['plumbing_technician_post_date'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'plumbing_technician_sanitize_checkbox',
    )
);
$wp_customize->add_control('plumbing_technician_post_date',
    array(
        'label' => esc_html__('Enable Posts Date', 'plumbing-technician'),
        'section' => 'plumbing_technician_single_posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('plumbing_technician_post_category',
    array(
        'default' => $plumbing_technician_default['plumbing_technician_post_category'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'plumbing_technician_sanitize_checkbox',
    )
);
$wp_customize->add_control('plumbing_technician_post_category',
    array(
        'label' => esc_html__('Enable Posts Category', 'plumbing-technician'),
        'section' => 'plumbing_technician_single_posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('plumbing_technician_post_tags',
    array(
        'default' => $plumbing_technician_default['plumbing_technician_post_tags'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'plumbing_technician_sanitize_checkbox',
    )
);
$wp_customize->add_control('plumbing_technician_post_tags',
    array(
        'label' => esc_html__('Enable Posts Tags', 'plumbing-technician'),
        'section' => 'plumbing_technician_single_posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting( 'plumbing_technician_single_page_content_alignment',
    array(
    'default'           => $plumbing_technician_default['plumbing_technician_single_page_content_alignment'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'plumbing_technician_sanitize_page_content_alignment',
    )
);
$wp_customize->add_control( 'plumbing_technician_single_page_content_alignment',
    array(
    'label'       => esc_html__( 'Single Page Content Alignment', 'plumbing-technician' ),
    'section'     => 'plumbing_technician_single_posts_settings',
    'type'        => 'select',
    'choices'     => array(
        'left' => esc_html__( 'Left', 'plumbing-technician' ),
        'center'  => esc_html__( 'Center', 'plumbing-technician' ),
        'right'    => esc_html__( 'Right', 'plumbing-technician' ),
        ),
    )
);

$wp_customize->add_setting( 'plumbing_technician_single_post_content_alignment',
    array(
    'default'           => $plumbing_technician_default['plumbing_technician_single_post_content_alignment'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'plumbing_technician_sanitize_page_content_alignment',
    )
);
$wp_customize->add_control( 'plumbing_technician_single_post_content_alignment',
    array(
    'label'       => esc_html__( 'Single Post Content Alignment', 'plumbing-technician' ),
    'section'     => 'plumbing_technician_single_posts_settings',
    'type'        => 'select',
    'choices'     => array(
        'left' => esc_html__( 'Left', 'plumbing-technician' ),
        'center'  => esc_html__( 'Center', 'plumbing-technician' ),
        'right'    => esc_html__( 'Right', 'plumbing-technician' ),
        ),
    )
);

// Archive Post Section.
$wp_customize->add_section( 'plumbing_technician_posts_settings',
    array(
    'title'      => esc_html__( 'Archive Meta Information Settings', 'plumbing-technician' ),
    'priority'   => 36,
    'capability' => 'edit_theme_options',
    'panel'      => 'plumbing_technician_theme_option_panel',
    )
);

$wp_customize->add_setting('plumbing_technician_display_archive_post_format_icon',
    array(
        'default' => $plumbing_technician_default['plumbing_technician_display_archive_post_format_icon'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'plumbing_technician_sanitize_checkbox',
    )
);
$wp_customize->add_control('plumbing_technician_display_archive_post_format_icon',
    array(
        'label' => esc_html__('Enable Posts Format Icon', 'plumbing-technician'),
        'section' => 'plumbing_technician_posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('plumbing_technician_display_archive_post_image',
    array(
        'default' => $plumbing_technician_default['plumbing_technician_display_archive_post_image'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'plumbing_technician_sanitize_checkbox',
    )
);
$wp_customize->add_control('plumbing_technician_display_archive_post_image',
    array(
        'label' => esc_html__('Enable Posts Image', 'plumbing-technician'),
        'section' => 'plumbing_technician_posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('plumbing_technician_display_archive_post_category',
    array(
        'default' => $plumbing_technician_default['plumbing_technician_display_archive_post_category'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'plumbing_technician_sanitize_checkbox',
    )
);
$wp_customize->add_control('plumbing_technician_display_archive_post_category',
    array(
        'label' => esc_html__('Enable Posts Category', 'plumbing-technician'),
        'section' => 'plumbing_technician_posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('plumbing_technician_display_archive_post_title',
    array(
        'default' => $plumbing_technician_default['plumbing_technician_display_archive_post_title'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'plumbing_technician_sanitize_checkbox',
    )
);
$wp_customize->add_control('plumbing_technician_display_archive_post_title',
    array(
        'label' => esc_html__('Enable Posts Title', 'plumbing-technician'),
        'section' => 'plumbing_technician_posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('plumbing_technician_display_archive_post_content',
    array(
        'default' => $plumbing_technician_default['plumbing_technician_display_archive_post_content'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'plumbing_technician_sanitize_checkbox',
    )
);
$wp_customize->add_control('plumbing_technician_display_archive_post_content',
    array(
        'label' => esc_html__('Enable Posts Content', 'plumbing-technician'),
        'section' => 'plumbing_technician_posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('plumbing_technician_display_archive_post_button',
    array(
        'default' => $plumbing_technician_default['plumbing_technician_display_archive_post_button'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'plumbing_technician_sanitize_checkbox',
    )
);
$wp_customize->add_control('plumbing_technician_display_archive_post_button',
    array(
        'label' => esc_html__('Enable Posts Button', 'plumbing-technician'),
        'section' => 'plumbing_technician_posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('plumbing_technician_excerpt_limit',
    array(
        'default'           => $plumbing_technician_default['plumbing_technician_excerpt_limit'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'plumbing_technician_sanitize_number_range',
    )
);
$wp_customize->add_control('plumbing_technician_excerpt_limit',
    array(
        'label'       => esc_html__('Blog Posts Excerpt limit', 'plumbing-technician'),
        'section'     => 'plumbing_technician_posts_settings',
        'type'        => 'number',
        'input_attrs' => array(
           'min'   => 1,
           'max'   => 100,
           'step'   => 1,
        ),
    )
);

$wp_customize->add_setting( 'plumbing_technician_archive_image_size',
	array(
	'default'           => 'medium',
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'plumbing_technician_sanitize_select',
	)
);
$wp_customize->add_control( 'plumbing_technician_archive_image_size',
	array(
	'label'       => esc_html__( 'Blog Posts Image Size', 'plumbing-technician' ),
	'section'     => 'plumbing_technician_posts_settings',
	'type'        => 'select',
	'choices'               => array(
		'full' => esc_html__( 'Large Size Image', 'plumbing-technician' ),
		'large' => esc_html__( 'Big Size Image', 'plumbing-technician' ),
		'medium' => esc_html__( 'Medium Size Image', 'plumbing-technician' ),
		'small' => esc_html__( 'Small Size Image', 'plumbing-technician' ),
		'xsmall' => esc_html__( 'Extra Small Size Image', 'plumbing-technician' ),
		'thumbnail' => esc_html__( 'Thumbnail Size Image', 'plumbing-technician' ),
	    ),
	)
);

$wp_customize->add_setting('plumbing_technician_posts_per_columns',
    array(
    'default'           => '3',
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'plumbing_technician_sanitize_number_range',
    )
);
$wp_customize->add_control('plumbing_technician_posts_per_columns',
    array(
    'label'       => esc_html__('Blog Posts Per Column', 'plumbing-technician'),
    'section'     => 'plumbing_technician_posts_settings',
    'type'        => 'number',
    'input_attrs' => array(
    'min'   => 1,
    'max'   => 5,
    'step'   => 1,
    ),
    )
);