<?php
/**
* Noting Found Page Settings.
*
* @package Plumbing Technician
*/

$plumbing_technician_default = plumbing_technician_get_default_theme_options();

$wp_customize->add_section( 'plumbing_technician_noting_found_page_settings',
    array(
        'title'      => esc_html__( 'Nothing Found Page Settings', 'plumbing-technician' ),
        'priority'   => 200,
        'capability' => 'edit_theme_options',
        'panel'      => 'plumbing_technician_theme_addons_panel',
    )
);

$wp_customize->add_setting( 'plumbing_technician_noting_found_main_title',
    array(
        'default'           => 'Nothing Found',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'plumbing_technician_noting_found_main_title',
    array(
        'label'    => esc_html__( 'Main Title', 'plumbing-technician' ),
        'section'  => 'plumbing_technician_noting_found_page_settings',
        'type'     => 'text',
    )
);

$wp_customize->add_setting( 'plumbing_technician_noting_found_para',
    array(
        'default'           => 'Sorry, but nothing matched your search terms. Please try again with some different keywords.',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'plumbing_technician_noting_found_para',
    array(
        'label'    => esc_html__( 'Para Text', 'plumbing-technician' ),
        'section'  => 'plumbing_technician_noting_found_page_settings',
        'type'     => 'text',
    )
);

$wp_customize->add_setting('plumbing_technician_noting_found_saerch',
    array(
        'default' => 1,
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'plumbing_technician_sanitize_checkbox',
    )
);
$wp_customize->add_control('plumbing_technician_noting_found_saerch',
    array(
        'label' => esc_html__('Enable/Disable Search', 'plumbing-technician'),
        'section' => 'plumbing_technician_noting_found_page_settings',
        'type' => 'checkbox',
    )
);