<?php
/**
* Layouts Settings.
*
* @package Plumbing Technician
*/

$plumbing_technician_default = plumbing_technician_get_default_theme_options();

// Layout Section.
$wp_customize->add_section( 'plumbing_technician_layout_setting',
	array(
	'title'      => esc_html__( 'Sidebar Settings', 'plumbing-technician' ),
	'priority'   => 20,
	'capability' => 'edit_theme_options',
	'panel'      => 'plumbing_technician_theme_option_panel',
	)
);

$wp_customize->add_setting( 'plumbing_technician_global_sidebar_layout',
    array(
    'default'           => $plumbing_technician_default['plumbing_technician_global_sidebar_layout'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'plumbing_technician_sanitize_sidebar_option',
    )
);
$wp_customize->add_control( 'plumbing_technician_global_sidebar_layout',
    array(
    'label'       => esc_html__( 'Global Sidebar Layout', 'plumbing-technician' ),
    'section'     => 'plumbing_technician_layout_setting',
    'type'        => 'select',
    'choices'     => array(
        'right-sidebar' => esc_html__( 'Right Sidebar', 'plumbing-technician' ),
        'left-sidebar'  => esc_html__( 'Left Sidebar', 'plumbing-technician' ),
        'no-sidebar'    => esc_html__( 'No Sidebar', 'plumbing-technician' ),
        ),
    )
);

$wp_customize->add_setting('plumbing_technician_page_sidebar_layout', array(
    'default'           => $plumbing_technician_default['plumbing_technician_global_sidebar_layout'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'plumbing_technician_sanitize_sidebar_option',
));

$wp_customize->add_control('plumbing_technician_page_sidebar_layout', array(
    'label'       => esc_html__('Single Page Sidebar Layout', 'plumbing-technician'),
    'section'     => 'plumbing_technician_layout_setting',
    'type'        => 'select',
    'choices'     => array(
        'right-sidebar' => esc_html__('Right Sidebar', 'plumbing-technician'),
        'left-sidebar'  => esc_html__('Left Sidebar', 'plumbing-technician'),
        'no-sidebar'    => esc_html__('No Sidebar', 'plumbing-technician'),
    ),
));

$wp_customize->add_setting('plumbing_technician_post_sidebar_layout', array(
    'default'           => $plumbing_technician_default['plumbing_technician_global_sidebar_layout'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'plumbing_technician_sanitize_sidebar_option',
));

$wp_customize->add_control('plumbing_technician_post_sidebar_layout', array(
    'label'       => esc_html__('Single Post Sidebar Layout', 'plumbing-technician'),
    'section'     => 'plumbing_technician_layout_setting',
    'type'        => 'select',
    'choices'     => array(
        'right-sidebar' => esc_html__('Right Sidebar', 'plumbing-technician'),
        'left-sidebar'  => esc_html__('Left Sidebar', 'plumbing-technician'),
        'no-sidebar'    => esc_html__('No Sidebar', 'plumbing-technician'),
    ),
));

$wp_customize->add_setting('plumbing_technician_sticky_sidebar',
    array(
        'default'           => true,
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'plumbing_technician_sanitize_checkbox',
    )
);
$wp_customize->add_control('plumbing_technician_sticky_sidebar',
    array(
        'label' => esc_html__('Enable/Disable Sticky Sidebar', 'plumbing-technician'),
        'section' => 'plumbing_technician_layout_setting',
        'type' => 'checkbox',
    )
);