<?php
/**
* Header Banner Options.
*
* @package Plumbing Technician
*/

$plumbing_technician_default = plumbing_technician_get_default_theme_options();
$plumbing_technician_post_category_list = plumbing_technician_post_category_list();

// Slider Section

$wp_customize->add_section( 'plumbing_technician_header_banner_setting',
    array(
    'title'      => esc_html__( 'Slider Settings', 'plumbing-technician' ),
    'priority'   => 10,
    'capability' => 'edit_theme_options',
    'panel'      => 'plumbing_technician_theme_home_pannel',
    )
);

// Show/Hide Site Logo
$wp_customize->add_setting('plumbing_technician_display_logo', array(
    'default'           => false,
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'plumbing_technician_sanitize_checkbox',
));
$wp_customize->add_control('plumbing_technician_display_logo', array(
    'label'    => esc_html__('Enable / Disable Site Logo', 'plumbing-technician'),
    'section'  => 'title_tagline',
    'type'     => 'checkbox',
));

// Show/Hide Site Title
$wp_customize->add_setting('plumbing_technician_display_title', array(
    'default'           => true,
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'plumbing_technician_sanitize_checkbox',
));
$wp_customize->add_control('plumbing_technician_display_title', array(
    'label'    => esc_html__('Enable / Disable Site Title', 'plumbing-technician'),
    'section'  => 'title_tagline',
    'type'     => 'checkbox',
));

// Show/Hide Site Tagline
$wp_customize->add_setting('plumbing_technician_display_header_text',
    array(
        'default'           => false,
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'plumbing_technician_sanitize_checkbox',
    )
);
$wp_customize->add_control('plumbing_technician_display_header_text',
    array(
        'label' => esc_html__('Enable / Disable Site Tagline', 'plumbing-technician'),
        'section' => 'title_tagline',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('plumbing_technician_header_banner',
    array(
        'default' => $plumbing_technician_default['plumbing_technician_header_banner'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'plumbing_technician_sanitize_checkbox',
    )
);
$wp_customize->add_control('plumbing_technician_header_banner',
    array(
        'label' => esc_html__('Enable Slider', 'plumbing-technician'),
        'section' => 'plumbing_technician_header_banner_setting',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting( 'plumbing_technician_header_banner_cat',
    array(
    'default'           => 'Slider',
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'plumbing_technician_sanitize_select',
    )
);
$wp_customize->add_control( 'plumbing_technician_header_banner_cat',
    array(
    'label'       => esc_html__( 'Slider Post Category', 'plumbing-technician' ),
    'section'     => 'plumbing_technician_header_banner_setting',
    'type'        => 'select',
    'choices'     => $plumbing_technician_post_category_list,
    )
);

// Counter Section

$wp_customize->add_section( 'plumbing_technician_header_counter_setting',
    array(
    'title'      => esc_html__( 'Our Counter Settings', 'plumbing-technician' ),
    'priority'   => 10,
    'capability' => 'edit_theme_options',
    'panel'      => 'plumbing_technician_theme_home_pannel',
    )
);

$wp_customize->add_setting('plumbing_technician_technician_counter',
    array(
        'default' => $plumbing_technician_default['plumbing_technician_technician_counter'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'plumbing_technician_sanitize_checkbox',
    )
);
$wp_customize->add_control('plumbing_technician_technician_counter',
    array(
        'label' => esc_html__('Enable Counter Section', 'plumbing-technician'),
        'section' => 'plumbing_technician_header_counter_setting',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting( 'plumbing_technician_technician_counter_cat',
    array(
    'default'           => 'Second',
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'plumbing_technician_sanitize_select',
    )
);
$wp_customize->add_control( 'plumbing_technician_technician_counter_cat',
    array(
    'label'       => esc_html__( 'Counter Post Category', 'plumbing-technician' ),
    'section'     => 'plumbing_technician_header_counter_setting',
    'type'        => 'select',
    'choices'     => $plumbing_technician_post_category_list,
    )
);

for ($i=1; $i < 9; $i++) {

    $wp_customize->add_setting( 'plumbing_technician_header_layout_slider_count'.$i,
        array(
        'default'           =>'',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control( 'plumbing_technician_header_layout_slider_count'.$i,
        array(
        'label'    => esc_html__( 'Count Number ', 'plumbing-technician' ) .$i,
        'section'  => 'plumbing_technician_header_counter_setting',
        'type'     => 'text',
        )
    );
}

// Services Section

$wp_customize->add_section( 'plumbing_technician_header_category_setting',
    array(
    'title'      => esc_html__( 'Our Services Settings', 'plumbing-technician' ),
    'priority'   => 10,
    'capability' => 'edit_theme_options',
    'panel'      => 'plumbing_technician_theme_home_pannel',
    )
);

$wp_customize->add_setting('plumbing_technician_services',
    array(
        'default' => $plumbing_technician_default['plumbing_technician_services'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'plumbing_technician_sanitize_checkbox',
    )
);
$wp_customize->add_control('plumbing_technician_services',
    array(
        'label' => esc_html__('Enable Category Section', 'plumbing-technician'),
        'section' => 'plumbing_technician_header_category_setting',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting( 'plumbing_technician_services_section_title',
    array(
    'default'           => $plumbing_technician_default['plumbing_technician_services_section_title'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'plumbing_technician_services_section_title',
    array(
    'label'    => esc_html__( 'Main Title', 'plumbing-technician' ),
    'section'  => 'plumbing_technician_header_category_setting',
    'type'     => 'text',
    )
);

$wp_customize->add_setting( 'plumbing_technician_services_section_short_title',
    array(
    'default'           => $plumbing_technician_default['plumbing_technician_services_section_short_title'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'plumbing_technician_services_section_short_title',
    array(
    'label'    => esc_html__( 'Short Title', 'plumbing-technician' ),
    'section'  => 'plumbing_technician_header_category_setting',
    'type'     => 'text',
    )
);

$wp_customize->add_setting( 'plumbing_technician_services_cat',
    array(
    'default'           => 'Third',
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'plumbing_technician_sanitize_select',
    )
);
$wp_customize->add_control( 'plumbing_technician_services_cat',
    array(
    'label'       => esc_html__( 'Services Post Category', 'plumbing-technician' ),
    'section'     => 'plumbing_technician_header_category_setting',
    'type'        => 'select',
    'choices'     => $plumbing_technician_post_category_list,
    )
);