<?php
/**
* Header Options.
*
* @package Plumbing Technician
*/

$plumbing_technician_default = plumbing_technician_get_default_theme_options();

// Header Section.
$wp_customize->add_section( 'plumbing_technician_button_header_setting',
	array(
	'title'      => esc_html__( 'Header Settings', 'plumbing-technician' ),
	'priority'   => 10,
	'capability' => 'edit_theme_options',
	'panel'      => 'plumbing_technician_theme_option_panel',
	)
);

$wp_customize->add_setting('plumbing_technician_header_search',
    array(
        'default' => $plumbing_technician_default['plumbing_technician_header_search'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'plumbing_technician_sanitize_checkbox',
    )
);
$wp_customize->add_control('plumbing_technician_header_search',
    array(
        'label' => esc_html__('Enable Search', 'plumbing-technician'),
        'section' => 'plumbing_technician_button_header_setting',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting( 'plumbing_technician_header_layout_location_address',
    array(
    'default'           => $plumbing_technician_default['plumbing_technician_header_layout_location_address'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'plumbing_technician_header_layout_location_address',
    array(
    'label'    => esc_html__( 'Header Location', 'plumbing-technician' ),
    'section'  => 'plumbing_technician_button_header_setting',
    'type'     => 'text',
    )
);

$wp_customize->add_setting( 'plumbing_technician_header_layout_email_address',
    array(
    'default'           => $plumbing_technician_default['plumbing_technician_header_layout_email_address'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'plumbing_technician_header_layout_email_address',
    array(
    'label'    => esc_html__( 'Header Email Address', 'plumbing-technician' ),
    'section'  => 'plumbing_technician_button_header_setting',
    'type'     => 'text',
    )
);

$wp_customize->add_setting( 'plumbing_technician_header_layout_working_hour',
    array(
    'default'           => $plumbing_technician_default['plumbing_technician_header_layout_working_hour'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'plumbing_technician_header_layout_working_hour',
    array(
    'label'    => esc_html__( 'Header Working Hr Text', 'plumbing-technician' ),
    'section'  => 'plumbing_technician_button_header_setting',
    'type'     => 'text',
    )
);

$wp_customize->add_setting( 'plumbing_technician_header_layout_phone_number',
    array(
    'default'           => $plumbing_technician_default['plumbing_technician_header_layout_phone_number'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'plumbing_technician_header_layout_phone_number',
    array(
    'label'    => esc_html__( 'Header Phone Number', 'plumbing-technician' ),
    'section'  => 'plumbing_technician_button_header_setting',
    'type'     => 'text',
    )
);

$wp_customize->add_setting('plumbing_technician_menu_font_size',
    array(
        'default'           => $plumbing_technician_default['plumbing_technician_menu_font_size'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'plumbing_technician_sanitize_number_range',
    )
);
$wp_customize->add_control('plumbing_technician_menu_font_size',
    array(
        'label'       => esc_html__('Menu Font Size', 'plumbing-technician'),
        'section'     => 'plumbing_technician_button_header_setting',
        'type'        => 'number',
        'input_attrs' => array(
           'min'   => 1,
           'max'   => 30,
           'step'   => 1,
        ),
    )
);

$wp_customize->add_setting( 'plumbing_technician_menu_text_transform',
    array(
    'default'           => $plumbing_technician_default['plumbing_technician_menu_text_transform'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'plumbing_technician_sanitize_menu_transform',
    )
);
$wp_customize->add_control( 'plumbing_technician_menu_text_transform',
    array(
    'label'       => esc_html__( 'Menu Text Transform', 'plumbing-technician' ),
    'section'     => 'plumbing_technician_button_header_setting',
    'type'        => 'select',
    'choices'     => array(
        'capitalize' => esc_html__( 'Capitalize', 'plumbing-technician' ),
        'uppercase'  => esc_html__( 'Uppercase', 'plumbing-technician' ),
        'lowercase'    => esc_html__( 'Lowercase', 'plumbing-technician' ),
        ),
    )
);

$wp_customize->add_setting('plumbing_technician_header_menus_color', array(
    'default'           => '',
    'sanitize_callback' => 'sanitize_hex_color',
));
$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'plumbing_technician_header_menus_color', array(
    'label'    => __('Main Menu Color', 'plumbing-technician'),
    'section'  => 'plumbing_technician_button_header_setting',
)));

$wp_customize->add_setting('plumbing_technician_header_menus_hover_color', array(
    'default'           => '',
    'sanitize_callback' => 'sanitize_hex_color',
));
$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'plumbing_technician_header_menus_hover_color', array(
    'label'    => __('Main Menu Hover Color', 'plumbing-technician'),
    'section'  => 'plumbing_technician_button_header_setting',
)));

$wp_customize->add_setting('plumbing_technician_header_submenus_color', array(
    'default'           => '',
    'sanitize_callback' => 'sanitize_hex_color',
));
$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'plumbing_technician_header_submenus_color', array(
    'label'    => __('Submenu Color', 'plumbing-technician'),
    'section'  => 'plumbing_technician_button_header_setting',
)));

$wp_customize->add_setting('plumbing_technician_header_submenus_hover_color', array(
    'default'           => '',
    'sanitize_callback' => 'sanitize_hex_color',
));
$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'plumbing_technician_header_submenus_hover_color', array(
    'label'    => __('Submenu Hover Color', 'plumbing-technician'),
    'section'  => 'plumbing_technician_button_header_setting',
)));