<?php
/**
* Global Color Settings.
*
* @package Plumbing Technician
*/

$plumbing_technician_default = plumbing_technician_get_default_theme_options();

// Layout Section.
$wp_customize->add_section( 'plumbing_technician_global_color_setting',
	array(
	'title'      => esc_html__( 'Global Color Settings', 'plumbing-technician' ),
	'priority'   => 21,
	'capability' => 'edit_theme_options',
	'panel'      => 'plumbing_technician_theme_option_panel',
	)
);

$wp_customize->add_setting( 'plumbing_technician_global_color',
    array(
    'default'           => '#217CDF',
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_hex_color',
    )
);
$wp_customize->add_control( 
    new WP_Customize_Color_Control( 
    $wp_customize, 
    'plumbing_technician_global_color',
    array(
        'label'      => esc_html__( 'Global Color', 'plumbing-technician' ),
        'section'    => 'plumbing_technician_global_color_setting',
        'settings'   => 'plumbing_technician_global_color',
    ) ) 
);
