<?php
/**
* Footer Settings.
*
* @package Plumbing Technician
*/

$plumbing_technician_default = plumbing_technician_get_default_theme_options();

$wp_customize->add_section( 'plumbing_technician_footer_widget_area',
	array(
	'title'      => esc_html__( 'Footer Settings', 'plumbing-technician' ),
	'priority'   => 200,
	'capability' => 'edit_theme_options',
	'panel'      => 'plumbing_technician_theme_option_panel',
	)
);

$wp_customize->add_setting('plumbing_technician_display_footer',
    array(
        'default' => $plumbing_technician_default['plumbing_technician_display_footer'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'plumbing_technician_sanitize_checkbox',
    )
);
$wp_customize->add_control('plumbing_technician_display_footer',
    array(
        'label' => esc_html__('Enable Footer', 'plumbing-technician'),
        'section' => 'plumbing_technician_footer_widget_area',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting( 'plumbing_technician_footer_column_layout',
	array(
	'default'           => $plumbing_technician_default['plumbing_technician_footer_column_layout'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'plumbing_technician_sanitize_select',
	)
);
$wp_customize->add_control( 'plumbing_technician_footer_column_layout',
	array(
	'label'       => esc_html__( 'Footer Column Layout', 'plumbing-technician' ),
	'section'     => 'plumbing_technician_footer_widget_area',
	'type'        => 'select',
	'choices'               => array(
		'1' => esc_html__( 'One Column', 'plumbing-technician' ),
		'2' => esc_html__( 'Two Column', 'plumbing-technician' ),
		'3' => esc_html__( 'Three Column', 'plumbing-technician' ),
	    ),
	)
);

$wp_customize->add_setting( 'plumbing_technician_footer_widget_title_alignment',
    array(
        'default'           => $plumbing_technician_default['plumbing_technician_footer_widget_title_alignment'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'plumbing_technician_sanitize_footer_widget_title_alignment',
    )
);
$wp_customize->add_control( 'plumbing_technician_footer_widget_title_alignment',
    array(
    'label'       => esc_html__( 'Footer Widget Title Alignment', 'plumbing-technician' ),
    'section'     => 'plumbing_technician_footer_widget_area',
    'type'        => 'select',
    'choices'     => array(
        'left' => esc_html__( 'Left', 'plumbing-technician' ),
        'center'  => esc_html__( 'Center', 'plumbing-technician' ),
        'right'    => esc_html__( 'Right', 'plumbing-technician' ),
        ),
    )
);

$wp_customize->add_setting( 'plumbing_technician_footer_copyright_text',
	array(
	'default'           => $plumbing_technician_default['plumbing_technician_footer_copyright_text'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control( 'plumbing_technician_footer_copyright_text',
	array(
	'label'    => esc_html__( 'Footer Copyright Text', 'plumbing-technician' ),
	'section'  => 'plumbing_technician_footer_widget_area',
	'type'     => 'text',
	)
);

$wp_customize->add_setting('plumbing_technician_copyright_font_size',
    array(
        'default'           => $plumbing_technician_default['plumbing_technician_copyright_font_size'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'plumbing_technician_sanitize_number_range',
    )
);
$wp_customize->add_control('plumbing_technician_copyright_font_size',
    array(
        'label'       => esc_html__('Copyright Font Size', 'plumbing-technician'),
        'section'     => 'plumbing_technician_footer_widget_area',
        'type'        => 'number',
        'input_attrs' => array(
           'min'   => 5,
           'max'   => 30,
           'step'   => 1,
    	),
    )
);

$wp_customize->add_setting( 'plumbing_technician_copyright_alignment', array(
    'default'           => 'Default',
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'plumbing_technician_sanitize_copyright_alignment_meta',
) );

$wp_customize->add_control( 'plumbing_technician_copyright_alignment', array(
    'label'    => esc_html__( 'Copyright Section Alignment', 'plumbing-technician' ),
    'section'  => 'plumbing_technician_footer_widget_area',
    'type'     => 'select',
    'choices'  => array(
        'Default' => esc_html__( 'Default View', 'plumbing-technician' ),
        'Reverse' => esc_html__( 'Reverse View', 'plumbing-technician' ),
        'Center'  => esc_html__( 'Centered Content', 'plumbing-technician' ),
    ),
) );

$wp_customize->add_setting( 'plumbing_technician_footer_widget_background_color', array(
    'default' => '',
    'sanitize_callback' => 'sanitize_hex_color'
));
$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'plumbing_technician_footer_widget_background_color', array(
    'label'     => __('Footer Widget Background Color', 'plumbing-technician'),
    'description' => __('It will change the complete footer widget background color.', 'plumbing-technician'),
    'section' => 'plumbing_technician_footer_widget_area',
    'settings' => 'plumbing_technician_footer_widget_background_color',
)));

$wp_customize->add_setting('footer_widget_background_image',array(
    'default'   => '',
    'sanitize_callback' => 'esc_url_raw',
));
$wp_customize->add_control( new WP_Customize_Image_Control($wp_customize,'footer_widget_background_image',array(
    'label' => __('Footer Widget Background Image','plumbing-technician'),
    'section' => 'plumbing_technician_footer_widget_area'
)));

$wp_customize->add_setting('plumbing_technician_enable_to_the_top',
    array(
        'default' => $plumbing_technician_default['plumbing_technician_enable_to_the_top'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'plumbing_technician_sanitize_checkbox',
    )
);
$wp_customize->add_control('plumbing_technician_enable_to_the_top',
    array(
        'label' => esc_html__('Enable To The Top', 'plumbing-technician'),
        'section' => 'plumbing_technician_footer_widget_area',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting( 'plumbing_technician_to_the_top_text',
    array(
    'default'           => $plumbing_technician_default['plumbing_technician_to_the_top_text'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'plumbing_technician_to_the_top_text',
    array(
    'label'    => esc_html__( 'Edit Text Here', 'plumbing-technician' ),
    'section'  => 'plumbing_technician_footer_widget_area',
    'type'     => 'text',
    )
);