<?php
/**
 * Default Values.
 *
 * @package Plumbing Technician
 */

if ( ! function_exists( 'plumbing_technician_get_default_theme_options' ) ) :
	function plumbing_technician_get_default_theme_options() {

		$plumbing_technician_defaults = array();
		
		// Options.
        $plumbing_technician_defaults['plumbing_technician_logo_width_range']                       = 200;
		$plumbing_technician_defaults['plumbing_technician_global_sidebar_layout']			      = 'right-sidebar';
        $plumbing_technician_defaults['plumbing_technician_global_color']                 = '#217CDF';
        $plumbing_technician_defaults['plumbing_technician_theme_breadcrumb_options_alignment']     = 'Left';
        $plumbing_technician_defaults['plumbing_technician_theme_pagination_options_alignment']     = 'Center';
        // social
        $plumbing_technician_defaults['plumbing_technician_header_banner_social_facebook_link']     = esc_url( 'https://www.facebook.com/', 'plumbing-technician' );
        $plumbing_technician_defaults['plumbing_technician_header_banner_social_twitter_link']      = esc_url( 'https://twitter.com/', 'plumbing-technician' );
        $plumbing_technician_defaults['plumbing_technician_header_banner_social_instagram_link']    = esc_url( 'https://www.instagram.com/', 'plumbing-technician' );
        $plumbing_technician_defaults['plumbing_technician_header_banner_social_linkdin_link']      = esc_url( 'https://linkedin.com/', 'plumbing-technician' );
        $plumbing_technician_defaults['plumbing_technician_header_banner_social_watsapp_link']      = esc_url( 'https://www.whatsapp.com/', 'plumbing-technician' );
        //Header     
        $plumbing_technician_defaults['plumbing_technician_theme_loader']                           = 0;
        $plumbing_technician_defaults['plumbing_technician_header_layout_location_address']         = esc_html__( 'Ta-134/A, Gulshan Badda LinkRd, Dhaka', 'plumbing-technician' );
        $plumbing_technician_defaults['plumbing_technician_header_layout_email_address']            = 'support@example.com';
        $plumbing_technician_defaults['plumbing_technician_header_layout_working_hour']             = 'Mon-Fri: 9.00 am - 7.00 pm';
        $plumbing_technician_defaults['plumbing_technician_header_layout_phone_number']             = '+11 231 456 7890';
        $plumbing_technician_defaults['plumbing_technician_header_search']                          = 1;

        $plumbing_technician_defaults['plumbing_technician_theme_breadcrumb_enable']                 = 1;
        $plumbing_technician_defaults['plumbing_technician_single_post_content_alignment']                 = 'left';

        $plumbing_technician_defaults['plumbing_technician_pagination_layout']                      = 'numeric';
		$plumbing_technician_defaults['plumbing_technician_footer_column_layout'] 						                  = 3;
        $plumbing_technician_defaults['plumbing_technician_menu_font_size']                         = 15;
        $plumbing_technician_defaults['plumbing_technician_copyright_font_size']                    = 16;
        $plumbing_technician_defaults['plumbing_technician_breadcrumb_font_size']                   = 16;
        $plumbing_technician_defaults['plumbing_technician_excerpt_limit']                          = 20;
        $plumbing_technician_defaults['plumbing_technician_menu_text_transform']                    = 'capitalize';
        $plumbing_technician_defaults['plumbing_technician_single_page_content_alignment']          = 'left';  
        $plumbing_technician_defaults['plumbing_technician_per_columns']                            = 3;  
        $plumbing_technician_defaults['plumbing_technician_product_per_page']                       = 9;
        $plumbing_technician_defaults['plumbing_technician_custom_related_products_number'] = 6;
        $plumbing_technician_defaults['plumbing_technician_custom_related_products_number_per_row'] = 3;
		$plumbing_technician_defaults['plumbing_technician_footer_copyright_text'] 				  = esc_html__( 'All rights reserved.', 'plumbing-technician' );
        $plumbing_technician_defaults['twp_navigation_type']              			                  = 'theme-normal-navigation';
        $plumbing_technician_defaults['plumbing_technician_post_author']                		      = 1;
        $plumbing_technician_defaults['plumbing_technician_display_archive_post_category']          = 1;
        $plumbing_technician_defaults['plumbing_technician_display_archive_post_title']             = 1;
        $plumbing_technician_defaults['plumbing_technician_display_archive_post_content']           = 1;
        $plumbing_technician_defaults['plumbing_technician_display_archive_post_button']            = 1;
        $plumbing_technician_defaults['plumbing_technician_post_date']                		      = 1;
        $plumbing_technician_defaults['plumbing_technician_post_category']                	      = 1;
        $plumbing_technician_defaults['plumbing_technician_post_tags']                		      = 1;
        $plumbing_technician_defaults['plumbing_technician_floating_next_previous_nav']             = 1;
        $plumbing_technician_defaults['plumbing_technician_header_banner']               		      = 1;
        $plumbing_technician_defaults['plumbing_technician_display_header_title']                   = 1;
        $plumbing_technician_defaults['plumbing_technician_display_header_text']                    = 1;
        
        $plumbing_technician_defaults['plumbing_technician_display_single_post_image']            = 1;
        $plumbing_technician_defaults['plumbing_technician_display_archive_post_format_icon']       = 1;

        //Services Section
        $plumbing_technician_defaults['plumbing_technician_services']               	              = 1;
        $plumbing_technician_defaults['plumbing_technician_display_footer']            = 1;
        $plumbing_technician_defaults['plumbing_technician_footer_widget_title_alignment']                 = 'left'; 
        $plumbing_technician_defaults['plumbing_technician_show_hide_related_product']          = 1;
        $plumbing_technician_defaults['plumbing_technician_display_archive_post_image']            = 1;
        $plumbing_technician_defaults['plumbing_technician_services_section_title']                 = esc_html__('Our Services That We Provide','plumbing-technician');
        $plumbing_technician_defaults['plumbing_technician_services_section_short_title']           = esc_html__('What We Do','plumbing-technician');
        //counter
        $plumbing_technician_defaults['plumbing_technician_technician_counter']           = 1;
        $plumbing_technician_defaults['plumbing_technician_background_color']               	      = '#fff';

        $plumbing_technician_defaults['plumbing_technician_enable_to_the_top']                      = 1;
        $plumbing_technician_defaults['plumbing_technician_to_the_top_text']                      = esc_html__( 'To The Top', 'plumbing-technician' );

        // 404 Page Defaults
        $plumbing_technician_defaults['plumbing_technician_404_main_title'] = esc_html__( 'Oops! That page can’t be found.', 'plumbing-technician' );
        $plumbing_technician_defaults['plumbing_technician_404_subtitle_one'] = esc_html__( 'Maybe it’s out there, somewhere...', 'plumbing-technician' );
        $plumbing_technician_defaults['plumbing_technician_404_para_one'] = esc_html__( 'You can always find insightful stories on our', 'plumbing-technician' );
        $plumbing_technician_defaults['plumbing_technician_404_subtitle_two'] = esc_html__( 'Still feeling lost? You’re not alone.', 'plumbing-technician' );
        $plumbing_technician_defaults['plumbing_technician_404_para_two'] = esc_html__( 'Enjoy these stories about getting lost, losing things, and finding what you never knew you were looking for.', 'plumbing-technician' );

		// Pass through filter.
		$plumbing_technician_defaults = apply_filters( 'plumbing_technician_filter_default_theme_options', $plumbing_technician_defaults );

		return $plumbing_technician_defaults;
	}
endif;