<?php
/**
* Customizer Custom Classes.
* @package Plumbing Technician
*/

if ( ! function_exists( 'plumbing_technician_sanitize_number_range' ) ) :
    function plumbing_technician_sanitize_number_range( $plumbing_technician_input, $plumbing_technician_setting ) {
        $plumbing_technician_input = absint( $plumbing_technician_input );
        $plumbing_technician_atts = $plumbing_technician_setting->manager->get_control( $plumbing_technician_setting->id )->input_attrs;
        $plumbing_technician_min = ( isset( $plumbing_technician_atts['min'] ) ? $plumbing_technician_atts['min'] : $plumbing_technician_input );
        $plumbing_technician_max = ( isset( $plumbing_technician_atts['max'] ) ? $plumbing_technician_atts['max'] : $plumbing_technician_input );
        $plumbing_technician_step = ( isset( $plumbing_technician_atts['step'] ) ? $plumbing_technician_atts['step'] : 1 );
        return ( $plumbing_technician_min <= $plumbing_technician_input && $plumbing_technician_input <= $plumbing_technician_max && is_int( $plumbing_technician_input / $plumbing_technician_step ) ? $plumbing_technician_input : $plumbing_technician_setting->default );
    }
endif;

/**
 * Upsell customizer section.
 *
 * @since  1.0.0
 * @access public
 */
class Plumbing_Technician_Customize_Section_Upsell extends WP_Customize_Section {

    /**
     * The type of customize section being rendered.
     *
     * @since  1.0.0
     * @access public
     * @var    string
     */
    public $type = 'upsell';

    /**
     * Custom button text to output.
     *
     * @since  1.0.0
     * @access public
     * @var    string
     */
    public $pro_text = '';

    /**
     * Custom pro button URL.
     *
     * @since  1.0.0
     * @access public
     * @var    string
     */
    public $pro_url = '';

    public $notice = '';
    public $nonotice = '';

    /**
     * Add custom parameters to pass to the JS via JSON.
     *
     * @since  1.0.0
     * @access public
     * @return void
     */
    public function json() {
        $json = parent::json();

        $json['pro_text'] = $this->pro_text;
        $json['pro_url']  = esc_url( $this->pro_url );
        $json['notice']  = esc_attr( $this->notice );
        $json['nonotice']  = esc_attr( $this->nonotice );

        return $json;
    }

    /**
     * Outputs the Underscore.js template.
     *
     * @since  1.0.0
     * @access public
     * @return void
     */
    protected function render_template() { ?>

        <li id="accordion-section-{{ data.id }}" class="accordion-section control-section control-section-{{ data.type }} cannot-expand">

            <# if ( data.notice ) { #>
                <h3 class="accordion-section-notice">
                    {{ data.title }}
                </h3>
            <# } #>

            <# if ( !data.notice ) { #>
                <h3 class="accordion-section-title">
                    {{ data.title }}

                    <# if ( data.pro_text && data.pro_url ) { #>
                        <a href="{{ data.pro_url }}" class="button button-secondary alignright" target="_blank">{{ data.pro_text }}</a>
                    <# } #>
                </h3>
            <# } #>
            
        </li>
    <?php }
}