<?php
/**
* Additional Woocommerce Settings.
*
* @package Plumbing Technician
*/

$plumbing_technician_default = plumbing_technician_get_default_theme_options();

// Additional Woocommerce Section.
$wp_customize->add_section( 'plumbing_technician_additional_woocommerce_options',
	array(
	'title'      => esc_html__( 'Additional Woocommerce Options', 'plumbing-technician' ),
	'priority'   => 210,
	'capability' => 'edit_theme_options',
	'panel'      => 'plumbing_technician_theme_option_panel',
	)
);

	$wp_customize->add_setting('plumbing_technician_per_columns',
		array(
		'default'           => $plumbing_technician_default['plumbing_technician_per_columns'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'plumbing_technician_sanitize_number_range',
		)
	);
	$wp_customize->add_control('plumbing_technician_per_columns',
		array(
		'label'       => esc_html__('Products Per Column', 'plumbing-technician'),
		'section'     => 'plumbing_technician_additional_woocommerce_options',
		'type'        => 'number',
		'input_attrs' => array(
		'min'   => 1,
		'max'   => 6,
		'step'   => 1,
		),
		)
	);

	$wp_customize->add_setting('plumbing_technician_product_per_page',
		array(
		'default'           => $plumbing_technician_default['plumbing_technician_product_per_page'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'plumbing_technician_sanitize_number_range',
		)
	);
	$wp_customize->add_control('plumbing_technician_product_per_page',
		array(
		'label'       => esc_html__('Products Per Page', 'plumbing-technician'),
		'section'     => 'plumbing_technician_additional_woocommerce_options',
		'type'        => 'number',
		'input_attrs' => array(
		'min'   => 1,
		'max'   => 100,
		'step'   => 1,
		),
		)
	);

	$wp_customize->add_setting('plumbing_technician_show_hide_related_product',
    array(
        'default' => $plumbing_technician_default['plumbing_technician_show_hide_related_product'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'plumbing_technician_sanitize_checkbox',
    )
	);
	$wp_customize->add_control('plumbing_technician_show_hide_related_product',
	    array(
	        'label' => esc_html__('Enable Related Products', 'plumbing-technician'),
	        'section' => 'plumbing_technician_additional_woocommerce_options',
	        'type' => 'checkbox',
	    )
	);

	$wp_customize->add_setting('plumbing_technician_custom_related_products_number',
		array(
		'default'           => $plumbing_technician_default['plumbing_technician_custom_related_products_number'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'plumbing_technician_sanitize_number_range',
		)
	);
	$wp_customize->add_control('plumbing_technician_custom_related_products_number',
		array(
		'label'       => esc_html__('Related Products Per Page', 'plumbing-technician'),
		'section'     => 'plumbing_technician_additional_woocommerce_options',
		'type'        => 'number',
		'input_attrs' => array(
		'min'   => 1,
		'max'   => 10,
		'step'   => 1,
		),
		)
	);

	$wp_customize->add_setting('plumbing_technician_custom_related_products_number_per_row',
		array(
		'default'           => $plumbing_technician_default['plumbing_technician_custom_related_products_number_per_row'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'plumbing_technician_sanitize_number_range',
		)
	);
	$wp_customize->add_control('plumbing_technician_custom_related_products_number_per_row',
		array(
		'label'       => esc_html__('Related Products Per Row', 'plumbing-technician'),
		'section'     => 'plumbing_technician_additional_woocommerce_options',
		'type'        => 'number',
		'input_attrs' => array(
		'min'   => 1,
		'max'   => 5,
		'step'   => 1,
		),
		)
	);