<?php
/**
* 404 Page Settings.
*
* @package Plumbing Technician
*/

$plumbing_technician_default = plumbing_technician_get_default_theme_options();

$wp_customize->add_section( 'plumbing_technician_404_page_settings',
    array(
        'title'      => esc_html__( '404 Page Settings', 'plumbing-technician' ),
        'priority'   => 200,
        'capability' => 'edit_theme_options',
        'panel'      => 'plumbing_technician_theme_addons_panel',
    )
);

$wp_customize->add_setting( 'plumbing_technician_404_main_title',
    array(
        'default'           => $plumbing_technician_default['plumbing_technician_404_main_title'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'plumbing_technician_404_main_title',
    array(
        'label'    => esc_html__( '404 Main Title', 'plumbing-technician' ),
        'section'  => 'plumbing_technician_404_page_settings',
        'type'     => 'text',
    )
);

$wp_customize->add_setting( 'plumbing_technician_404_subtitle_one',
    array(
        'default'           => $plumbing_technician_default['plumbing_technician_404_subtitle_one'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'plumbing_technician_404_subtitle_one',
    array(
        'label'    => esc_html__( '404 Sub Title One', 'plumbing-technician' ),
        'section'  => 'plumbing_technician_404_page_settings',
        'type'     => 'text',
    )
);

$wp_customize->add_setting( 'plumbing_technician_404_para_one',
    array(
        'default'           => $plumbing_technician_default['plumbing_technician_404_para_one'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'plumbing_technician_404_para_one',
    array(
        'label'    => esc_html__( '404 Para Text One', 'plumbing-technician' ),
        'section'  => 'plumbing_technician_404_page_settings',
        'type'     => 'text',
    )
);

$wp_customize->add_setting( 'plumbing_technician_404_subtitle_two',
    array(
        'default'           => $plumbing_technician_default['plumbing_technician_404_subtitle_two'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'plumbing_technician_404_subtitle_two',
    array(
        'label'    => esc_html__( '404 Sub Title Two', 'plumbing-technician' ),
        'section'  => 'plumbing_technician_404_page_settings',
        'type'     => 'text',
    )
);

$wp_customize->add_setting( 'plumbing_technician_404_para_two',
    array(
        'default'           => $plumbing_technician_default['plumbing_technician_404_para_two'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'plumbing_technician_404_para_two',
    array(
        'label'    => esc_html__( '404 Para Text Two', 'plumbing-technician' ),
        'section'  => 'plumbing_technician_404_page_settings',
        'type'     => 'text',
    )
);