<?php
/**
 * Sample implementation of the Custom Header feature
 * @package Plumbing Technician
 */

/**
 * Set up the WordPress core custom header feature.
 *
 * @uses plumbing_technician_header_style()
 */
function plumbing_technician_custom_header_setup()
{
    add_theme_support('custom-header',
        apply_filters('plumbing_technician_custom_header_args', array(
            'default-image' => '',
            'default-text-color' => '000000',
            'width' => 280,
            'height' => 1920,
            'flex-height' => true,
            'flex-width' => true,
            'wp-head-callback' => 'plumbing_technician_header_style',
        )));
}

add_action('after_setup_theme', 'plumbing_technician_custom_header_setup');

if (!function_exists('plumbing_technician_header_style')) :
    /**
     * Styles the header image and text displayed on the blog
     *
     * @see plumbing_technician_custom_header_setup().
     */
    function plumbing_technician_header_style()
    {
        $plumbing_technician_header_text_color = get_header_textcolor();

        if (get_theme_support('custom-header', 'default-text-color') === $plumbing_technician_header_text_color) {
            return;
        }

        ?>
        <style type="text/css">
            <?php
                if ( 'blank' == $plumbing_technician_header_text_color ) :
            ?>
            .header-titles .custom-logo-name,
            .site-description {
                display: none;
                position: absolute;
                clip: rect(1px, 1px, 1px, 1px);
            }

            <?php
                else :
            ?>
            .header-titles .custom-logo-name:not(:hover):not(:focus),
            .site-description {
                color: #<?php echo esc_attr( $plumbing_technician_header_text_color ); ?>;
            }

            <?php endif; ?>
        </style>
        <?php
    }
endif;