<?php
/**
 * Custom Functions.
 *
 * @package Plumbing Technician
 */

if( !function_exists( 'plumbing_technician_fonts_url' ) ) :

    //Google Fonts URL
    function plumbing_technician_fonts_url(){

        $plumbing_technician_font_families = array(
            'Kanit:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900',
            'Lato:ital,wght@0,100;0,300;0,400;0,700;0,900;1,100;1,300;1,400;1,700;1,900',
        );

        $plumbing_technician_fonts_url = add_query_arg( array(
            'family' => implode( '&family=', $plumbing_technician_font_families ),
            'display' => 'swap',
        ), 'https://fonts.googleapis.com/css2' );

        return esc_url_raw($plumbing_technician_fonts_url);

    }

endif;

if ( ! function_exists( 'plumbing_technician_sub_menu_toggle_button' ) ) :

    function plumbing_technician_sub_menu_toggle_button( $plumbing_technician_args, $plumbing_technician_item, $depth ) {

        // Add sub menu toggles to the main menu with toggles
        if ( $plumbing_technician_args->theme_location == 'plumbing-technician-primary-menu' && isset( $plumbing_technician_args->show_toggles ) ) {
            
            // Wrap the menu item link contents in a div, used for positioning
            $plumbing_technician_args->before = '<div class="submenu-wrapper">';
            $plumbing_technician_args->after  = '';

            // Add a toggle to items with children
            if ( in_array( 'menu-item-has-children', $plumbing_technician_item->classes ) ) {

                $plumbing_technician_toggle_target_string = '.menu-item.menu-item-' . $plumbing_technician_item->ID . ' > .sub-menu';

                // Add the sub menu toggle
                $plumbing_technician_args->after .= '<button type="button" class="theme-aria-button submenu-toggle" data-toggle-target="' . $plumbing_technician_toggle_target_string . '" data-toggle-type="slidetoggle" data-toggle-duration="250" aria-expanded="false"><span class="btn__content" tabindex="-1"><span class="screen-reader-text">' . esc_html__( 'Show sub menu', 'plumbing-technician' ) . '</span>' . plumbing_technician_get_theme_svg( 'chevron-down' ) . '</span></button>';

            }

            // Close the wrapper
            $plumbing_technician_args->after .= '</div><!-- .submenu-wrapper -->';
            // Add sub menu icons to the main menu without toggles (the fallback menu)

        }elseif( $plumbing_technician_args->theme_location == 'plumbing-technician-primary-menu' ) {

            if ( in_array( 'menu-item-has-children', $plumbing_technician_item->classes ) ) {

                $plumbing_technician_args->before = '<div class="link-icon-wrapper">';
                $plumbing_technician_args->after  = plumbing_technician_get_theme_svg( 'chevron-down' ) . '</div>';

            } else {

                $plumbing_technician_args->before = '';
                $plumbing_technician_args->after  = '';

            }

        }

        return $plumbing_technician_args;

    }

endif;

add_filter( 'nav_menu_item_args', 'plumbing_technician_sub_menu_toggle_button', 10, 3 );

if ( ! function_exists( 'plumbing_technician_the_theme_svg' ) ):
    
    function plumbing_technician_the_theme_svg( $plumbing_technician_svg_name, $plumbing_technician_return = false ) {

        if( $plumbing_technician_return ){

            return plumbing_technician_get_theme_svg( $plumbing_technician_svg_name ); //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- Escaped in plumbing_technician_get_theme_svg();.

        }else{

            echo plumbing_technician_get_theme_svg( $plumbing_technician_svg_name ); //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- Escaped in plumbing_technician_get_theme_svg();.

        }
    }

endif;

if ( ! function_exists( 'plumbing_technician_get_theme_svg' ) ):

    function plumbing_technician_get_theme_svg( $plumbing_technician_svg_name ) {

        // Make sure that only our allowed tags and attributes are included.
        $plumbing_technician_svg = wp_kses(
            Plumbing_Technician_SVG_Icons::get_svg( $plumbing_technician_svg_name ),
            array(
                'svg'     => array(
                    'class'       => true,
                    'xmlns'       => true,
                    'width'       => true,
                    'height'      => true,
                    'viewbox'     => true,
                    'aria-hidden' => true,
                    'role'        => true,
                    'focusable'   => true,
                ),
                'path'    => array(
                    'fill'      => true,
                    'fill-rule' => true,
                    'd'         => true,
                    'transform' => true,
                ),
                'polygon' => array(
                    'fill'      => true,
                    'fill-rule' => true,
                    'points'    => true,
                    'transform' => true,
                    'focusable' => true,
                ),
                'polyline' => array(
                    'fill'      => true,
                    'points'    => true,
                ),
                'line' => array(
                    'fill'      => true,
                    'x1'      => true,
                    'x2' => true,
                    'y1'    => true,
                    'y2' => true,
                ),
            )
        );
        if ( ! $plumbing_technician_svg ) {
            return false;
        }
        return $plumbing_technician_svg;

    }

endif;

if( !function_exists( 'plumbing_technician_post_category_list' ) ) :

    // Post Category List.
    function plumbing_technician_post_category_list( $plumbing_technician_select_cat = true ){

        $post_cat_lists = get_categories(
            array(
                'hide_empty' => '0',
                'exclude' => '1',
            )
        );

        $plumbing_technician_post_cat_cat_array = array();
        if( $plumbing_technician_select_cat ){

            $plumbing_technician_post_cat_cat_array[''] = esc_html__( '-- Select Category --','plumbing-technician' );

        }

        foreach ( $post_cat_lists as $post_cat_list ) {

            $plumbing_technician_post_cat_cat_array[$post_cat_list->slug] = $post_cat_list->name;

        }

        return $plumbing_technician_post_cat_cat_array;
    }

endif;

if( !function_exists('plumbing_technician_single_post_navigation') ):

    function plumbing_technician_single_post_navigation(){

        $plumbing_technician_default = plumbing_technician_get_default_theme_options();
        $plumbing_technician_twp_navigation_type = esc_attr( get_post_meta( get_the_ID(), 'twp_disable_ajax_load_next_post', true ) );
        $plumbing_technician_current_id = '';
        $article_wrap_class = '';
        global $post;
        $plumbing_technician_current_id = $post->ID;
        if( $plumbing_technician_twp_navigation_type == '' || $plumbing_technician_twp_navigation_type == 'global-layout' ){
            $plumbing_technician_twp_navigation_type = get_theme_mod('twp_navigation_type', $plumbing_technician_default['twp_navigation_type']);
        }

        if( $plumbing_technician_twp_navigation_type != 'no-navigation' && 'post' === get_post_type() ){

            if( $plumbing_technician_twp_navigation_type == 'theme-normal-navigation' ){ ?>

                <div class="navigation-wrapper">
                    <?php
                    // Previous/next post navigation.
                    the_post_navigation(array(
                        'prev_text' => '<span class="arrow" aria-hidden="true">' . plumbing_technician_the_theme_svg('arrow-leftplumbing_technician_',$return = true ) . '</span><span class="screen-reader-text">' . esc_html__('Previous post:', 'plumbing-technician') . '</span><span class="post-title">%title</span>',
                        'next_text' => '<span class="arrow" aria-hidden="true">' . plumbing_technician_the_theme_svg('arrow-rightplumbing_technician_',$return = true ) . '</span><span class="screen-reader-text">' . esc_html__('Next post:', 'plumbing-technician') . '</span><span class="post-title">%title</span>',
                    )); ?>
                </div>
                <?php

            }else{

                $plumbing_technician_next_post = get_next_post();
                if( isset( $plumbing_technician_next_post->ID ) ){

                    $plumbing_technician_next_post_id = $plumbing_technician_next_post->ID;
                    echo '<div loop-count="1" next-post="' . absint( $plumbing_technician_next_post_id ) . '" class="twp-single-infinity"></div>';

                }
            }

        }

    }

endif;

add_action( 'plumbing_technician_navigation_action','plumbing_technician_single_post_navigation',30 );

if( !function_exists('plumbing_technician_content_offcanvas') ):

    // Offcanvas Contents
    function plumbing_technician_content_offcanvas(){ ?>

        <div id="offcanvas-menu">
            <div class="offcanvas-wraper">
                <div class="close-offcanvas-menu">
                    <div class="offcanvas-close">
                        <a href="javascript:void(0)" class="skip-link-menu-start"></a>
                        <button type="button" class="button-offcanvas-close">
                            <span class="offcanvas-close-label">
                                <?php echo esc_html__('Close', 'plumbing-technician'); ?>
                            </span>
                        </button>
                    </div>
                </div>
                <div id="primary-nav-offcanvas" class="offcanvas-item offcanvas-main-navigation">
                    <nav class="primary-menu-wrapper" aria-label="<?php esc_attr_e('Horizontal', 'plumbing-technician'); ?>" role="navigation">
                        <ul class="primary-menu theme-menu">
                            <?php
                            if (has_nav_menu('plumbing-technician-primary-menu')) {
                                wp_nav_menu(
                                    array(
                                        'container' => '',
                                        'items_wrap' => '%3$s',
                                        'theme_location' => 'plumbing-technician-primary-menu',
                                        'show_toggles' => true,
                                    )
                                );
                            }else{

                                wp_list_pages(
                                    array(
                                        'match_menu_classes' => true,
                                        'show_sub_menu_icons' => true,
                                        'title_li' => false,
                                        'show_toggles' => true,
                                        'walker' => new Plumbing_Technician_Walker_Page(),
                                    )
                                );
                            }
                            ?>
                        </ul>
                    </nav><!-- .primary-menu-wrapper -->
                </div>
                <a href="javascript:void(0)" class="skip-link-menu-end"></a>
            </div>
        </div>

    <?php
    }

endif;

add_action( 'plumbing_technician_before_footer_content_action','plumbing_technician_content_offcanvas',30 );

if( !function_exists('plumbing_technician_footer_content_widget') ):

    function plumbing_technician_footer_content_widget(){
        
        $plumbing_technician_default = plumbing_technician_get_default_theme_options();
        
        $plumbing_technician_footer_column_layout = absint(get_theme_mod('plumbing_technician_footer_column_layout', $plumbing_technician_default['plumbing_technician_footer_column_layout']));
        $plumbing_technician_footer_sidebar_class = 12;
        
        if($plumbing_technician_footer_column_layout == 2) {
            $plumbing_technician_footer_sidebar_class = 6;
        }
        
        if($plumbing_technician_footer_column_layout == 3) {
            $plumbing_technician_footer_sidebar_class = 4;
        }
        ?>
        
        <?php if ( get_theme_mod('plumbing_technician_display_footer', true) == true ) : ?>
            <div class="footer-widgetarea">
                <div class="wrapper">
                    <div class="column-row">
                    
                        <?php for ($i = 0; $i < $plumbing_technician_footer_column_layout; $i++) : ?>
                            
                            <div class="column <?php echo 'column-' . absint($plumbing_technician_footer_sidebar_class); ?> column-sm-12">
                                
                                <?php 
                                // If no widgets are assigned, display default widgets
                                if ( ! is_active_sidebar( 'plumbing-technician-footer-widget-' . $i ) ) : 

                                    if ($i === 0) : ?>
                                        <div id="media_image-3" class="widget widget_media_image">
                                            <img src="<?php echo esc_url(get_template_directory_uri() . '/assets/images/logo.png'); ?>" alt="<?php echo esc_attr__( 'Footer Image', 'plumbing-technician' ); ?>" style="max-width: 100%; height: auto;">
                                        </div>
                                        <div id="text-3" class="widget widget_text">
                                            <div class="textwidget">
                                                <p class="widget_text">
                                                    <?php esc_html_e('Plumbing Technician is a professional and highly functional WordPress theme designed specifically for plumbers and plumbing businesses. This theme is perfect for showcasing plumbing services, whether you are an emergency plumber, 24-hour plumber, or a local plumber offering plumbing repair, plumbing services, pipe repair, leak detection, drain cleaning, plumbing installation, water heater repair, plumbing maintenance, pipe fitting, emergency plumbing, residential plumbing, commercial plumbing, plumbing inspection, faucet repair, sewer line repair, plumbing troubleshooting, installation, and maintenance.', 'plumbing-technician'); ?>
                                                </p>
                                            </div>
                                        </div>

                                    <?php elseif ($i === 1) : ?>
                                        <div id="pages-2" class="widget widget_pages">
                                            <h2 class="widget-title"><?php esc_html_e('Calendar', 'plumbing-technician'); ?></h2>
                                            <?php get_calendar(); ?>
                                        </div>

                                    <?php elseif ($i === 2) : ?>
                                        <div id="search-2" class="widget widget_search">
                                            <h2 class="widget-title"><?php esc_html_e('Enter Keywords Here', 'plumbing-technician'); ?></h2>
                                            <?php get_search_form(); ?>
                                        </div>
                                    <?php endif; 
                                    
                                else :
                                    // Display dynamic sidebar widget if assigned
                                    dynamic_sidebar('plumbing-technician-footer-widget-' . $i);
                                endif;
                                ?>
                                
                            </div>
                            
                        <?php endfor; ?>

                    </div>
                </div>
            </div>
        <?php endif; ?> 

    <?php
    }

endif;

add_action( 'plumbing_technician_footer_content_action', 'plumbing_technician_footer_content_widget', 10 );

if( !function_exists('plumbing_technician_footer_content_info') ):

    /**
     * Footer Copyright Area
    **/
    function plumbing_technician_footer_content_info(){

        $plumbing_technician_default = plumbing_technician_get_default_theme_options(); ?>
        <div class="site-info">
            <div class="wrapper">
                <div class="column-row">

                    <div class="column column-9">
                        <div class="footer-credits">

                            <div class="footer-copyright">
                                <?php
                                $plumbing_technician_footer_copyright_text = wp_kses_post( get_theme_mod( 'plumbing_technician_footer_copyright_text', $plumbing_technician_default['plumbing_technician_footer_copyright_text'] ) );
                                    echo esc_html( $plumbing_technician_footer_copyright_text );
                                    echo '<br>';
                                    echo esc_html__('Theme: ', 'plumbing-technician') . '<a href="' . esc_url('https://www.omegathemes.com/products/free-plumbing-wordpress-theme') . '" title="' . esc_attr__('Plumbing Technician ', 'plumbing-technician') . '" target="_blank"><span>' . esc_html__('Plumbing Technician ', 'plumbing-technician') . '</span></a>' . esc_html__('By ', 'plumbing-technician') . '  <span>' . esc_html__('OMEGA ', 'plumbing-technician') . '</span>';
                                    echo esc_html__('Powered by ', 'plumbing-technician') . '<a href="' . esc_url('https://wordpress.org') . '" title="' . esc_attr__('WordPress', 'plumbing-technician') . '" target="_blank"><span>' . esc_html__('WordPress.', 'plumbing-technician') . '</span></a>';
                                ?>

                            </div>
                        </div>
                    </div>


                    <div class="column column-3 align-text-right">
                        <a class="to-the-top" href="#site-header">
                            <span class="to-the-top-long">
                                <?php if ( get_theme_mod('plumbing_technician_enable_to_the_top', true) == true ) : ?>
                                    <?php
                                    $plumbing_technician_to_the_top_text = get_theme_mod( 'plumbing_technician_to_the_top_text', __( 'To the Top', 'plumbing-technician' ) );
                                    printf( 
                                        wp_kses( 
                                            /* translators: %s is the arrow icon markup */
                                            '%s %s', 
                                            array( 'span' => array( 'class' => array(), 'aria-hidden' => array() ) ) 
                                        ), 
                                        esc_html( $plumbing_technician_to_the_top_text ),
                                        '<span class="arrow" aria-hidden="true">&uarr;</span>' 
                                    );
                                    ?>
                                <?php endif; ?>
                            </span>
                        </a>

                    </div>
                </div>
            </div>
        </div>

    <?php
    }

endif;

add_action( 'plumbing_technician_footer_content_action','plumbing_technician_footer_content_info',20 );

if( !function_exists( 'plumbing_technician_main_slider' ) ) :

    function plumbing_technician_main_slider(){

        $plumbing_technician_defaults = plumbing_technician_get_default_theme_options();
        $plumbing_technician_header_banner = get_theme_mod( 'plumbing_technician_header_banner', $plumbing_technician_defaults['plumbing_technician_header_banner'] );
        $plumbing_technician_header_banner_cat = get_theme_mod( 'plumbing_technician_header_banner_cat','Slider' );

        $plumbing_technician_header_banner_social_facebook_link = esc_html( get_theme_mod( 'plumbing_technician_header_banner_social_facebook_link',
        $plumbing_technician_defaults['plumbing_technician_header_banner_social_facebook_link'] ) );

        $plumbing_technician_header_banner_social_twitter_link = esc_html( get_theme_mod( 'plumbing_technician_header_banner_social_twitter_link',
        $plumbing_technician_defaults['plumbing_technician_header_banner_social_twitter_link'] ) );

        $plumbing_technician_header_banner_social_instagram_link = esc_html( get_theme_mod( 'plumbing_technician_header_banner_social_instagram_link',
        $plumbing_technician_defaults['plumbing_technician_header_banner_social_instagram_link'] ) );

        $plumbing_technician_header_banner_social_linkdin_link = esc_html( get_theme_mod( 'plumbing_technician_header_banner_social_linkdin_link',
        $plumbing_technician_defaults['plumbing_technician_header_banner_social_linkdin_link'] ) );

        $plumbing_technician_header_banner_social_watsapp_link = esc_html( get_theme_mod( 'plumbing_technician_header_banner_social_watsapp_link',
        $plumbing_technician_defaults['plumbing_technician_header_banner_social_watsapp_link'] ) );

        $plumbing_technician_header_search = get_theme_mod( 'plumbing_technician_header_search', 
        $plumbing_technician_defaults['plumbing_technician_header_search'] );

        if( $plumbing_technician_header_banner ){

            $plumbing_technician_rtl = '';
            if( is_rtl() ){
                $plumbing_technician_rtl = 'dir="rtl"';
            }

          $plumbing_technician_banner_query = new WP_Query( array('post_type' => 'post', 'posts_per_page' => 4,'post__not_in' => get_option("sticky_posts"), 'category_name' => esc_html( $plumbing_technician_header_banner_cat ) ) );

          if( $plumbing_technician_banner_query->have_posts() ): ?>

            <div class="main-banner-area">
                <div class="banner-areas-left">
                    <div class="theme-custom-block theme-banner-block">
                        <div class="swiper-container theme-main-carousel swiper-container" <?php echo $plumbing_technician_rtl; ?>>

                            <div class="swiper-wrapper">

                              <?php
                              while( $plumbing_technician_banner_query->have_posts() ):
                                $plumbing_technician_banner_query->the_post();
                                $plumbing_technician_featured_image = wp_get_attachment_image_src(get_post_thumbnail_id(), 'large');
                                $default_image = get_template_directory_uri() . '/inc/homepage-setup/assets/homepage-setup-images/slider-img1.png'; // Replace with the actual path to your default image
                                $plumbing_technician_featured_image = isset( $plumbing_technician_featured_image[0] ) ? $plumbing_technician_featured_image[0] : $default_image;?>

                                  <div class="swiper-slide main-carousel-item">
                                        <div class="theme-article-post">
                                            <div class="entry-thumbnail">
                                                <div class="data-bg data-bg-large" data-background="<?php echo esc_url($plumbing_technician_featured_image); ?>">
                                                    <a href="<?php the_permalink(); ?>" class="theme-image-responsive" tabindex="0"></a>
                                                </div>
                                                <?php plumbing_technician_post_format_icon(); ?>
                                            </div>
                                            <div class="main-carousel-caption">
                                                <div class="post-content ">
                                                    <header class="entry-header">
                                                        <h2 class="entry-title entry-title-big">
                                                            <a href="<?php the_permalink(); ?>" rel="bookmark"><span><?php the_title(); ?></span></a>
                                                        </h2>
                                                    </header>
                                                    <div class="entry-content">
                                                        <?php
                                                        if (has_excerpt()) {
                                                            the_excerpt();
                                                        } else {
                                                            echo esc_html(wp_trim_words(get_the_content(), 25, '...'));
                                                        } ?>
                                                    </div>
                                                    <div class="slider-btn">
                                                        <a href="<?php the_permalink(); ?>" class="btn-fancy btn-fancy-primary" tabindex="0">
                                                          <?php echo esc_html__('Know More', 'plumbing-technician'); ?><svg xmlns="http://www.w3.org/2000/svg" height="1.5em" viewBox="0 0 448 512"><!--!Font Awesome Free 6.6.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2024 Fonticons, Inc.--><path d="M313.9 216H12c-6.6 0-12 5.4-12 12v56c0 6.6 5.4 12 12 12h301.9v46.1c0 21.4 25.9 32.1 41 17l86.1-86.1c9.4-9.4 9.4-24.6 0-33.9l-86.1-86.1c-15.1-15.1-41-4.4-41 17V216z"/></svg>
                                                        </a>
                                                    </div>
                                                  </div>
                                              </div>
                                        </div>
                                  </div>
                              <?php endwhile; ?>
                            </div>
                            <div class="swiper-pagination"></div>
                        </div>
                    </div>
                </div>
                <div class="banner-areas-right">
                    <div class="theme-header-areas header-areas-right">
                        <?php if( $plumbing_technician_header_search ){ ?>
                            <div class="main-search">
                                <span class="header-search"> 
                                    <a href="#search">
                                      <svg xmlns="http://www.w3.org/2000/svg" height="1.5em" viewBox="0 0 512 512"><!--!Font Awesome Free 6.5.1 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2024 Fonticons, Inc.--><path d="M505 442.7L405.3 343c-4.5-4.5-10.6-7-17-7H372c27.6-35.3 44-79.7 44-128C416 93.1 322.9 0 208 0S0 93.1 0 208s93.1 208 208 208c48.3 0 92.7-16.4 128-44v16.3c0 6.4 2.5 12.5 7 17l99.7 99.7c9.4 9.4 24.6 9.4 33.9 0l28.3-28.3c9.4-9.4 9.4-24.6 .1-34zM208 336c-70.7 0-128-57.2-128-128 0-70.7 57.2-128 128-128 70.7 0 128 57.2 128 128 0 70.7-57.2 128-128 128z"/></svg>
                                    </a>
                                    <!-- Search Form -->
                                    <div id="search">
                                        <span class="close">X</span>
                                        <?php get_search_form(); ?>
                                    </div>
                                </span>
                            </div>
                        <?php } ?>
                    </div>
                    <div class="media-link">
                        <?php if( $plumbing_technician_header_banner_social_facebook_link ){ ?>
                            <a target="_blank" href="<?php echo esc_url( $plumbing_technician_header_banner_social_facebook_link ); ?>"><svg xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 320 512"><!--! Font Awesome Free 6.4.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2023 Fonticons, Inc. --><path d="M279.14 288l14.22-92.66h-88.91v-60.13c0-25.35 12.42-50.06 52.24-50.06h40.42V6.26S260.43 0 225.36 0c-73.22 0-121.08 44.38-121.08 124.72v70.62H22.89V288h81.39v224h100.17V288z"/></svg></a>
                        <?php } ?>
                        <?php if( $plumbing_technician_header_banner_social_twitter_link ){ ?>
                            <a target="_blank" href="<?php echo esc_url( $plumbing_technician_header_banner_social_twitter_link ); ?>"><svg xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 512 512"><!--! Font Awesome Free 6.4.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2023 Fonticons, Inc. --><path d="M459.37 151.716c.325 4.548.325 9.097.325 13.645 0 138.72-105.583 298.558-298.558 298.558-59.452 0-114.68-17.219-161.137-47.106 8.447.974 16.568 1.299 25.34 1.299 49.055 0 94.213-16.568 130.274-44.832-46.132-.975-84.792-31.188-98.112-72.772 6.498.974 12.995 1.624 19.818 1.624 9.421 0 18.843-1.3 27.614-3.573-48.081-9.747-84.143-51.98-84.143-102.985v-1.299c13.969 7.797 30.214 12.67 47.431 13.319-28.264-18.843-46.781-51.005-46.781-87.391 0-19.492 5.197-37.36 14.294-52.954 51.655 63.675 129.3 105.258 216.365 109.807-1.624-7.797-2.599-15.918-2.599-24.04 0-57.828 46.782-104.934 104.934-104.934 30.213 0 57.502 12.67 76.67 33.137 23.715-4.548 46.456-13.32 66.599-25.34-7.798 24.366-24.366 44.833-46.132 57.827 21.117-2.273 41.584-8.122 60.426-16.243-14.292 20.791-32.161 39.308-52.628 54.253z"/></svg></a>
                        <?php } ?>
                        <?php if( $plumbing_technician_header_banner_social_instagram_link ){ ?>
                            <a target="_blank" href="<?php echo esc_url( $plumbing_technician_header_banner_social_instagram_link ); ?>"><svg xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 448 512"><!--! Font Awesome Free 6.4.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2023 Fonticons, Inc. --><path d="M224.1 141c-63.6 0-114.9 51.3-114.9 114.9s51.3 114.9 114.9 114.9S339 319.5 339 255.9 287.7 141 224.1 141zm0 189.6c-41.1 0-74.7-33.5-74.7-74.7s33.5-74.7 74.7-74.7 74.7 33.5 74.7 74.7-33.6 74.7-74.7 74.7zm146.4-194.3c0 14.9-12 26.8-26.8 26.8-14.9 0-26.8-12-26.8-26.8s12-26.8 26.8-26.8 26.8 12 26.8 26.8zm76.1 27.2c-1.7-35.9-9.9-67.7-36.2-93.9-26.2-26.2-58-34.4-93.9-36.2-37-2.1-147.9-2.1-184.9 0-35.8 1.7-67.6 9.9-93.9 36.1s-34.4 58-36.2 93.9c-2.1 37-2.1 147.9 0 184.9 1.7 35.9 9.9 67.7 36.2 93.9s58 34.4 93.9 36.2c37 2.1 147.9 2.1 184.9 0 35.9-1.7 67.7-9.9 93.9-36.2 26.2-26.2 34.4-58 36.2-93.9 2.1-37 2.1-147.8 0-184.8zM398.8 388c-7.8 19.6-22.9 34.7-42.6 42.6-29.5 11.7-99.5 9-132.1 9s-102.7 2.6-132.1-9c-19.6-7.8-34.7-22.9-42.6-42.6-11.7-29.5-9-99.5-9-132.1s-2.6-102.7 9-132.1c7.8-19.6 22.9-34.7 42.6-42.6 29.5-11.7 99.5-9 132.1-9s102.7-2.6 132.1 9c19.6 7.8 34.7 22.9 42.6 42.6 11.7 29.5 9 99.5 9 132.1s2.7 102.7-9 132.1z"/></svg></a>
                        <?php } ?>
                        <?php if( $plumbing_technician_header_banner_social_linkdin_link ){ ?>
                            <a target="_blank" href="<?php echo esc_url( $plumbing_technician_header_banner_social_linkdin_link ); ?>"><svg xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 448 512"><!--! Font Awesome Free 6.4.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2023 Fonticons, Inc. --><path d="M100.28 448H7.4V148.9h92.88zM53.79 108.1C24.09 108.1 0 83.5 0 53.8a53.79 53.79 0 0 1 107.58 0c0 29.7-24.1 54.3-53.79 54.3zM447.9 448h-92.68V302.4c0-34.7-.7-79.2-48.29-79.2-48.29 0-55.69 37.7-55.69 76.7V448h-92.78V148.9h89.08v40.8h1.3c12.4-23.5 42.69-48.3 87.88-48.3 94 0 111.28 61.9 111.28 142.3V448z"/></svg></a>
                        <?php } ?>
                        <?php if( $plumbing_technician_header_banner_social_watsapp_link ){ ?>
                            <a target="_blank" href="<?php echo esc_url( $plumbing_technician_header_banner_social_watsapp_link ); ?>"><svg xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 448 512"><!--! Font Awesome Free 6.4.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2023 Fonticons, Inc. --><path d="M380.9 97.1C339 55.1 283.2 32 223.9 32c-122.4 0-222 99.6-222 222 0 39.1 10.2 77.3 29.6 111L0 480l117.7-30.9c32.4 17.7 68.9 27 106.1 27h.1c122.3 0 224.1-99.6 224.1-222 0-59.3-25.2-115-67.1-157zm-157 341.6c-33.2 0-65.7-8.9-94-25.7l-6.7-4-69.8 18.3L72 359.2l-4.4-7c-18.5-29.4-28.2-63.3-28.2-98.2 0-101.7 82.8-184.5 184.6-184.5 49.3 0 95.6 19.2 130.4 54.1 34.8 34.9 56.2 81.2 56.1 130.5 0 101.8-84.9 184.6-186.6 184.6zm101.2-138.2c-5.5-2.8-32.8-16.2-37.9-18-5.1-1.9-8.8-2.8-12.5 2.8-3.7 5.6-14.3 18-17.6 21.8-3.2 3.7-6.5 4.2-12 1.4-32.6-16.3-54-29.1-75.5-66-5.7-9.8 5.7-9.1 16.3-30.3 1.8-3.7.9-6.9-.5-9.7-1.4-2.8-12.5-30.1-17.1-41.2-4.5-10.8-9.1-9.3-12.5-9.5-3.2-.2-6.9-.2-10.6-.2-3.7 0-9.7 1.4-14.8 6.9-5.1 5.6-19.4 19-19.4 46.3 0 27.3 19.9 53.7 22.6 57.4 2.8 3.7 39.1 59.7 94.8 83.8 35.2 15.2 49 16.5 66.6 13.9 10.7-1.6 32.8-13.4 37.4-26.4 4.6-13 4.6-24.1 3.2-26.4-1.3-2.5-5-3.9-10.5-6.6z"/></svg></a>
                        <?php } ?>
                    </div>
                </div>
            </div>

          <?php
          wp_reset_postdata();
          endif;

        }

    }

endif;

if (!function_exists('plumbing_technician_post_format_icon')):

    // Post Format Icon.
    function plumbing_technician_post_format_icon() {

        $plumbing_technician_format = get_post_format(get_the_ID()) ?: 'standard';
        $plumbing_technician_icon = '';
        $plumbing_technician_title = '';
        if( $plumbing_technician_format == 'video' ){
            $plumbing_technician_icon = plumbing_technician_get_theme_svg( 'video' );
            $plumbing_technician_title = esc_html__('Video','plumbing-technician');
        }elseif( $plumbing_technician_format == 'audio' ){
            $plumbing_technician_icon = plumbing_technician_get_theme_svg( 'audio' );
            $plumbing_technician_title = esc_html__('Audio','plumbing-technician');
        }elseif( $plumbing_technician_format == 'gallery' ){
            $plumbing_technician_icon = plumbing_technician_get_theme_svg( 'gallery' );
            $plumbing_technician_title = esc_html__('Gallery','plumbing-technician');
        }elseif( $plumbing_technician_format == 'quote' ){
            $plumbing_technician_icon = plumbing_technician_get_theme_svg( 'quote' );
            $plumbing_technician_title = esc_html__('Quote','plumbing-technician');
        }elseif( $plumbing_technician_format == 'image' ){
            $plumbing_technician_icon = plumbing_technician_get_theme_svg( 'image' );
            $plumbing_technician_title = esc_html__('Image','plumbing-technician');
        } elseif( $plumbing_technician_format == 'link' ){
            $plumbing_technician_icon = plumbing_technician_get_theme_svg( 'link' );
            $plumbing_technician_title = esc_html__('Link','plumbing-technician');
        } elseif( $plumbing_technician_format == 'status' ){
            $plumbing_technician_icon = plumbing_technician_get_theme_svg( 'status' );
            $plumbing_technician_title = esc_html__('Status','plumbing-technician');
        } elseif( $plumbing_technician_format == 'aside' ){
            $plumbing_technician_icon = plumbing_technician_get_theme_svg( 'aside' );
            $plumbing_technician_title = esc_html__('Aside','plumbing-technician');
        } elseif( $plumbing_technician_format == 'chat' ){
            $plumbing_technician_icon = plumbing_technician_get_theme_svg( 'chat' );
            $plumbing_technician_title = esc_html__('Chat','plumbing-technician');
        }
        
        if (!empty($plumbing_technician_icon)) { ?>
            <div class="theme-post-format">
                <span class="post-format-icom"><?php echo plumbing_technician_svg_escape($plumbing_technician_icon); ?></span>
                <?php if( $plumbing_technician_title ){ echo '<span class="post-format-label">'.esc_html( $plumbing_technician_title ).'</span>'; } ?>
            </div>
        <?php }
    }

endif;

if ( ! function_exists( 'plumbing_technician_svg_escape' ) ):

    /**
     * Get information about the SVG icon.
     *
     * @param string $plumbing_technician_svg_name The name of the icon.
     * @param string $group The group the icon belongs to.
     * @param string $color Color code.
     */
    function plumbing_technician_svg_escape( $plumbing_technician_input ) {

        // Make sure that only our allowed tags and attributes are included.
        $plumbing_technician_svg = wp_kses(
            $plumbing_technician_input,
            array(
                'svg'     => array(
                    'class'       => true,
                    'xmlns'       => true,
                    'width'       => true,
                    'height'      => true,
                    'viewbox'     => true,
                    'aria-hidden' => true,
                    'role'        => true,
                    'focusable'   => true,
                ),
                'path'    => array(
                    'fill'      => true,
                    'fill-rule' => true,
                    'd'         => true,
                    'transform' => true,
                ),
                'polygon' => array(
                    'fill'      => true,
                    'fill-rule' => true,
                    'points'    => true,
                    'transform' => true,
                    'focusable' => true,
                ),
            )
        );

        if ( ! $plumbing_technician_svg ) {
            return false;
        }

        return $plumbing_technician_svg;

    }

endif;

if( !function_exists( 'plumbing_technician_sanitize_sidebar_option_meta' ) ) :

    // Sidebar Option Sanitize.
    function plumbing_technician_sanitize_sidebar_option_meta( $plumbing_technician_input ){

        $plumbing_technician_metabox_options = array( 'global-sidebar','left-sidebar','right-sidebar','no-sidebar' );
        if( in_array( $plumbing_technician_input,$plumbing_technician_metabox_options ) ){

            return $plumbing_technician_input;

        }else{

            return '';

        }
    }

endif;

if( !function_exists( 'plumbing_technician_sanitize_pagination_meta' ) ) :

    // Sidebar Option Sanitize.
    function plumbing_technician_sanitize_pagination_meta( $plumbing_technician_input ){

        $plumbing_technician_metabox_options = array( 'Center','Right','Left');
        if( in_array( $plumbing_technician_input,$plumbing_technician_metabox_options ) ){

            return $plumbing_technician_input;

        }else{

            return '';

        }
    }

endif;

if( !function_exists( 'plumbing_technician_services_slider' ) ) :

    function plumbing_technician_services_slider(){

        $plumbing_technician_defaults = plumbing_technician_get_default_theme_options();
        $plumbing_technician_services = get_theme_mod( 'plumbing_technician_services', $plumbing_technician_defaults['plumbing_technician_services'] );
        $plumbing_technician_services_cat = get_theme_mod( 'plumbing_technician_services_cat', 'Third' );

        $plumbing_technician_services_section_title = esc_html( get_theme_mod( 'plumbing_technician_services_section_title',
        $plumbing_technician_defaults['plumbing_technician_services_section_title'] ) );

        $plumbing_technician_services_section_short_title = esc_html( get_theme_mod( 'plumbing_technician_services_section_short_title',
        $plumbing_technician_defaults['plumbing_technician_services_section_short_title'] ) );

        if( $plumbing_technician_services ){

            $plumbing_technician_rtl = '';
            if( is_rtl() ){
                $plumbing_technician_rtl = 'dir="rtl"';
            }

          $plumbing_technician_services_query = new WP_Query( array('post_type' => 'post', 'posts_per_page' => 4,'post__not_in' => get_option("sticky_posts"), 'category_name' => esc_html( $plumbing_technician_services_cat ) ) );

          if( $plumbing_technician_services_query->have_posts() ): ?>

            <div class="theme-custom-block theme-banner-block theme-services-block">
                <div class="theme-custom-block-heading">
                    <div class="wrapper">
                        <?php if( $plumbing_technician_services_section_short_title ){ ?>
                            <h6><?php echo esc_html( $plumbing_technician_services_section_short_title ); ?></h6>
                        <?php } ?>

                        <?php if( $plumbing_technician_services_section_title ){ ?>
                            <h2><?php echo esc_html( $plumbing_technician_services_section_title ); ?></h2>
                        <?php } ?>
                    </div>
                </div>                
                <div class="swiper-container theme-main-carousel swiper-container" <?php echo $plumbing_technician_rtl; ?>>

                    <div class="swiper-wrapper">

                      <?php
                      while( $plumbing_technician_services_query->have_posts() ):
                        $plumbing_technician_services_query->the_post();
                        $plumbing_technician_featured_image = wp_get_attachment_image_src(get_post_thumbnail_id(), 'large');
                        $plumbing_technician_a_default_image = get_template_directory_uri() . '/inc/homepage-setup/assets/homepage-setup-images/post-img1.png';
                        $plumbing_technician_featured_image = isset( $plumbing_technician_featured_image[0] ) ? $plumbing_technician_featured_image[0] : $plumbing_technician_a_default_image;?>

                          <div class="swiper-slide main-carousel-item">
                             
                                <div class="theme-article-post">
                                    <div class="box">
                                        <div class="entry-thumbnail">
                                            <div class="data-bg data-bg-large" data-background="<?php echo esc_url($plumbing_technician_featured_image); ?>">
                                                <a href="<?php the_permalink(); ?>" class="theme-image-responsive" tabindex="0"></a>
                                            </div>
                                            <?php plumbing_technician_post_format_icon(); ?>
                                        </div>
                                        <div class="box-content">
                                            <h3 class="title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                                            <span class="post"> 
                                                <?php if (has_excerpt()) {
                                                    the_excerpt();
                                                } else {
                                                    echo esc_html(wp_trim_words(get_the_content(), 10, '...'));
                                                } ?>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            </div>

                      <?php endwhile; ?>

                    </div>

                    <div class="swiper-pagination"></div>

                </div>
            </div>

          <?php
          wp_reset_postdata();
          endif;

        }

    }

endif;

if( !function_exists( 'plumbing_technician_technician_counter_slider' ) ) :

    function plumbing_technician_technician_counter_slider(){

        $plumbing_technician_defaults = plumbing_technician_get_default_theme_options();
        $plumbing_technician_technician_counter = get_theme_mod( 'plumbing_technician_technician_counter', $plumbing_technician_defaults['plumbing_technician_technician_counter'] );
        $plumbing_technician_technician_counter_cat = get_theme_mod( 'plumbing_technician_technician_counter_cat', 'Second' );

        if( $plumbing_technician_technician_counter ){

            $plumbing_technician_rtl = '';
            if( is_rtl() ){
                $plumbing_technician_rtl = 'dir="rtl"';
            }

          $plumbing_technician_counter_query = new WP_Query( array('post_type' => 'post', 'posts_per_page' => 8,'post__not_in' => get_option("sticky_posts"), 'category_name' => esc_html( $plumbing_technician_technician_counter_cat ) ) );

          if( $plumbing_technician_counter_query->have_posts() ): ?>

            <div class="theme-custom-block theme-counter-block">
                <div class="wrapper">
                    <div class="swiper-container theme-main-carousel swiper-container" <?php echo $plumbing_technician_rtl; ?>>
                        <div class="swiper-wrapper">
                            <?php
                            $i = 0;
                            while( $plumbing_technician_counter_query->have_posts() ):
                            $plumbing_technician_counter_query->the_post();
                            $plumbing_technician_header_layout_slider_count = esc_html( get_theme_mod( 'plumbing_technician_header_layout_slider_count'.$i) );
                            $plumbing_technician_technician_counter_featured_image = wp_get_attachment_image_src(get_post_thumbnail_id(), 'large');
                            $plumbing_technician_a_default_image = get_template_directory_uri() . '/inc/homepage-setup/assets/homepage-setup-images/post-img01.png';
                            $plumbing_technician_technician_counter_featured_image = isset( $plumbing_technician_technician_counter_featured_image[0] ) ? $plumbing_technician_technician_counter_featured_image[0] : $plumbing_technician_a_default_image;?>
                                <div class="swiper-slide main-carousel-item">
                                    <div class="theme-counter-post">
                                        <div class="entry-thumbnail">
                                            <div class="data-bg data-bg-large" data-background="<?php echo esc_url($plumbing_technician_technician_counter_featured_image); ?>">
                                                <a href="<?php the_permalink(); ?>" class="theme-image-responsive" tabindex="0"></a>
                                                <?php if( $plumbing_technician_header_layout_slider_count ){ ?>
                                                <h5 class="counter-count"><?php echo esc_html( $plumbing_technician_header_layout_slider_count ); ?></h5>
                                            <?php } ?>
                                                
                                            </div>
                                            <?php plumbing_technician_post_format_icon(); ?>
                                        </div>
                                        <div class="post-content">
                                            <header class="entry-header">
                                                <h4 class="entry-title entry-title-big counter-head">
                                                   <?php the_title(); ?>
                                                </h4>
                                            </header>
                                        </div>
                                    </div>
                                </div>
                            <?php
                            $i++;
                             endwhile; ?>
                        </div>
                        <div class="swiper-pagination"></div>
                    </div>
                </div>
            </div>

          <?php
          wp_reset_postdata();
          endif;

        }

    }

endif;

if( !function_exists( 'plumbing_technician_sanitize_menu_transform' ) ) :

    // Sidebar Option Sanitize.
    function plumbing_technician_sanitize_menu_transform( $plumbing_technician_input ){

        $plumbing_technician_metabox_options = array( 'capitalize','uppercase','lowercase');
        if( in_array( $plumbing_technician_input,$plumbing_technician_metabox_options ) ){

            return $plumbing_technician_input;

        }else{

            return '';

        }
    }

endif;

if( !function_exists( 'plumbing_technician_sanitize_page_content_alignment' ) ) :

    // Sidebar Option Sanitize.
    function plumbing_technician_sanitize_page_content_alignment( $plumbing_technician_input ){

        $plumbing_technician_metabox_options = array( 'left','center','right');
        if( in_array( $plumbing_technician_input,$plumbing_technician_metabox_options ) ){

            return $plumbing_technician_input;

        }else{

            return '';

        }
    }

endif;

if( !function_exists( 'plumbing_technician_sanitize_footer_widget_title_alignment' ) ) :

    // Footer Option Sanitize.
    function plumbing_technician_sanitize_footer_widget_title_alignment( $plumbing_technician_input ){

        $plumbing_technician_metabox_options = array( 'left','center','right');
        if( in_array( $plumbing_technician_input,$plumbing_technician_metabox_options ) ){

            return $plumbing_technician_input;

        }else{

            return '';

        }
    }

endif;

if( !function_exists( 'plumbing_technician_sanitize_pagination_type' ) ) :

    /**
     * Sanitize the pagination type setting.
     *
     * @param string $plumbing_technician_input The input value from the Customizer.
     * @return string The sanitized value.
     */
    function plumbing_technician_sanitize_pagination_type( $plumbing_technician_input ) {
        // Define valid options for the pagination type.
        $plumbing_technician_valid_options = array( 'numeric', 'newer_older' ); // Update valid options to include 'newer_older'

        // If the input is one of the valid options, return it. Otherwise, return the default option ('numeric').
        if ( in_array( $plumbing_technician_input, $plumbing_technician_valid_options, true ) ) {
            return $plumbing_technician_input;
        } else {
            // Return 'numeric' as the fallback if the input is invalid.
            return 'numeric';
        }
    }

endif;


// Sanitize the enable/disable setting for pagination
if( !function_exists('plumbing_technician_sanitize_enable_pagination') ) :
    function plumbing_technician_sanitize_enable_pagination( $plumbing_technician_input ) {
        return (bool) $plumbing_technician_input;
    }
endif;

if( !function_exists( 'plumbing_technician_sanitize_copyright_alignment_meta' ) ) :

    // Sidebar Option Sanitize.
    function plumbing_technician_sanitize_copyright_alignment_meta( $plumbing_technician_input ){

        $plumbing_technician_metabox_options = array( 'Default','Reverse','Center');
        if( in_array( $plumbing_technician_input,$plumbing_technician_metabox_options ) ){

            return $plumbing_technician_input;

        }else{

            return '';

        }
    }

endif;

/**
 * Sidebar Layout Function
 */
function plumbing_technician_get_final_sidebar_layout() {
	$plumbing_technician_defaults       = plumbing_technician_get_default_theme_options();
	$plumbing_technician_global_layout  = get_theme_mod('plumbing_technician_global_sidebar_layout', $plumbing_technician_defaults['plumbing_technician_global_sidebar_layout']);
	$plumbing_technician_page_layout    = get_theme_mod('plumbing_technician_page_sidebar_layout', $plumbing_technician_global_layout);
	$plumbing_technician_post_layout    = get_theme_mod('plumbing_technician_post_sidebar_layout', $plumbing_technician_global_layout);
	$plumbing_technician_meta_layout    = get_post_meta(get_the_ID(), 'plumbing_technician_post_sidebar_option', true);

	if (!empty($plumbing_technician_meta_layout) && $plumbing_technician_meta_layout !== 'default') {
		return $plumbing_technician_meta_layout;
	}
	if (is_page() || (function_exists('is_shop') && is_shop())) {
		return $plumbing_technician_page_layout;
	}
	if (is_single()) {
		return $plumbing_technician_post_layout;
	}
	return $plumbing_technician_global_layout;
}