<?php
/**
 * Plumbing Technician functions and definitions
 * @package Plumbing Technician
 */

if ( ! function_exists( 'plumbing_technician_after_theme_support' ) ) :

	function plumbing_technician_after_theme_support() {
		
		load_theme_textdomain( 'plumbing-technician', get_template_directory() . '/languages' );
		add_theme_support( 'automatic-feed-links' );
		add_theme_support('woocommerce');
        add_theme_support('wc-product-gallery-zoom');
        add_theme_support('wc-product-gallery-lightbox');
        add_theme_support('wc-product-gallery-slider');
        add_theme_support('woocommerce', array(
            'gallery_thumbnail_image_width' => 300,
        ));

		add_theme_support(
			'custom-background',
			array(
				'default-color' => 'ffffff',
			)
		);

		$GLOBALS['content_width'] = apply_filters( 'plumbing_technician_content_width', 1140 );
		
		add_theme_support( 'post-thumbnails' );

		add_theme_support(
			'custom-logo',
			array(
				'height'      => 270,
				'width'       => 90,
				'flex-height' => true,
				'flex-width'  => true,
			)
		);
		
		add_theme_support( 'title-tag' );

		add_theme_support(
			'html5',
			array(
				'search-form',
				'comment-form',
				'comment-list',
				'gallery',
				'caption',
				'script',
				'style',
			)
		);

		add_theme_support( 'post-formats', array(
			'video',  
			'audio',  
			'gallery',
			'quote',  
			'image',  
			'link',   
			'status', 
			'aside',  
			'chat',   
		) );
		
		add_theme_support( 'align-wide' );
		add_theme_support( 'responsive-embeds' );
		add_theme_support( 'wp-block-styles' );

		add_editor_style('/lib/custom/css/editor-style.css');

		require get_template_directory() . '/inc/metabox.php';
		require get_template_directory() . '/inc/homepage-setup/homepage-setup-settings.php';

		if (! defined( 'PLUMBING_TECHNICIAN_DOCS_PRO' ) ){
		define('PLUMBING_TECHNICIAN_DOCS_PRO',__('https://layout.omegathemes.com/steps/pro-plumbing-technician/','plumbing-technician'));
		}
		if (! defined( 'PLUMBING_TECHNICIAN_BUY_NOW' ) ){
		define('PLUMBING_TECHNICIAN_BUY_NOW',__('https://www.omegathemes.com/products/plumber-wordpress-theme','plumbing-technician'));
		}
		if (! defined( 'PLUMBING_TECHNICIAN_SUPPORT_FREE' ) ){
		define('PLUMBING_TECHNICIAN_SUPPORT_FREE',__('https://wordpress.org/support/theme/plumbing-technician/','plumbing-technician'));
		}
		if (! defined( 'PLUMBING_TECHNICIAN_REVIEW_FREE' ) ){
		define('PLUMBING_TECHNICIAN_REVIEW_FREE',__('https://wordpress.org/support/theme/plumbing-technician/reviews/#new-post','plumbing-technician'));
		}
		if (! defined( 'PLUMBING_TECHNICIAN_DEMO_PRO' ) ){
		define('PLUMBING_TECHNICIAN_DEMO_PRO',__('https://layout.omegathemes.com/plumbing-technician/','plumbing-technician'));
		}
		if (! defined( 'PLUMBING_TECHNICIAN_LITE_DOCS_PRO' ) ){
		define('PLUMBING_TECHNICIAN_LITE_DOCS_PRO',__('https://layout.omegathemes.com/steps/free-plumbing-technician/','plumbing-technician'));
		}
		if (! defined( 'PLUMBING_TECHNICIAN_BUNDLE_BUTTON' ) ){
			define('PLUMBING_TECHNICIAN_BUNDLE_BUTTON',__('https://www.omegathemes.com/products/wp-theme-bundle','plumbing-technician'));
		}
	}

endif;

add_action( 'after_setup_theme', 'plumbing_technician_after_theme_support' );

/**
 * Register and Enqueue Styles.
 */
function plumbing_technician_register_styles() {

	wp_enqueue_style( 'dashicons' );

    $plumbing_technician_theme_version = wp_get_theme()->get( 'Version' );
	$plumbing_technician_fonts_url = plumbing_technician_fonts_url();
    if( $plumbing_technician_fonts_url ){
    	require get_theme_file_path( 'lib/custom/css/wptt-webfont-loader.php' );
        wp_enqueue_style(
			'plumbing-technician-google-fonts',
			plumbing_technician_wptt_get_webfont_url( $plumbing_technician_fonts_url ),
			array(),
			$plumbing_technician_theme_version
		);
    }

    wp_enqueue_style( 'swiper', get_template_directory_uri() . '/lib/swiper/css/swiper-bundle.min.css');
	wp_enqueue_style( 'plumbing-technician-style', get_stylesheet_uri(), array(), $plumbing_technician_theme_version );

	wp_enqueue_style( 'plumbing-technician-style', get_stylesheet_uri() );
	require get_parent_theme_file_path( '/custom_css.php' );
	wp_add_inline_style( 'plumbing-technician-style',$plumbing_technician_custom_css );

	$plumbing_technician_css = '';

	if ( get_header_image() ) :

		$plumbing_technician_css .=  '
			.headerbox{
				background-image: url('.esc_url(get_header_image()).');
				-webkit-background-size: cover !important;
				-moz-background-size: cover !important;
				-o-background-size: cover !important;
				background-size: cover !important;
			}';

	endif;

	wp_add_inline_style( 'plumbing-technician-style', $plumbing_technician_css );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}	

	wp_enqueue_script( 'imagesloaded' );
    wp_enqueue_script( 'masonry' );
	wp_enqueue_script( 'swiper', get_template_directory_uri() . '/lib/swiper/js/swiper-bundle.min.js', array('jquery'), '', 1);
	wp_enqueue_script( 'plumbing-technician-custom', get_template_directory_uri() . '/lib/custom/js/theme-custom-script.js', array('jquery'), '', 1);

    // Global Query
    if( is_front_page() ){

    	$plumbing_technician_posts_per_page = absint( get_option('posts_per_page') );
        $plumbing_technician_c_paged = ( get_query_var( 'page' ) ) ? absint( get_query_var( 'page' ) ) : 1;
        $plumbing_technician_posts_args = array(
            'posts_per_page'        => $plumbing_technician_posts_per_page,
            'paged'                 => $plumbing_technician_c_paged,
        );
        $plumbing_technician_posts_qry = new WP_Query( $plumbing_technician_posts_args );
        $max = $plumbing_technician_posts_qry->max_num_pages;

    }else{
        global $wp_query;
        $max = $wp_query->max_num_pages;
        $plumbing_technician_c_paged = ( get_query_var( 'paged' ) > 1 ) ? get_query_var( 'paged' ) : 1;
    }

    $plumbing_technician_default = plumbing_technician_get_default_theme_options();
    $plumbing_technician_pagination_layout = get_theme_mod( 'plumbing_technician_pagination_layout',$plumbing_technician_default['plumbing_technician_pagination_layout'] );
}

add_action( 'wp_enqueue_scripts', 'plumbing_technician_register_styles',200 );

function plumbing_technician_admin_enqueue_scripts_callback() {
    if ( ! did_action( 'wp_enqueue_media' ) ) {
    wp_enqueue_media();
    }
    wp_enqueue_script('plumbing-technician-uploaderjs', get_stylesheet_directory_uri() . '/lib/custom/js/uploader.js', array(), "1.0", true);
}
add_action( 'admin_enqueue_scripts', 'plumbing_technician_admin_enqueue_scripts_callback' );

/**
 * Register navigation menus uses wp_nav_menu in five places.
 */
function plumbing_technician_menus() {

	$plumbing_technician_locations = array(
		'plumbing-technician-primary-menu'  => esc_html__( 'Primary Menu', 'plumbing-technician' ),
	);

	register_nav_menus( $plumbing_technician_locations );
}

add_action( 'init', 'plumbing_technician_menus' );

add_filter('loop_shop_columns', 'plumbing_technician_loop_columns');
if (!function_exists('plumbing_technician_loop_columns')) {
	function plumbing_technician_loop_columns() {
		$plumbing_technician_columns = get_theme_mod( 'plumbing_technician_per_columns', 3 );
		return $plumbing_technician_columns;
	}
}

add_filter( 'loop_shop_per_page', 'plumbing_technician_per_page', 20 );
function plumbing_technician_per_page( $plumbing_technician_cols ) {
  	$plumbing_technician_cols = get_theme_mod( 'plumbing_technician_product_per_page', 9 );
	return $plumbing_technician_cols;
}

add_filter( 'woocommerce_output_related_products_args', 'plumbing_technician_products_args' );

function plumbing_technician_products_args( $plumbing_technician_args ) {

    $plumbing_technician_args['posts_per_page'] = get_theme_mod( 'plumbing_technician_custom_related_products_number', 6 );

    $plumbing_technician_args['columns'] = get_theme_mod( 'plumbing_technician_custom_related_products_number_per_row', 3 );

    return $plumbing_technician_args;
}

require get_template_directory() . '/inc/custom-header.php';
require get_template_directory() . '/classes/class-svg-icons.php';
require get_template_directory() . '/classes/class-walker-menu.php';
require get_template_directory() . '/inc/customizer/customizer.php';
require get_template_directory() . '/inc/custom-functions.php';
require get_template_directory() . '/inc/template-tags.php';
require get_template_directory() . '/classes/body-classes.php';
require get_template_directory() . '/inc/widgets/widgets.php';
require get_template_directory() . '/inc/pagination.php';
require get_template_directory() . '/lib/breadcrumbs/breadcrumbs.php';
require get_template_directory() . '/lib/custom/css/dynamic-style.php';


function plumbing_technician_remove_customize_register() {
    global $wp_customize;

    $wp_customize->remove_setting( 'display_header_text' );
    $wp_customize->remove_control( 'display_header_text' );

}

add_action( 'customize_register', 'plumbing_technician_remove_customize_register', 11 );

// Apply styles based on customizer settings

function plumbing_technician_radio_sanitize(  $plumbing_technician_input, $plumbing_technician_setting  ) {
	$plumbing_technician_input = sanitize_key( $plumbing_technician_input );
	$plumbing_technician_choices = $plumbing_technician_setting->manager->get_control( $plumbing_technician_setting->id )->choices;
	return ( array_key_exists( $plumbing_technician_input, $plumbing_technician_choices ) ? $plumbing_technician_input : $plumbing_technician_setting->default );
}
require get_template_directory() . '/inc/general.php';

function plumbing_technician_sticky_sidebar_enabled() {
    $plumbing_technician_sticky_sidebar = get_theme_mod('plumbing_technician_sticky_sidebar', true);
    
    if ($plumbing_technician_sticky_sidebar == false) {
        $plumbing_technician_custom_css = ".widget-area-wrapper { position: relative !important; }";
        wp_add_inline_style('plumbing-technician-style', $plumbing_technician_custom_css);
    }
}
add_action('wp_enqueue_scripts', 'plumbing_technician_sticky_sidebar_enabled');


// NOTICE FUNCTION

function plumbing_technician_admin_notice() { 
    global $pagenow;
    $theme_args = wp_get_theme();
    $meta = get_option( 'plumbing_technician_admin_notice' );
    $name = $theme_args->get( 'Name' );
    $current_screen = get_current_screen();

    if ( ! $meta ) {
        if ( is_network_admin() ) {
            return;
        }

        if ( ! current_user_can( 'manage_options' ) ) {
            return;
        }

        if ( $current_screen->base != 'appearance_page_plumbingtechnician-wizard' ) {
            ?>
            <div class="notice notice-success notice-content">
                <h2><?php esc_html_e('Welcome! Thank you for choosing Plumbing Technician. Let’s Set Up Your Website!', 'plumbing-technician') ?> </h2>
                <p><?php esc_html_e('Before you dive into customization, let’s go through a quick setup process to ensure everything runs smoothly. Click below to start setting up your website in minutes!', 'plumbing-technician') ?> </p>
                <div class="info-link">
                    <a href="<?php echo esc_url( admin_url( 'themes.php?page=plumbingtechnician-wizard' ) ); ?>"><?php esc_html_e('Get Started with Plumbing Technician', 'plumbing-technician'); ?></a>
                </div>
                <p class="dismiss-link"><strong><a href="?plumbing_technician_admin_notice=1"><?php esc_html_e( 'Dismiss', 'plumbing-technician' ); ?></a></strong></p>
            </div>
            <?php
        }
    }
}
add_action( 'admin_notices', 'plumbing_technician_admin_notice' );

if ( ! function_exists( 'plumbing_technician_update_admin_notice' ) ) :
/**
 * Updating admin notice on dismiss
 */
function plumbing_technician_update_admin_notice() {
    if ( isset( $_GET['plumbing_technician_admin_notice'] ) && $_GET['plumbing_technician_admin_notice'] == '1' ) {
        update_option( 'plumbing_technician_admin_notice', true );
    }
}
endif;
add_action( 'admin_init', 'plumbing_technician_update_admin_notice' );

// After Switch theme function
add_action( 'after_switch_theme', 'plumbing_technician_getstart_setup_options' );
function plumbing_technician_getstart_setup_options() {
    update_option( 'plumbing_technician_admin_notice', false );
}