<?php
/**
 * Custom page walker for this theme.
 *
 * @package  Plumbing Technician
 */

if (!class_exists('Plumbing_Technician_Walker_Page')) {
    /**
     * CUSTOM PAGE WALKER
     * A custom walker for pages.
     */
    class Plumbing_Technician_Walker_Page extends Walker_Page
    {

        /**
         * Outputs the beginning of the current element in the tree.
         *
         * @param string $plumbing_technician_output Used to append additional content. Passed by reference.
         * @param WP_Post $page Page data object.
         * @param int $plumbing_technician_depth Optional. Depth of page. Used for padding. Default 0.
         * @param array $plumbing_technician_args Optional. Array of arguments. Default empty array.
         * @param int $current_page Optional. Page ID. Default 0.
         * @since 2.1.0
         *
         * @see Walker::start_el()
         */

        public function start_lvl( &$plumbing_technician_output, $plumbing_technician_depth = 0, $plumbing_technician_args = array() ) {
            $plumbing_technician_indent  = str_repeat( "\t", $plumbing_technician_depth );
            $plumbing_technician_output .= "$plumbing_technician_indent<ul class='sub-menu'>\n";
        }

        public function start_el(&$plumbing_technician_output, $page, $plumbing_technician_depth = 0, $plumbing_technician_args = array(), $current_page = 0)
        {

            if (isset($plumbing_technician_args['item_spacing']) && 'preserve' === $plumbing_technician_args['item_spacing']) {
                $t = "\t";
                $n = "\n";
            } else {
                $t = '';
                $n = '';
            }
            if ($plumbing_technician_depth) {
                $plumbing_technician_indent = str_repeat($t, $plumbing_technician_depth);
            } else {
                $plumbing_technician_indent = '';
            }

            $plumbing_technician_css_class = array('page_item', 'page-item-' . $page->ID);

            if (isset($plumbing_technician_args['pages_with_children'][$page->ID])) {
                $plumbing_technician_css_class[] = 'page_item_has_children';
            }

            if (!empty($current_page)) {
                $_current_page = get_post($current_page);
                if ($_current_page && in_array($page->ID, $_current_page->ancestors, true)) {
                    $plumbing_technician_css_class[] = 'current_page_ancestor';
                }
                if ($page->ID === $current_page) {
                    $plumbing_technician_css_class[] = 'current_page_item';
                } elseif ($_current_page && $page->ID === $_current_page->post_parent) {
                    $plumbing_technician_css_class[] = 'current_page_parent';
                }
            } elseif (get_option('page_for_posts') === $page->ID) {
                $plumbing_technician_css_class[] = 'current_page_parent';
            }

            /** This filter is documented in wp-includes/class-walker-page.php */
            $plumbing_technician_css_classes = implode(' ', apply_filters('page_css_class', $plumbing_technician_css_class, $page, $plumbing_technician_depth, $plumbing_technician_args, $current_page));
            $plumbing_technician_css_classes = $plumbing_technician_css_classes ? ' class="' . esc_attr($plumbing_technician_css_classes) . '"' : '';

            if ('' === $page->post_title) {
                /* translators: %d: ID of a post. */
                $page->post_title = sprintf(__('#%d (no title)', 'plumbing-technician'), $page->ID);
            }

            $plumbing_technician_args['link_before'] = empty($plumbing_technician_args['link_before']) ? '' : $plumbing_technician_args['link_before'];
            $plumbing_technician_args['link_after'] = empty($plumbing_technician_args['link_after']) ? '' : $plumbing_technician_args['link_after'];

            $plumbing_technician_atts = array();
            $plumbing_technician_atts['href'] = get_permalink($page->ID);
            $plumbing_technician_atts['aria-current'] = ($page->ID === $current_page) ? 'page' : '';

            /** This filter is documented in wp-includes/class-walker-page.php */
            $plumbing_technician_atts = apply_filters('page_menu_link_attributes', $plumbing_technician_atts, $page, $plumbing_technician_depth, $plumbing_technician_args, $current_page);

            $plumbing_technician_attributes = '';
            foreach ($plumbing_technician_atts as $attr => $plumbing_technician_value) {
                if (!empty($plumbing_technician_value)) {
                    $plumbing_technician_value = ('href' === $attr) ? esc_url($plumbing_technician_value) : esc_attr($plumbing_technician_value);
                    $plumbing_technician_attributes .= ' ' . $attr . '="' . $plumbing_technician_value . '"';
                }
            }

            $plumbing_technician_args['list_item_before'] = '';
            $plumbing_technician_args['list_item_after'] = '';
            $plumbing_technician_args['icon_rennder'] = '';
            // Wrap the link in a div and append a sub menu toggle.
            if (isset($plumbing_technician_args['show_toggles']) && true === $plumbing_technician_args['show_toggles']) {
                // Wrap the menu item link contents in a div, used for positioning.
                $plumbing_technician_args['list_item_after'] = '';
            }


            // Add icons to menu items with children.
            if (isset($plumbing_technician_args['show_sub_menu_icons']) && true === $plumbing_technician_args['show_sub_menu_icons']) {
                if (isset($plumbing_technician_args['pages_with_children'][$page->ID])) {
                    $plumbing_technician_args['icon_rennder'] = '';
                }
            }

            // Add icons to menu items with children.
            if (isset($plumbing_technician_args['show_toggles']) && true === $plumbing_technician_args['show_toggles']) {
                if (isset($plumbing_technician_args['pages_with_children'][$page->ID])) {

                    $toggle_target_string = '.page_item.page-item-' . $page->ID . ' > .sub-menu';

                    $plumbing_technician_args['list_item_after'] = '<button type="button" class="theme-aria-button submenu-toggle" data-toggle-target="' . $toggle_target_string . '" data-toggle-type="slidetoggle" data-toggle-duration="250"><span class="btn__content" tabindex="-1"><span class="screen-reader-text">' . __( 'Show sub menu', 'plumbing-technician' ) . '</span>' . plumbing_technician_get_theme_svg( 'chevron-down' ) . '</span></button>';
                }
            }

            if (isset($plumbing_technician_args['show_toggles']) && true === $plumbing_technician_args['show_toggles']) {

                $plumbing_technician_output .= $plumbing_technician_indent . sprintf(
                        '<li%s>%s%s<a%s>%s%s%s</a>%s%s',
                        $plumbing_technician_css_classes,
                        '<div class="submenu-wrapper">',
                        $plumbing_technician_args['list_item_before'],
                        $plumbing_technician_attributes,
                        $plumbing_technician_args['link_before'],
                        /** This filter is documented in wp-includes/post-template.php */
                        apply_filters('the_title', $page->post_title, $page->ID),
                        $plumbing_technician_args['link_after'],
                        $plumbing_technician_args['list_item_after'],
                        '</div>'
                    );

            }else{

                $plumbing_technician_output .= $plumbing_technician_indent . sprintf(
                        '<li%s>%s<a%s>%s%s%s%s</a>%s',
                        $plumbing_technician_css_classes,
                        $plumbing_technician_args['list_item_before'],
                        $plumbing_technician_attributes,
                        $plumbing_technician_args['link_before'],
                        /** This filter is documented in wp-includes/post-template.php */
                        apply_filters('the_title', $page->post_title, $page->ID),
                        $plumbing_technician_args['icon_rennder'],
                        $plumbing_technician_args['link_after'],
                        $plumbing_technician_args['list_item_after']
                    );

            }

            if (!empty($plumbing_technician_args['show_date'])) {
                if ('modified' === $plumbing_technician_args['show_date']) {
                    $plumbing_technician_time = $page->post_modified;
                } else {
                    $plumbing_technician_time = $page->post_date;
                }

                $plumbing_technician_date_format = empty($plumbing_technician_args['date_format']) ? '' : $plumbing_technician_args['date_format'];
                $plumbing_technician_output .= ' ' . mysql2date($plumbing_technician_date_format, $plumbing_technician_time);
            }
        }
    }
}