<?php
/**
 * Body Classes.
 * @package Plumbing Technician
 */

if (!function_exists('plumbing_technician_body_classes')) :

    function plumbing_technician_body_classes($plumbing_technician_classes)
    {
        $plumbing_technician_defaults = plumbing_technician_get_default_theme_options();
        $plumbing_technician_layout = plumbing_technician_get_final_sidebar_layout();

        // Adds a class of hfeed to non-singular pages.
        if (!is_singular()) {
            $plumbing_technician_classes[] = 'hfeed';
        }

        // Sidebar layout logic
        $plumbing_technician_classes[] = $plumbing_technician_layout;

        // Copyright alignment
        $copyright_alignment = get_theme_mod('plumbing_technician_copyright_alignment', 'Default');
        $plumbing_technician_classes[] = 'copyright-' . strtolower($copyright_alignment);

        return $plumbing_technician_classes;
    }

endif;

add_filter('body_class', 'plumbing_technician_body_classes');