<?php
/**
 * Excerpt
 *
 * @package plumbing_handyman
 */

$wp_customize->add_section(
	'plumbing_handyman_excerpt_options',
	array(
		'panel' => 'plumbing_handyman_theme_options',
		'title' => esc_html__( 'Excerpt', 'plumbing-handyman' ),
	)
);

// Excerpt - Excerpt Length.
$wp_customize->add_setting(
	'plumbing_handyman_excerpt_length',
	array(
		'default'           => 20,
		'sanitize_callback' => 'absint',
		'transport'         => 'refresh',
	)
);

$wp_customize->add_control(
	'plumbing_handyman_excerpt_length',
	array(
		'label'       => esc_html__( 'Excerpt Length (no. of words)', 'plumbing-handyman' ),
		'section'     => 'plumbing_handyman_excerpt_options',
		'settings'    => 'plumbing_handyman_excerpt_length',
		'type'        => 'number',
		'input_attrs' => array(
			'min'  => 10,
			'max'  => 200,
			'step' => 1,
		),
	)
);