<?php
/**
 * Sample implementation of the Custom Header feature
 *
 * @link https://developer.wordpress.org/themes/functionality/custom-headers/
 *
 * @package plumbing_handyman
 */

function plumbing_handyman_custom_header_setup() {
	add_theme_support( 'custom-header', apply_filters( 'plumbing_handyman_custom_header_args', array(
		'default-text-color'     => 'fff',
		'header-text' 			 =>	false,
		'width'                  => 1360,
		'height'                 => 110,
		'flex-width'         	=> true,
        'flex-height'        	=> true,
		'wp-head-callback'       => 'plumbing_handyman_header_style',
	) ) );
}

add_action( 'after_setup_theme', 'plumbing_handyman_custom_header_setup' );

if ( ! function_exists( 'plumbing_handyman_header_style' ) ) :

add_action( 'wp_enqueue_scripts', 'plumbing_handyman_header_style' );
function plumbing_handyman_header_style() {
	if ( get_header_image() ) :
	$plumbing_handyman_custom_css = "
		header.site-header .header-main-wrapper .bottom-header-outer-wrapper .bottom-header-part{
			background-image:url('".esc_url(get_header_image())."') !important;
			background-position: center top;
			background-size: cover !important;
		}
		.bottom-header-part-wrapper .navigation-menus, .bottom-header-right-part{
			background-color: transparent;			
		}";
	   	wp_add_inline_style( 'plumbing-handyman-style', $plumbing_handyman_custom_css );
	endif;
}
endif;