<?php
/**
 * Template part for displaying Video Format
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package plumbing_handyman
 */

?>
<?php $plumbing_handyman_readmore = get_theme_mod( 'plumbing_handyman_readmore_button_text','Read More');?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<div class="mag-post-single">
        <?php
			// Get the post ID
			$plumbing_handyman_post_id = get_the_ID();

			// Check if there are videos embedded in the post content
			$plumbing_handyman_post = get_post($plumbing_handyman_post_id);
			$plumbing_handyman_content = do_shortcode(apply_filters('the_content', $plumbing_handyman_post->post_content));
			$plumbing_handyman_embeds = get_media_embedded_in_content($plumbing_handyman_content);

			if (!empty($plumbing_handyman_embeds)) {
			    // Loop through embedded media and display videos
			    foreach ($plumbing_handyman_embeds as $plumbing_handyman_embed) {
			        // Check if the embed code contains a video tag or specific video providers like YouTube or Vimeo
			        if (strpos($plumbing_handyman_embed, 'video') !== false || strpos($plumbing_handyman_embed, 'youtube') !== false || strpos($plumbing_handyman_embed, 'vimeo') !== false || strpos($plumbing_handyman_embed, 'dailymotion') !== false || strpos($plumbing_handyman_embed, 'vine') !== false || strpos($plumbing_handyman_embed, 'wordPress.tv') !== false || strpos($plumbing_handyman_embed, 'hulu') !== false) {
			            ?>
			            <div class="custom-embedded-video">
			                <div class="video-container">
			                    <?php echo esc_url($plumbing_handyman_embed); ?>
			                </div>
			                <div class="video-comments">
			                    <?php
			                    // Add your comments section here
			                    comments_template(); // This will include the default WordPress comments template
			                    ?>
			                </div>
			            </div>
			            <?php
			        }
			    }
			}
	    ?>
		<div class="mag-post-detail">
			<div class="mag-post-category">
				<?php plumbing_handyman_categories_list(); ?>
			</div>
			<?php
			if ( is_singular() ) :
				the_title( '<h1 class="entry-title mag-post-title">', '</h1>' );
			else :
				if ( get_theme_mod( 'plumbing_handyman_post_hide_post_heading', true ) ) { 
					the_title( '<h2 class="entry-title mag-post-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
			    }
			endif;
			?>
			<div class="mag-post-meta">
				<?php
				plumbing_handyman_posted_on();
				plumbing_handyman_posted_by();
				plumbing_handyman_posted_comments();
				plumbing_handyman_posted_time();
				?>
			</div>
			<?php if ( get_theme_mod( 'plumbing_handyman_post_hide_post_content', true ) ) { ?>
				<div class="mag-post-excerpt">
					<?php the_excerpt(); ?>
				</div>
		    <?php } ?>
			<?php if ( get_theme_mod( 'plumbing_handyman_post_readmore_button', true ) === true ) : ?>
				<div class="mag-post-read-more">
					<a href="<?php the_permalink(); ?>" class="read-more-button">
						<?php if ( ! empty( $plumbing_handyman_readmore ) ) { ?> <?php echo esc_html( $plumbing_handyman_readmore ); ?> <?php } ?>
						<i class="<?php echo esc_attr( get_theme_mod( 'plumbing_handyman_readmore_btn_icon', 'fas fa-chevron-right' ) ); ?>"></i>
					</a>
				</div>
			<?php endif; ?>
		</div>
	</div>

</article><!-- #post-<?php the_ID(); ?> -->