<?php if ( get_header_image() ) : ?>
	<a href="<?php echo esc_url( home_url( '/' ) ); ?>" id="custom-header" rel="home">
		<img src="<?php echo esc_url( header_image() ); ?>" width="<?php echo esc_attr( get_custom_header()->width ); ?>" height="<?php echo esc_attr( get_custom_header()->height ); ?>" alt="<?php echo esc_attr( get_bloginfo( 'title' ) ); ?>">
	</a>
<?php endif; ?>

<!-- Header Area -->

<?php
// Header values with translations
$tophead_instalink      = esc_attr( get_theme_mod( 'tophead_instalink', '#' ) );
$tophead_pinterestlink  = esc_attr( get_theme_mod( 'tophead_pinterestlink', '#' ) );
$tophead_fblink         = esc_attr( get_theme_mod( 'tophead_fblink', '#' ) );
$tophead_twitterlink    = esc_attr( get_theme_mod( 'tophead_twitterlink', '#' ) );

$tophead_mail           = esc_attr( get_theme_mod( 'tophead_mail', __( 'demo@example.com', 'plumber-man' ) ) );
$tophead_phone          = esc_attr( get_theme_mod( 'tophead_phone', __( '+000 0000 000', 'plumber-man' ) ) );
$tophead_btntext        = esc_attr( get_theme_mod( 'tophead_btntext', __( 'Get A Quote', 'plumber-man' ) ) );
$tophead_btnlink        = esc_attr( get_theme_mod( 'tophead_btnlink', '#' ) );

$stickyheader           = esc_attr( plumberman_sticky_menu() );
?>

<div class="main">
    <header class="main-header site-header <?php echo esc_attr( $stickyheader ); ?>">
        <div class="header-section">
            <div class="tophead">
                <div class="container">
                    <div class="row mr-0">
                        <div class="col-lg-4 col-md-4 col-sm-3 col-7">
                            <div class="socialicon">
                                <?php if ( $tophead_instalink ) : ?>
                                    <a href="<?php echo esc_url( apply_filters( 'plumberman_header', $tophead_instalink ) ); ?>">
                                        <i class="fa-brands fa-instagram"></i>
                                    </a>
                                <?php endif; ?>
                                <?php if ( $tophead_pinterestlink ) : ?>
                                    <a href="<?php echo esc_url( apply_filters( 'plumberman_header', $tophead_pinterestlink ) ); ?>">
                                        <i class="fa-brands fa-pinterest-p"></i>
                                    </a>
                                <?php endif; ?>
                                <?php if ( $tophead_fblink ) : ?>
                                    <a href="<?php echo esc_url( apply_filters( 'plumberman_header', $tophead_fblink ) ); ?>">
                                        <i class="fa-brands fa-facebook-f"></i>
                                    </a>
                                <?php endif; ?>
                                <?php if ( $tophead_twitterlink ) : ?>
                                    <a href="<?php echo esc_url( apply_filters( 'plumberman_header', $tophead_twitterlink ) ); ?>">
                                        <i class="fa-brands fa-x-twitter"></i>
                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>

                        <div class="col-lg-8 col-md-8 col-sm-9 col-5 emphbx">
                            <li>
                                <a href="tel:<?php echo esc_attr( $tophead_phone ); ?>">
                                    <i class="fa-solid fa-phone"></i>
                                    <span class="tooltip-text"><?php echo esc_html( $tophead_phone ); ?></span>
                                </a>
                            </li>
                            <li>
                                <a href="mailto:<?php echo esc_attr( $tophead_mail ); ?>">
                                    <i class="fa-solid fa-envelope"></i>
                                    <span class="tooltip-text"><?php echo esc_html( $tophead_mail ); ?></span>
                                </a>
                            </li>
                        </div>
                    </div>
                </div>
            </div>

            <div class="container">
                <div class="bthead">
                    <div class="btmmhead">
                        <div class="row mr-0">
                            <div class="col-lg-2 col-md-3 col-sm-6 col-6">
                                <div class="logobx">
                                    <div class="site-logo">
                                        <?php if ( has_custom_logo() ) : ?>
                                            <?php the_custom_logo(); ?>
                                        <?php else : ?>
                                            <a class="site-title" href="<?php echo esc_url( home_url( '/' ) ); ?>">
                                                <?php echo esc_html( get_bloginfo( 'name' ) ); ?>
                                            </a>
                                            <div class="box-info">
                                                <?php
                                                $plumberman_site_desc = get_bloginfo( 'description' );
                                                if ( $plumberman_site_desc ) :
                                                    ?>
                                                    <p class="site-description"><?php echo esc_html( $plumberman_site_desc ); ?></p>
                                                <?php endif; ?>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-8 col-md-4 col-sm-2 col-12 m-box">
                                <div class="menus">
                                    <nav class="navbar navbar-expand-lg navbaroffcanvase">
                                        <div class="navbar-menubar">
                                            <!-- Small Device Menu -->
                                            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target=".navbar-menu" aria-label="<?php echo esc_attr__( 'Toggle navigation', 'plumber-man' ); ?>">
                                                <i class="fa fa-bars"></i>
                                            </button>
                                            <div class="collapse navbar-collapse navbar-menu">
                                                <button class="navbar-toggler navbar-toggler-close" type="button" data-bs-toggle="collapse" data-bs-target=".navbar-menu" aria-label="<?php echo esc_attr__( 'Toggle navigation', 'plumber-man' ); ?>">
                                                    <i class="fa fa-times"></i>
                                                </button>
                                                <?php
                                                wp_nav_menu( array(
                                                    'theme_location' => 'primary_menu',
                                                    'container'      => '',
                                                    'menu_class'     => 'navbar-nav main-nav',
                                                    'fallback_cb'    => 'WP_Bootstrap_Navwalker::fallback',
                                                    'walker'         => new WP_Bootstrap_Navwalker(),
                                                ) );
                                                ?>
                                            </div>
                                        </div>
                                    </nav>
                                </div>
                                <div class="clearfix"></div>
                            </div>

                            <div class="col-lg-2 col-md-5 col-sm-4 col-6 fm-box">
                                <a href="<?php echo esc_url( apply_filters( 'plumberman_header', $tophead_btnlink ) ); ?>">
                                    <i class="fa-solid fa-phone"></i>
                                    <?php echo esc_html( apply_filters( 'plumberman_header', $tophead_btntext ) ); ?>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </header>
    <div class="clearfix"></div>
</div>
