<?php
function plumberman_header_settings( $wp_customize ) {
$selective_refresh = isset( $wp_customize->selective_refresh ) ? 'postMessage' : 'refresh';
	/*=========================================
	Header Settings Panel
	=========================================*/
	$wp_customize->add_panel( 
		'header_section', 
		array(
			'priority'      => 2,
			'capability'    => 'edit_theme_options',
			'title'			=> __('Header', 'plumber-man'),
		) 
	);

	
	/*=========================================
	Plumber Man Site Identity
	=========================================*/
	$wp_customize->add_section(
        'title_tagline',
        array(
        	'priority'      => 1,
            'title' 		=> __('Site Identity','plumber-man'),
			'panel'  		=> 'header_section',
		)
    );


	// topheader Logo Width
    $wp_customize->add_setting('topheader_logowidth',array(
        'default' => 100,
        'sanitize_callback' => 'plumberman_sanitize_float'
    ));
    $wp_customize->add_control(new plumberman_Custom_Control( $wp_customize, 'topheader_logowidth',array(
	    'label' => __('Logo Width','plumber-man'),
	    'section' => 'title_tagline',
	    'input_attrs' => array(
	            'min' => 0,
	            'max' => 500,
	            'step' => 1,
	        ),
    )));

	
	// logo section padding 
	$wp_customize->add_setting('plumberman_logo_padding',array(
		'sanitize_callback'   => 'esc_html'
	));
	$wp_customize->add_control('plumberman_logo_padding',array(
		'label' => __('Logo Padding','plumber-man'),
		'section' => 'title_tagline'
	));

	$wp_customize->add_setting('plumberman_logo_top_padding',array(
		'default' => '2',
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('plumberman_logo_top_padding',array(
		'type' => 'number',
		'label' => __('Top','plumber-man'),
		'section' => 'title_tagline',
	));

	$wp_customize->add_setting('plumberman_logo_left_padding',array(
		'default' => '2',
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('plumberman_logo_left_padding',array(
		'type' => 'number',
		'label' => __('Left','plumber-man'),
		'section' => 'title_tagline',
	));

	$wp_customize->add_setting('plumberman_logo_bottom_padding',array(
		'default' => '2',
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('plumberman_logo_bottom_padding',array(
		'type' => 'number',
		'label' => __('Bottom','plumber-man'),
		'section' => 'title_tagline',
	));

	$wp_customize->add_setting('plumberman_logo_right_padding',array(
		'default' => '2',
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('plumberman_logo_right_padding',array(
		'type' => 'number',
		'label' => __('Right','plumber-man'),
		'section' => 'title_tagline',
	));


    // top header Site Title Color
	$topheadersitetitlecol = esc_html__('#002434', 'plumber-man' );
	$wp_customize->add_setting(
    	'topheader_sitetitlecol',
    	array(
			'default' => $topheadersitetitlecol,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'topheader_sitetitlecol',
		array(
		    'label'   		=> __('Site Title Color','plumber-man'),
		    'section'		=> 'title_tagline',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);


	// top header Tagline Color
	$topheadertaglinecol = esc_html__('#002434', 'plumber-man' );
	$wp_customize->add_setting(
    	'topheader_taglinecol',
    	array(
			'default' => $topheadertaglinecol,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 4,
		)
	);	

	$wp_customize->add_control( 
		'topheader_taglinecol',
		array(
		    'label'   		=> __('Tagline Color','plumber-man'),
		    'section'		=> 'title_tagline',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);
	
 
	/*=========================================
	Plumber Man header
	=========================================*/
	$wp_customize->add_section(
        'top_header',
        array(
        	'priority'      => 5,
            'title' 		=> __('Header','plumber-man'),
			'panel'  		=> 'header_section',
		)
    );	

	
    $wp_customize->add_setting('plumberman_top_header_tabs', array(
	   'sanitize_callback' => 'wp_kses_post',
	));

	$wp_customize->add_control(new plumberman_Tab_Control($wp_customize, 'plumberman_top_header_tabs', array(
	   'section' => 'top_header',
	   'priority' => 1,
	   'buttons' => array(
	      array(
     		'name' => esc_html__('General', 'plumber-man'),
 			'icon' => 'dashicons dashicons-welcome-write-blog',
            'fields' => array(
            	'hide_show_sticky',
				'tophead_instalink',
				'tophead_pinterestlink',
				'tophead_fblink',
				'tophead_twitterlink',
				'tophead_mail',
				'tophead_phone',
				'tophead_btntext',
				'tophead_btnlink'

            ),
            'active' => true,
         ),
	      array(
            'name' => esc_html__('Style', 'plumber-man'),
            'icon' => 'dashicons dashicons-art',
            'fields' => array(
				'header_topheadbgcolor',
				'header_socialiconscolor',
				'header_socialiconshrvcolor',
				'header_phonmailiconcolor',
				'header_topheadphonmailtextcolor',
				'header_topheadtexthrvcolor',
				'header_bgcolor',
            	'header_menuscolor',
            	'header_menushovercolor',
            	'header_submenusbgcolor',
            	'header_submenusbordercolor',
            	'header_submenutextcolor',
				'header_submenutexticoncolor',
            	'header_submenusbghovercolor',
            	'header_submenustxthovercolor',
				'header_phonenumbericoncolor',
				'header_phonenumbericonbgcolor',
				'header_phonenumbertextcolor',
				'header_phonenumberboxbgcolor',
				'header_phonenumberboxbghrvcolor'
            ),
         )
	    
    	),
	)));


	// general setting

	// sticky header
	$wp_customize->add_setting( 'hide_show_sticky',array(
        'default' => false,
        'sanitize_callback' => 'plumberman_switch_sanitization'
   	) );
   	$wp_customize->add_control( new plumberman_Toggle_Switch_Custom_Control( $wp_customize, 'hide_show_sticky',array(
        'label' => __( 'Show Sticky Header','plumber-man' ),
        'section' => 'top_header'
   	)));

	// tophead instalink
	$topheadinstalink = esc_html__('#', 'plumber-man' );
	$wp_customize->add_setting(
    	'tophead_instalink',
    	array(
			'default' => $topheadinstalink,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 7,
		)
	);	

	$wp_customize->add_control( 
		'tophead_instalink',
		array(
		    'label'   		=> __('Instagtram Link','plumber-man'),
		    'section'		=> 'top_header',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);

	// tophead pinterestlink
	$topheadpinterestlink = esc_html__('#', 'plumber-man' );
	$wp_customize->add_setting(
    	'tophead_pinterestlink',
    	array(
			'default' => $topheadpinterestlink,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 7,
		)
	);	

	$wp_customize->add_control( 
		'tophead_pinterestlink',
		array(
		    'label'   		=> __('Pinterest Link','plumber-man'),
		    'section'		=> 'top_header',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);

	// tophead fblink
	$topheadfblink = esc_html__('#', 'plumber-man' );
	$wp_customize->add_setting(
    	'tophead_fblink',
    	array(
			'default' => $topheadfblink,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 7,
		)
	);	

	$wp_customize->add_control( 
		'tophead_fblink',
		array(
		    'label'   		=> __('Facebook Link','plumber-man'),
		    'section'		=> 'top_header',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);

	// tophead twitterlink
	$topheadtwitterlink = esc_html__('#', 'plumber-man' );
	$wp_customize->add_setting(
    	'tophead_twitterlink',
    	array(
			'default' => $topheadtwitterlink,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 7,
		)
	);	

	$wp_customize->add_control( 
		'tophead_twitterlink',
		array(
		    'label'   		=> __('Twitter Link','plumber-man'),
		    'section'		=> 'top_header',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);

	// tophead mail
	$topheadmail = esc_html__('demo@example.com', 'plumber-man' );
	$wp_customize->add_setting(
    	'tophead_mail',
    	array(
			'default' => $topheadmail,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 7,
		)
	);	

	$wp_customize->add_control( 
		'tophead_mail',
		array(
		    'label'   		=> __('Top Head Mail','plumber-man'),
		    'section'		=> 'top_header',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);

	// tophead phone
	$topheadphone = esc_html__('+000 0000 000', 'plumber-man' );
	$wp_customize->add_setting(
    	'tophead_phone',
    	array(
			'default' => $topheadphone,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 7,
		)
	);	

	$wp_customize->add_control( 
		'tophead_phone',
		array(
		    'label'   		=> __('Top Head Phone','plumber-man'),
		    'section'		=> 'top_header',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);

	// tophead btntext
	$topheadbtntext = esc_html__('Get A Quate', 'plumber-man' );
	$wp_customize->add_setting(
    	'tophead_btntext',
    	array(
			'default' => $topheadbtntext,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 7,
		)
	);	

	$wp_customize->add_control( 
		'tophead_btntext',
		array(
		    'label'   		=> __('Button Text','plumber-man'),
		    'section'		=> 'top_header',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);

	// tophead btnlink
	$topheadbtnlink = esc_html__('#', 'plumber-man' );
	$wp_customize->add_setting(
    	'tophead_btnlink',
    	array(
			'default' => $topheadbtnlink,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 7,
		)
	);	

	$wp_customize->add_control( 
		'tophead_btnlink',
		array(
		    'label'   		=> __('Button Text','plumber-man'),
		    'section'		=> 'top_header',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);

	

	// Style setting

	// header topheadbg Color
	$headertopheadbgcolor = esc_html__('#1B2334', 'plumber-man' );
	$wp_customize->add_setting(
    	'header_topheadbgcolor',
    	array(
			'default' => $headertopheadbgcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'header_topheadbgcolor',
		array(
		    'label'   		=> __('Top Head BG Color','plumber-man'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// header socialicons Color
	$headersocialiconscolor = esc_html__('#fff', 'plumber-man' );
	$wp_customize->add_setting(
    	'header_socialiconscolor',
    	array(
			'default' => $headersocialiconscolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'header_socialiconscolor',
		array(
		    'label'   		=> __('Top Head Social Icons Color','plumber-man'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// header socialiconshrv Color
	$headersocialiconshrvcolor = esc_html__('#8ECFF9', 'plumber-man' );
	$wp_customize->add_setting(
    	'header_socialiconshrvcolor',
    	array(
			'default' => $headersocialiconshrvcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'header_socialiconshrvcolor',
		array(
		    'label'   		=> __('Top Head Social Icons Hover Color','plumber-man'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// header phonmailicon Color
	$headerphonmailiconcolor = esc_html__('#fff', 'plumber-man' );
	$wp_customize->add_setting(
    	'header_phonmailiconcolor',
    	array(
			'default' => $headerphonmailiconcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'header_phonmailiconcolor',
		array(
		    'label'   		=> __('Top Head Icons Color','plumber-man'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// header topheadphnmailtext Color
	$headertopheadphnmailtextcolor = esc_html__('#fff', 'plumber-man' );
	$wp_customize->add_setting(
    	'header_topheadphonmailtextcolor',
    	array(
			'default' => $headertopheadphnmailtextcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'header_topheadphonmailtextcolor',
		array(
		    'label'   		=> __('Top Head Text Color','plumber-man'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// header topheadtexthrv Color
	$headertopheadtexthrvcolor = esc_html__('#8ECFF9', 'plumber-man' );
	$wp_customize->add_setting(
    	'header_topheadtexthrvcolor',
    	array(
			'default' => $headertopheadtexthrvcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'header_topheadtexthrvcolor',
		array(
		    'label'   		=> __('Top Head Text Hover Color','plumber-man'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);


	// header bg Color
	$headerbgcolor = esc_html__('#fff', 'plumber-man' );
	$wp_customize->add_setting(
    	'header_bgcolor',
    	array(
			'default' => $headerbgcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'header_bgcolor',
		array(
		    'label'   		=> __('Bottom Header BG Color','plumber-man'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// header menus Color
	$headermenuscolor = esc_html__('#002434', 'plumber-man' );
	$wp_customize->add_setting(
    	'header_menuscolor',
    	array(
			'default' => $headermenuscolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'header_menuscolor',
		array(
		    'label'   		=> __('Menus Color','plumber-man'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// header menushover Color
	$headermenushovercolor = esc_html__('#8ECFF9', 'plumber-man' );
	$wp_customize->add_setting(
    	'header_menushovercolor',
    	array(
			'default' => $headermenushovercolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'header_menushovercolor',
		array(
		    'label'   		=> __('Menus Hover & Active Color','plumber-man'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	$headersubmenusbgcolor = esc_html__('#fff', 'plumber-man' );
	$wp_customize->add_setting(
    	'header_submenusbgcolor',
    	array(
			'default' => $headersubmenusbgcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'header_submenusbgcolor',
		array(
		    'label'   		=> __('SubMenus BG Color','plumber-man'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	$headersubmenusbordercolor = esc_html__('#8ECFF9', 'plumber-man' );
	$wp_customize->add_setting(
    	'header_submenusbordercolor',
    	array(
			'default' => $headersubmenusbordercolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'header_submenusbordercolor',
		array(
		    'label'   		=> __('SubMenus Border Color','plumber-man'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);


	// header submenutext Color
	$headersubmenutextcolor = esc_html__('#8ECFF9', 'plumber-man' );
	$wp_customize->add_setting(
    	'header_submenutextcolor',
    	array(
			'default' => $headersubmenutextcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'header_submenutextcolor',
		array(
		    'label'   		=> __('SubMenus Text Color','plumber-man'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// header submenutexticon Color
	$headersubmenutexticoncolor = esc_html__('#000', 'plumber-man' );
	$wp_customize->add_setting(
    	'header_submenutexticoncolor',
    	array(
			'default' => $headersubmenutexticoncolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'header_submenutexticoncolor',
		array(
		    'label'   		=> __('SubMenus Text Icon Color','plumber-man'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// header submenusbghover Color
	$headersubmenusbghovercolor = esc_html__('#8ECFF9', 'plumber-man' );
	$wp_customize->add_setting(
    	'header_submenusbghovercolor',
    	array(
			'default' => $headersubmenusbghovercolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'header_submenusbghovercolor',
		array(
		    'label'   		=> __('SubMenus BG Hover Color','plumber-man'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// header submenustxthover Color
	$headersubmenustxthovercolor = esc_html__('#fff', 'plumber-man' );
	$wp_customize->add_setting(
    	'header_submenustxthovercolor',
    	array(
			'default' => $headersubmenustxthovercolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'header_submenustxthovercolor',
		array(
		    'label'   		=> __('SubMenus Text Hover Color','plumber-man'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// header phonenumbericon Color
	$headerphonenumbericoncolor = esc_html__('#000', 'plumber-man' );
	$wp_customize->add_setting(
    	'header_phonenumbericoncolor',
    	array(
			'default' => $headerphonenumbericoncolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'header_phonenumbericoncolor',
		array(
		    'label'   		=> __('Phone Number Icon Color','plumber-man'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// header phonenumbericonbg Color
	$headerphonenumbericonbgcolor = esc_html__('#fff', 'plumber-man' );
	$wp_customize->add_setting(
    	'header_phonenumbericonbgcolor',
    	array(
			'default' => $headerphonenumbericonbgcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'header_phonenumbericonbgcolor',
		array(
		    'label'   		=> __('Phone Number Icon BG Color','plumber-man'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);
	
	// header phonenumbertext Color
	$headerphonenumbertextcolor = esc_html__('#000', 'plumber-man' );
	$wp_customize->add_setting(
    	'header_phonenumbertextcolor',
    	array(
			'default' => $headerphonenumbertextcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'header_phonenumbertextcolor',
		array(
		    'label'   		=> __('Phone Number Text Color','plumber-man'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// header phonenumberboxbg Color
	$headerphonenumberboxbgcolor = esc_html__('#8ECFF9', 'plumber-man' );
	$wp_customize->add_setting(
    	'header_phonenumberboxbgcolor',
    	array(
			'default' => $headerphonenumberboxbgcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'header_phonenumberboxbgcolor',
		array(
		    'label'   		=> __('Phone Number Box BG Color','plumber-man'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// header phonenumberboxbghrv Color
	$headerphonenumberboxbghrvcolor = esc_html__('#2B85DD', 'plumber-man' );
	$wp_customize->add_setting(
    	'header_phonenumberboxbghrvcolor',
    	array(
			'default' => $headerphonenumberboxbghrvcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'header_phonenumberboxbghrvcolor',
		array(
		    'label'   		=> __('Phone Number Box BG Hover Color','plumber-man'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);


	$wp_customize->register_control_type('plumberman_Tab_Control');
	$wp_customize->register_panel_type( 'plumberman_WP_Customize_Panel' );
	$wp_customize->register_section_type( 'plumberman_WP_Customize_Section' );

}
add_action( 'customize_register', 'plumberman_header_settings' );



if ( class_exists( 'WP_Customize_Panel' ) ) {
  	class plumberman_WP_Customize_Panel extends WP_Customize_Panel {
	   public $panel;
	   public $type = 'plumberman_panel';
	   public function json() {

	      $array = wp_array_slice_assoc( (array) $this, array( 'id', 'description', 'priority', 'type', 'panel', ) );
	      $array['title'] = html_entity_decode( $this->title, ENT_QUOTES, get_bloginfo( 'charset' ) );
	      $array['content'] = $this->get_content();
	      $array['active'] = $this->active();
	      $array['instanceNumber'] = $this->instance_number;
	      return $array;
    	}
  	}
}

if ( class_exists( 'WP_Customize_Section' ) ) {
  	class plumberman_WP_Customize_Section extends WP_Customize_Section {
	   public $section;
	   public $type = 'plumberman_section';
	   public function json() {

	      $array = wp_array_slice_assoc( (array) $this, array( 'id', 'description', 'priority', 'panel', 'type', 'description_hidden', 'section', ) );
	      $array['title'] = html_entity_decode( $this->title, ENT_QUOTES, get_bloginfo( 'charset' ) );
	      $array['content'] = $this->get_content();
	      $array['active'] = $this->active();
	      $array['instanceNumber'] = $this->instance_number;

	      if ( $this->panel ) {
	        $array['customizeAction'] = sprintf( 'Customizing &#9656; %s', esc_html( $this->manager->get_panel( $this->panel )->title ) );
	      } else {
	        $array['customizeAction'] = 'Customizing';
	      }
	      return $array;
    	}
  	}
}






