<?php
function plumberman_blog_setting( $wp_customize ) {
$selective_refresh = isset( $wp_customize->selective_refresh ) ? 'postMessage' : 'refresh';
	$wp_customize->add_panel(
		'plumberman_frontpage_sections', array(
			'priority' => 32,
			'title' => esc_html__( 'Frontpage Sections', 'plumber-man' ),
		)
	);
	
 
	/*=========================================
	banner Section
	=========================================*/
	$wp_customize->add_section(
		'banner_setting', array(
			'title' => esc_html__( 'Banner Section', 'plumber-man' ),
			'priority' => 1,
			'panel' => 'plumberman_frontpage_sections',
		)
	);


	$wp_customize->add_setting('plumberman_banner_tabs', array(
	   'sanitize_callback' => 'wp_kses_post',
	));

	$wp_customize->add_control(new plumberman_Tab_Control($wp_customize, 'plumberman_banner_tabs', array(
	   'section' => 'banner_setting',
	   'priority' => 2,
	   'buttons' => array(
	      array(
         	'name' => esc_html__('General', 'plumber-man'),
            'icon' => 'dashicons dashicons-welcome-write-blog',
            'fields' => array(
            	'banner_image',
				'banner_spanheading',
				'banner_heading',
				'banner_description',
				'banner_btnlink',
				'banner_formsubheading',
				'banner_formheading',
				'banner_shortcode'
            ),
            'active' => true,
         ), 
	      array(
            'name' => esc_html__('Style', 'plumber-man'),
        	'icon' => 'dashicons dashicons-art',
            'fields' => array(
                'banner_headingcolor',
				'banner_descriptioncolor',
				'banner_btnphoneiconcolor',
				'banner_btnphoneiconbgcolor',
				'banner_btntextcolor',
				'banner_formbgcolor',
				'banner_formheadingcolor',
				'banner_formsubheadingcolor',
				'banner_formheadingbordercolor',
				'banner_formlabelcolor',
				'banner_formbtntextcolor',
				'banner_formbtnbgcolor',
				'banner_formbtnbghrvcolor'
            ),
     	)
    	),
	))); 


	

	// General Tab

	// banner_image
	$wp_customize->add_setting(
    	'banner_image',
	    array(
	        'sanitize_callback' => 'esc_url_raw'
	    )
	);
	$wp_customize->add_control(
	    new WP_Customize_Image_Control(
	        $wp_customize,
	        'banner_image',
	        array(
			    'label'   		=> __('Image','plumber-man'),
				'description'=> __('Image Size Should Be 483*724','plumber-man'),
	            'section' => 'banner_setting',
	            'settings' => 'banner_image'
	        )
	    )
	);

	// banner_spanheading
	$wp_customize->add_setting(
    	'banner_spanheading',
    	array(
			'default' => '',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'banner_spanheading',
		array(
		    'label'   		=> __('Span Heading','plumber-man'),
		    'section'		=> 'banner_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);	

	// banner_heading
	$wp_customize->add_setting(
    	'banner_heading',
    	array(
			'default' => '',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'banner_heading',
		array(
		    'label'   		=> __('Heading','plumber-man'),
		    'section'		=> 'banner_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);	
	
	// banner_description
	$wp_customize->add_setting(
    	'banner_description',
    	array(
			'default' => '',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'banner_description',
		array(
		    'label'   		=> __('Description','plumber-man'),
		    'section'		=> 'banner_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);	

	// banner_btnlink
	$wp_customize->add_setting(
    	'banner_btnlink',
    	array(
			'default' => '',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'banner_btnlink',
		array(
		    'label'   		=> __('Button Link','plumber-man'),
		    'section'		=> 'banner_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);	

	// banner_formsubheading
	$wp_customize->add_setting(
    	'banner_formsubheading',
    	array(
			'default' => '',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'banner_formsubheading',
		array(
		    'label'   		=> __('Form SubHeading','plumber-man'),
		    'section'		=> 'banner_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);	

	// banner_formheading
	$wp_customize->add_setting(
    	'banner_formheading',
    	array(
			'default' => '',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'banner_formheading',
		array(
		    'label'   		=> __('Form Heading','plumber-man'),
		    'section'		=> 'banner_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);	

	// banner_shortcode
	$wp_customize->add_setting(
    	'banner_shortcode',
    	array(
			'default' => '',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'banner_shortcode',
		array(
		    'label'   		=> __('Form shortcode','plumber-man'),
		    'section'		=> 'banner_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);	

	

	//style

	// banner heading Color
	$bannerheadingcolor = esc_html__('#fff', 'plumber-man' );
	$wp_customize->add_setting(
    	'banner_headingcolor',
    	array(
			'default' => $bannerheadingcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'banner_headingcolor',
		array(
		    'label'   		=> __('Heading Color','plumber-man'),
		    'section'		=> 'banner_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// banner description Color
	$bannerdescriptioncolor = esc_html__('#fff', 'plumber-man' );
	$wp_customize->add_setting(
    	'banner_descriptioncolor',
    	array(
			'default' => $bannerdescriptioncolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'banner_descriptioncolor',
		array(
		    'label'   		=> __('Description Color','plumber-man'),
		    'section'		=> 'banner_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// banner btnphoneicon Color
	$bannerbtnphoneiconcolor = esc_html__('#2B85DD', 'plumber-man' );
	$wp_customize->add_setting(
    	'banner_btnphoneiconcolor',
    	array(
			'default' => $bannerbtnphoneiconcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'banner_btnphoneiconcolor',
		array(
		    'label'   		=> __('Button Phone Icon Color','plumber-man'),
		    'section'		=> 'banner_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// banner btnphoneiconbg Color
	$bannerbtnphoneiconbgcolor = esc_html__('#CEEAFC', 'plumber-man' );
	$wp_customize->add_setting(
    	'banner_btnphoneiconbgcolor',
    	array(
			'default' => $bannerbtnphoneiconbgcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'banner_btnphoneiconbgcolor',
		array(
		    'label'   		=> __('Button Phone Icon BG Color','plumber-man'),
		    'section'		=> 'banner_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// banner btntext Color
	$bannerbtntextcolor = esc_html__('#fff', 'plumber-man' );
	$wp_customize->add_setting(
    	'banner_btntextcolor',
    	array(
			'default' => $bannerbtntextcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'banner_btntextcolor',
		array(
		    'label'   		=> __('Button Text Color','plumber-man'),
		    'section'		=> 'banner_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);


	// banner formbg Color
	$bannerformbgcolor = esc_html__('#fff', 'plumber-man' );
	$wp_customize->add_setting(
    	'banner_formbgcolor',
    	array(
			'default' => $bannerformbgcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'banner_formbgcolor',
		array(
		    'label'   		=> __('Form BG Color','plumber-man'),
		    'section'		=> 'banner_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// banner formheading Color
	$bannerformheadingcolor = esc_html__('#2B85DD', 'plumber-man' );
	$wp_customize->add_setting(
    	'banner_formheadingcolor',
    	array(
			'default' => $bannerformheadingcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'banner_formheadingcolor',
		array(
		    'label'   		=> __('Form Heading Color','plumber-man'),
		    'section'		=> 'banner_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// banner formsubheading Color
	$bannerformsubheadingcolor = esc_html__('#010101', 'plumber-man' );
	$wp_customize->add_setting(
    	'banner_formsubheadingcolor',
    	array(
			'default' => $bannerformsubheadingcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'banner_formsubheadingcolor',
		array(
		    'label'   		=> __('Form SubHeading Color','plumber-man'),
		    'section'		=> 'banner_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	

	// banner formheadingborder Color
	$bannerformheadingbordercolor = esc_html__('#2B85DD', 'plumber-man' );
	$wp_customize->add_setting(
    	'banner_formheadingbordercolor',
    	array(
			'default' => $bannerformheadingbordercolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'banner_formheadingbordercolor',
		array(
		    'label'   		=> __('Form Heading Border Color','plumber-man'),
		    'section'		=> 'banner_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	

	// banner formlabel Color
	$bannerformplaceholdercolor = esc_html__('#000', 'plumber-man' );
	$wp_customize->add_setting(
    	'banner_formlabelcolor',
    	array(
			'default' => $bannerformplaceholdercolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'banner_formlabelcolor',
		array(
		    'label'   		=> __('Form Label Color','plumber-man'),
		    'section'		=> 'banner_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// banner formbtntext Color
	$bannerformbtntextcolor = esc_html__('#000', 'plumber-man' );
	$wp_customize->add_setting(
    	'banner_formbtntextcolor',
    	array(
			'default' => $bannerformbtntextcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'banner_formbtntextcolor',
		array(
		    'label'   		=> __('Form Button Text Color','plumber-man'),
		    'section'		=> 'banner_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// banner formbtnbg Color
	$bannerformbtnbgcolor = esc_html__('#CEEAFC', 'plumber-man' );
	$wp_customize->add_setting(
    	'banner_formbtnbgcolor',
    	array(
			'default' => $bannerformbtnbgcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'banner_formbtnbgcolor',
		array(
		    'label'   		=> __('Form Button BG Color','plumber-man'),
		    'section'		=> 'banner_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// banner formbtnbghrv Color
	$bannerformbtnbghrvcolor = esc_html__('#2B85DD', 'plumber-man' );
	$wp_customize->add_setting(
    	'banner_formbtnbghrvcolor',
    	array(
			'default' => $bannerformbtnbghrvcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'banner_formbtnbghrvcolor',
		array(
		    'label'   		=> __('Form Button BG Hover Color','plumber-man'),
		    'section'		=> 'banner_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	

	/*=========================================
	aboutus Section
	=========================================*/
	$wp_customize->add_section(
		'aboutus_setting', array(
			'title' => esc_html__( 'AboutUs Section', 'plumber-man' ),
			'priority' => 2,
			'panel' => 'plumberman_frontpage_sections',
		)
	);

	$wp_customize->add_setting('plumberman_aboutus_tabs', array(
	   'sanitize_callback' => 'wp_kses_post',
	));

	$wp_customize->add_control(new plumberman_Tab_Control($wp_customize, 'plumberman_aboutus_tabs', array(
	   'section' => 'aboutus_setting',
	   'priority' => 2,
	   'buttons' => array(
	      array(
         	'name' => esc_html__('General', 'plumber-man'),
            'icon' => 'dashicons dashicons-welcome-write-blog',
            'fields' => array(
				'aboutus_disable_section',
				'aboutus_subtitle',
				'aboutus_spantitle',
				'aboutus_title',
				'aboutus_description',
				'aboutus_imag2',
				'box1_iconimg',
				'aboutus_box1heading',
				'aboutus_box1description',
				'box2_iconimg',
				'aboutus_box2heading',
				'aboutus_box2description',
				'box3_iconimg',
				'aboutus_box3heading',
				'aboutus_box3description',
            	'aboutus_image',
            	'aboutus_readmorebtn_link'
            ),
            'active' => true,
		),
		array(
		'name' => esc_html__('Style', 'plumber-man'),
		'icon' => 'dashicons dashicons-art',
		'fields' => array(
			'aboutus_subtitlecolor',
			'aboutus_spantitlecolor',
			'aboutus_titlecolor',
			'aboutus_descriptioncolor',
			'aboutus_boxheadingcolor',
			'aboutus_boxdescriptioncolor',
			'aboutus_btntextcolor',
			'aboutus_btnbgcolor',
			'aboutus_btnbghrvcolor'
		),
     	)
    	),
	))); 


	// hide show aboutus section
	$wp_customize->add_setting(
        'aboutus_disable_section',
        array(
            'sanitize_callback' => 'wp_kses_post',
        )
    ); 
    $wp_customize->add_control(
        new plumberman_Toggle_Switch_Custom_Control(
            $wp_customize,
            'aboutus_disable_section',
            array(
                'settings'      => 'aboutus_disable_section',
                'section'       => 'aboutus_setting',
                'label'         => __( 'Disable Section', 'plumber-man' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'plumber-man' ),
                    'off' => __( 'No', 'plumber-man' )
                ),
            )
        )
    );

	// aboutus_subtitle
	$wp_customize->add_setting(
    	'aboutus_subtitle',
    	array(
			'default' => '',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_subtitle',
		array(
		    'label'   		=> __('Sub Title','plumber-man'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);	


	// aboutus_spantitle
	$wp_customize->add_setting(
    	'aboutus_spantitle',
    	array(
			'default' => '',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_spantitle',
		array(
		    'label'   		=> __('Span Title','plumber-man'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);	

	// aboutus_title
	$wp_customize->add_setting(
    	'aboutus_title',
    	array(
			'default' => '',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_title',
		array(
		    'label'   		=> __('Title','plumber-man'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);	

	// aboutus_description
	$wp_customize->add_setting(
    	'aboutus_description',
    	array(
			'default' => '',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_description',
		array(
		    'label'   		=> __('Description','plumber-man'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);

	// aboutus_imag2
	$wp_customize->add_setting(
    	'aboutus_imag2',
	    array(
	        'sanitize_callback' => 'esc_url_raw'
	    )
	);
	$wp_customize->add_control(
	    new WP_Customize_Image_Control(
	        $wp_customize,
	        'aboutus_imag2',
	        array(
			    'label'   		=> __('Content Image','plumber-man'),
				'description'=> __('Image Size Should Be 586*750','plumber-man'),
	            'section' => 'aboutus_setting',
	            'settings' => 'aboutus_imag2'
	        )
	    )
	);

	// box1_iconimg
	$wp_customize->add_setting(
    	'box1_iconimg',
	    array(
	        'sanitize_callback' => 'esc_url_raw'
	    )
	);
	$wp_customize->add_control(
	    new WP_Customize_Image_Control(
	        $wp_customize,
	        'box1_iconimg',
	        array(
			    'label'   		=> __('Box 1 Icon Image','plumber-man'),
				'description'=> __('Image Size Should Be 60*60','plumber-man'),
	            'section' => 'aboutus_setting',
	            'settings' => 'box1_iconimg'
	        )
	    )
	);

	// aboutus_box1heading
	$wp_customize->add_setting(
    	'aboutus_box1heading',
    	array(
			'default' => '',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_box1heading',
		array(
		    'label'   		=> __('Box 1 Heading','plumber-man'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);

	// aboutus_box1description
	$wp_customize->add_setting(
    	'aboutus_box1description',
    	array(
			'default' => '',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_box1description',
		array(
		    'label'   		=> __('Box 1 Description','plumber-man'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);

	// box2_iconimg
	$wp_customize->add_setting(
    	'box2_iconimg',
	    array(
	        'sanitize_callback' => 'esc_url_raw'
	    )
	);
	$wp_customize->add_control(
	    new WP_Customize_Image_Control(
	        $wp_customize,
	        'box2_iconimg',
	        array(
			    'label'   		=> __('Box 2 Icon Image','plumber-man'),
				'description'=> __('Image Size Should Be 60*60','plumber-man'),
	            'section' => 'aboutus_setting',
	            'settings' => 'box2_iconimg'
	        )
	    )
	);

	// aboutus_box2heading
	$wp_customize->add_setting(
    	'aboutus_box2heading',
    	array(
			'default' => '',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_box2heading',
		array(
		    'label'   		=> __('Box 2 Heading','plumber-man'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);

	// aboutus_box2description
	$wp_customize->add_setting(
    	'aboutus_box2description',
    	array(
			'default' => '',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_box2description',
		array(
		    'label'   		=> __('Box 2 Description','plumber-man'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);

	// box3_iconimg
	$wp_customize->add_setting(
    	'box3_iconimg',
	    array(
	        'sanitize_callback' => 'esc_url_raw'
	    )
	);
	$wp_customize->add_control(
	    new WP_Customize_Image_Control(
	        $wp_customize,
	        'box3_iconimg',
	        array(
			    'label'   		=> __('Box 3 Icon Image','plumber-man'),
				'description'=> __('Image Size Should Be 60*60','plumber-man'),
	            'section' => 'aboutus_setting',
	            'settings' => 'box3_iconimg'
	        )
	    )
	);

	// aboutus_box3heading
	$wp_customize->add_setting(
    	'aboutus_box3heading',
    	array(
			'default' => '',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_box3heading',
		array(
		    'label'   		=> __('Box 3 Heading','plumber-man'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);

	// aboutus_box3description
	$wp_customize->add_setting(
    	'aboutus_box3description',
    	array(
			'default' => '',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_box3description',
		array(
		    'label'   		=> __('Box 3 Description','plumber-man'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);


	// aboutus_image
	$wp_customize->add_setting(
    	'aboutus_image',
	    array(
	        'sanitize_callback' => 'esc_url_raw'
	    )
	);
	$wp_customize->add_control(
	    new WP_Customize_Image_Control(
	        $wp_customize,
	        'aboutus_image',
	        array(
			    'label'   		=> __('Image','plumber-man'),
				'description'=> __('Image Size Should Be 408*672','plumber-man'),
	            'section' => 'aboutus_setting',
	            'settings' => 'aboutus_image'
	        )
	    )
	);

	// aboutus_readmorebtn_link
	$aboutusreadmorebtnlink = esc_html__('#', 'plumber-man' );
	$wp_customize->add_setting(
    	'aboutus_readmorebtn_link',
    	array(
			'default' => $aboutusreadmorebtnlink,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 7,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_readmorebtn_link',
		array(
		    'label'   		=> __('Read More Button Link','plumber-man'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);


	
	//style


	// aboutus subtitle Color
	$aboutussubtitlecolor = esc_html__('#002434', 'plumber-man' );
	$wp_customize->add_setting(
    	'aboutus_subtitlecolor',
    	array(
			'default' => $aboutussubtitlecolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_subtitlecolor',
		array(
		    'label'   		=> __('Sub Title Color','plumber-man'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// aboutus spantitle Color
	$aboutusspantitlecolor = esc_html__('#2B85DD', 'plumber-man' );
	$wp_customize->add_setting(
    	'aboutus_spantitlecolor',
    	array(
			'default' => $aboutusspantitlecolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_spantitlecolor',
		array(
		    'label'   		=> __('Span Title Color','plumber-man'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// aboutus title Color
	$aboutustitlecolor = esc_html__('#002434', 'plumber-man' );
	$wp_customize->add_setting(
    	'aboutus_titlecolor',
    	array(
			'default' => $aboutustitlecolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_titlecolor',
		array(
		    'label'   		=> __('Title Color','plumber-man'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// aboutus description Color
	$aboutusdescriptioncolor = esc_html__('#828282', 'plumber-man' );
	$wp_customize->add_setting(
    	'aboutus_descriptioncolor',
    	array(
			'default' => $aboutusdescriptioncolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_descriptioncolor',
		array(
		    'label'   		=> __('Description Color','plumber-man'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// aboutus boxheading Color
	$aboutusboxheadingcolor = esc_html__('#000', 'plumber-man' );
	$wp_customize->add_setting(
    	'aboutus_boxheadingcolor',
    	array(
			'default' => $aboutusboxheadingcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_boxheadingcolor',
		array(
		    'label'   		=> __('Box Heading Color','plumber-man'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// aboutus boxdescription Color
	$aboutusboxbordercolor = esc_html__('#b5b4b4', 'plumber-man' );
	$wp_customize->add_setting(
    	'aboutus_boxdescriptioncolor',
    	array(
			'default' => $aboutusboxbordercolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_boxdescriptioncolor',
		array(
		    'label'   		=> __('Box Description Color','plumber-man'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// aboutus btntext Color
	$aboutusbtntextcolor = esc_html__('#fff', 'plumber-man' );
	$wp_customize->add_setting(
    	'aboutus_btntextcolor',
    	array(
			'default' => $aboutusbtntextcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_btntextcolor',
		array(
		    'label'   		=> __('Button Text Color','plumber-man'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// aboutus btnbg Color 
	$aboutusbtnbgcolor = esc_html__('#0C244A', 'plumber-man' );
	$wp_customize->add_setting(
    	'aboutus_btnbgcolor',
    	array(
			'default' => $aboutusbtnbgcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_btnbgcolor',
		array(
		    'label'   		=> __('Button BG Color','plumber-man'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// aboutus btnbghrv Color
	$aboutusbtnbghrvcolor = esc_html__('#8ECFF9', 'plumber-man' );
	$wp_customize->add_setting(
    	'aboutus_btnbghrvcolor',
    	array(
			'default' => $aboutusbtnbghrvcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_btnbghrvcolor',
		array(
		    'label'   		=> __('Button BG Hover Color','plumber-man'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);


	/*=========================================
	ourservice Section
	=========================================*/
	$wp_customize->add_section(
		'ourservice_setting', array(
			'title' => esc_html__( 'Our Service Section', 'plumber-man' ),
			'priority' => 2,
			'panel' => 'plumberman_frontpage_sections',
		)
	);
	

	$wp_customize->add_setting('plumberman_ourservice_tabs', array(
	   'sanitize_callback' => 'wp_kses_post',
	));

	$wp_customize->add_control(new plumberman_Tab_Control($wp_customize, 'plumberman_ourservice_tabs', array(
	   'section' => 'ourservice_setting',
	   'priority' => 2,
	   'buttons' => array(
	      array(
         	'name' => esc_html__('General', 'plumber-man'),
            'icon' => 'dashicons dashicons-welcome-write-blog',
            'fields' => array(
            	'ourservice_disable_section',
				'ourservice_heading',
				'ourservice_subheading',
            	'ourservice1',
            	'ourservice2',
            	'ourservice3',
				'ourservice4',
            	'ourservice5',
            	'ourservice6'
            ),
            'active' => true,
         ),
	      array(
            'name' => esc_html__('Style', 'plumber-man'),
        	'icon' => 'dashicons dashicons-art',
            'fields' => array(
				'ourservice_headingbgcolor',
            	'ourservice_headingcolor',
            	'ourservice_subheadingcolor',
            	'ourservice_boxtitlecolor',
            	'ourservice_boxtitlehrvcolor',
				'ourservice_boxdescriptioncolor',
				'ourservice_btntextcolor',
				'ourservice_btntextbgcolor',
				'ourservice_btntextbghrvcolor'
            ),
     	)
	    
    	),
	))); 



	// General

	// hide show ourservice section
	$wp_customize->add_setting(
        'ourservice_disable_section',
        array(
            'sanitize_callback' => 'wp_kses_post',
        )
    ); 
    $wp_customize->add_control(
        new plumberman_Toggle_Switch_Custom_Control(
            $wp_customize,
            'ourservice_disable_section',
            array(
                'settings'      => 'ourservice_disable_section',
                'section'       => 'ourservice_setting',
                'label'         => __( 'Disable Section', 'plumber-man' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'plumber-man' ),
                    'off' => __( 'No', 'plumber-man' )
                ),
            )
        )
    );


    // ourservice_heading
	$wp_customize->add_setting(
    	'ourservice_heading',
    	array(
			'default' => '',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'ourservice_heading',
		array(
		    'label'   		=> __('Heading','plumber-man'),
		    'section'		=> 'ourservice_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);	

	// ourservice_subheading
	$wp_customize->add_setting(
    	'ourservice_subheading',
    	array(
			'default' => '',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'ourservice_subheading',
		array(
		    'label'   		=> __('SubHeading','plumber-man'),
		    'section'		=> 'ourservice_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);	


	// ourservice 1
	$wp_customize->add_setting( 
    	'ourservice1',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'ourservice1',
		array(
		    'label'   		=> __('Our Service 1','plumber-man'),
		    'section'		=> 'ourservice_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);		

	// ourservice 2
	$wp_customize->add_setting(
    	'ourservice2',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 2,
		)
	);	

	$wp_customize->add_control( 
		'ourservice2',
		array(
		    'label'   		=> __('Our Service 2','plumber-man'),
		    'section'		=> 'ourservice_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);	


	// ourservice 3
	$wp_customize->add_setting(
    	'ourservice3',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'ourservice3',
		array(
		    'label'   		=> __('Our Service 3','plumber-man'),
		    'section'		=> 'ourservice_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);	

	// ourservice 4
	$wp_customize->add_setting( 
    	'ourservice4',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 4,
		)
	);	

	$wp_customize->add_control( 
		'ourservice4',
		array(
		    'label'   		=> __('Our Service 4','plumber-man'),
		    'section'		=> 'ourservice_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);		

	// ourservice 5
	$wp_customize->add_setting(
    	'ourservice5',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 5,
		)
	);	

	$wp_customize->add_control( 
		'ourservice5',
		array(
		    'label'   		=> __('Our Service 5','plumber-man'),
		    'section'		=> 'ourservice_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);	


	// ourservice 6
	$wp_customize->add_setting(
    	'ourservice6',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 6,
		)
	);	

	$wp_customize->add_control( 
		'ourservice6',
		array(
		    'label'   		=> __('Our Service 6','plumber-man'),
		    'section'		=> 'ourservice_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);	


	// style

	// ourservice headingbg color
	$ourserviceheadingbgcolor = esc_html__('#0C244A', 'plumber-man' );
	$wp_customize->add_setting(
    	'ourservice_headingbgcolor',
    	array(
			'default' => $ourserviceheadingbgcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 4,
		)
	);	

	$wp_customize->add_control( 
		'ourservice_headingbgcolor',
		array(
		    'label'   		=> __('Heading BG Color','plumber-man'),
		    'section'		=> 'ourservice_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// ourservice heading color
	$ourserviceheadingcolor = esc_html__('#fff', 'plumber-man' );
	$wp_customize->add_setting(
    	'ourservice_headingcolor',
    	array(
			'default' => $ourserviceheadingcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 4,
		)
	);	

	$wp_customize->add_control( 
		'ourservice_headingcolor',
		array(
		    'label'   		=> __('Heading Color','plumber-man'),
		    'section'		=> 'ourservice_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// ourservice subheading color
	$ourservicesubheadingcolor = esc_html__('#fff', 'plumber-man' );
	$wp_customize->add_setting(
    	'ourservice_subheadingcolor',
    	array(
			'default' => $ourservicesubheadingcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 4,
		)
	);	

	$wp_customize->add_control( 
		'ourservice_subheadingcolor',
		array(
		    'label'   		=> __('SubHeading Color','plumber-man'),
		    'section'		=> 'ourservice_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);


	// ourservice boxtitle color
	$ourserviceboxtitlecolor = esc_html__('#2E2E2D', 'plumber-man' );
	$wp_customize->add_setting(
    	'ourservice_boxtitlecolor',
    	array(
			'default' => $ourserviceboxtitlecolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 4,
		)
	);	

	$wp_customize->add_control( 
		'ourservice_boxtitlecolor',
		array(
		    'label'   		=> __('Box Title Color','plumber-man'),
		    'section'		=> 'ourservice_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	

	// ourservice boxtitlehrv color
	$ourserviceboxtitlehrvcolor = esc_html__('#2E2E2D', 'plumber-man' );
	$wp_customize->add_setting(
    	'ourservice_boxtitlehrvcolor',
    	array(
			'default' => $ourserviceboxtitlehrvcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 4,
		)
	);	

	$wp_customize->add_control( 
		'ourservice_boxtitlehrvcolor',
		array(
		    'label'   		=> __('Box Title Hover Color','plumber-man'),
		    'section'		=> 'ourservice_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// ourservice boxdescription color
	$ourserviceboxdescriptioncolor = esc_html__('#939393', 'plumber-man' );
	$wp_customize->add_setting(
    	'ourservice_boxdescriptioncolor',
    	array(
			'default' => $ourserviceboxdescriptioncolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 4,
		)
	);	

	$wp_customize->add_control( 
		'ourservice_boxdescriptioncolor',
		array(
		    'label'   		=> __('Box Description Color','plumber-man'),
		    'section'		=> 'ourservice_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// ourservice btntext color
	$ourservicebtntextcolor = esc_html__('#fff', 'plumber-man' );
	$wp_customize->add_setting(
    	'ourservice_btntextcolor',
    	array(
			'default' => $ourservicebtntextcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 4,
		)
	);	

	$wp_customize->add_control( 
		'ourservice_btntextcolor',
		array(
		    'label'   		=> __('Button Text Color','plumber-man'),
		    'section'		=> 'ourservice_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// ourservice btntextbg color
	$ourservicebtntextbgcolor = esc_html__('#0C244A', 'plumber-man' );
	$wp_customize->add_setting(
    	'ourservice_btntextbgcolor',
    	array(
			'default' => $ourservicebtntextbgcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 4,
		)
	);	

	$wp_customize->add_control( 
		'ourservice_btntextbgcolor',
		array(
		    'label'   		=> __('Button BG Color','plumber-man'),
		    'section'		=> 'ourservice_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// ourservice btntextbghrv color
	$ourservicebtntextbghrvcolor = esc_html__('#8ECFF9', 'plumber-man' );
	$wp_customize->add_setting(
    	'ourservice_btntextbghrvcolor',
    	array(
			'default' => $ourservicebtntextbghrvcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 4,
		)
	);	

	$wp_customize->add_control( 
		'ourservice_btntextbghrvcolor',
		array(
		    'label'   		=> __('Button BG Hover Color','plumber-man'),
		    'section'		=> 'ourservice_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);



	$wp_customize->register_control_type('plumberman_Tab_Control');

}

add_action( 'customize_register', 'plumberman_blog_setting' );

// feature selective refresh
function plumberman_blog_section_partials( $wp_customize ){	
	// blog_title
	$wp_customize->selective_refresh->add_partial( 'blog_title', array(
		'selector'            => '.home-blog .title h6',
		'settings'            => 'blog_title',
		'render_callback'  => 'plumberman_blog_title_render_callback',
	
	) );
	
	// blog_subtitle
	$wp_customize->selective_refresh->add_partial( 'blog_subtitle', array(
		'selector'            => '.home-blog .title h2',
		'settings'            => 'blog_subtitle',
		'render_callback'  => 'plumberman_blog_subtitle_render_callback',
	
	) );
	
	// blog_description
	$wp_customize->selective_refresh->add_partial( 'blog_description', array(
		'selector'            => '.home-blog .title p',
		'settings'            => 'blog_description',
		'render_callback'  => 'plumberman_blog_description_render_callback',
	
	) );	
	}

add_action( 'customize_register', 'plumberman_blog_section_partials' );

// blog_title
function plumberman_blog_title_render_callback() {
	return get_theme_mod( 'blog_title' );
}

// blog_subtitle
function plumberman_blog_subtitle_render_callback() {
	return get_theme_mod( 'blog_subtitle' );
}

// feature description
function plumberman_blog_description_render_callback() {
	return get_theme_mod( 'blog_description' );
}


