<?php
function plumberman_custom_header_setup() {
	add_theme_support( 'custom-header', apply_filters( 'plumberman_custom_header_args', array(
		'default-image'          => '',
		'default-text-color'     => 'fff',
		'width'                  => 2000, 
		'height'                 => 200,
		'flex-height'            => true,
		'wp-head-callback'       => 'plumberman_header_style',
	) ) );
}
add_action( 'after_setup_theme', 'plumberman_custom_header_setup' );

if ( ! function_exists( 'plumberman_header_style' ) ) :

function plumberman_header_style() {
	$header_text_color = get_header_textcolor();

	$topheader_logowidth = esc_attr(get_theme_mod('topheader_logowidth','100'));

	$plumberman_logo_top_padding = esc_attr(get_theme_mod('plumberman_logo_top_padding','2'));
	$plumberman_logo_left_padding = esc_attr(get_theme_mod('plumberman_logo_left_padding','2'));
	$plumberman_logo_bottom_padding = esc_attr(get_theme_mod('plumberman_logo_bottom_padding','2'));
	$plumberman_logo_right_padding = esc_attr(get_theme_mod('plumberman_logo_right_padding','2'));


  	$blog_disable_section = esc_attr(get_theme_mod('blog_disable_section','YES'));
  	$ourservice_disable_section = esc_attr(get_theme_mod('ourservice_disable_section','YES'));
  	$aboutus_disable_section = esc_attr(get_theme_mod('aboutus_disable_section','YES'));


	?>
	<style type="text/css">


		<?php 
		
		?>


		.site-logo img {
			width: <?php echo apply_filters('plumberman_topheader', $topheader_logowidth); ?>%;
		}

		.site-logo img {
			padding-top: <?php echo apply_filters('plumberman_topheader', $plumberman_logo_top_padding); ?>px;
			padding-left: <?php echo apply_filters('plumberman_topheader', $plumberman_logo_left_padding); ?>px;
			padding-bottom: <?php echo apply_filters('plumberman_topheader', $plumberman_logo_bottom_padding); ?>px;
			padding-right: <?php echo apply_filters('plumberman_topheader', $plumberman_logo_right_padding); ?>px;
		}


		header.site-header .site-title {
			color: <?php echo esc_attr(get_theme_mod('topheader_sitetitlecol')); ?>;
		}

		header.site-header .site-logo a {
			text-decoration-color: <?php echo esc_attr(get_theme_mod('topheader_sitetitlecol')); ?> !important;
		}

		p.site-description {
			color: <?php echo esc_attr(get_theme_mod('topheader_taglinecol')); ?>;
		}
		


		
	
		header .tophead {
			background: <?php echo esc_attr(get_theme_mod('header_topheadbgcolor')); ?>;
		}

		header .socialicon a {
			color: <?php echo esc_attr(get_theme_mod('header_socialiconscolor')); ?>;
		}

		header .socialicon a:hover i {
			color: <?php echo esc_attr(get_theme_mod('header_socialiconshrvcolor')); ?>;
		}

		header .emphbx li i {
			color: <?php echo esc_attr(get_theme_mod('header_phonmailiconcolor')); ?>;
		}

		header .emphbx li a, header .emphbx li p {
			color: <?php echo esc_attr(get_theme_mod('header_topheadphonmailtextcolor')); ?>;
		}

		header .emphbx li a:hover, header .emphbx li p:hover {
			color: <?php echo esc_attr(get_theme_mod('header_topheadtexthrvcolor')); ?>;
		}

		header .btmmhead {
			background: <?php echo esc_attr(get_theme_mod('header_bgcolor')); ?>;
		}

		.main-header .navbar .navbar-menu ul li a, .main-header .navbar .navbar-menu ul li.dropdown>a::after {
			color: <?php echo esc_attr(get_theme_mod('header_menuscolor')); ?>;
		}

		.main-header .navbar .navbar-nav > li:hover a, .main-header .navbar .navbar-nav > li.focus a, .main-header .navbar .navbar-nav > li.active a, .main-header .navbar .navbar-nav > li a.active,.main-header .navbar .navbar-menu ul li:hover.dropdown>a::after {
			color: <?php echo esc_attr(get_theme_mod('header_menushovercolor')); ?>;
		}
		.main-header .navbar .navbar-nav > li:hover a::before, .main-header .navbar .navbar-nav > li.focus a::before, .main-header .navbar .navbar-nav > li.active a::before, .main-header .navbar .navbar-nav > li a.active::before {
			border-color: <?php echo esc_attr(get_theme_mod('header_menushovercolor')); ?>;
		}
		.main-header .navbar .navbar-nav > li:hover a span::before, .main-header .navbar .navbar-nav > li.focus a span::before, .main-header .navbar .navbar-nav > li.active a span::before, .main-header .navbar .navbar-nav > li.active a span:before {
			background: <?php echo esc_attr(get_theme_mod('header_menushovercolor')); ?>;
		}

		.main-header .navbar .navbar-menu ul li.dropdown .sub-menu a:not(.remove) {
			color: <?php echo esc_attr(get_theme_mod('header_submenutextcolor')); ?>;
		}

		.main-header .navbar .navbar-menu ul li.dropdown .sub-menu>.dropdown:after {
			color: <?php echo esc_attr(get_theme_mod('header_submenutexticoncolor')); ?>;
		}

		.main-header .navbar .navbar-menu ul li.dropdown .sub-menu a {
			background: <?php echo esc_attr(get_theme_mod('header_submenusbgcolor')); ?>;
		}

		.main-header .navbar .navbar-menu ul li.dropdown .sub-menu a:not(.remove) {
			border-left-color: <?php echo esc_attr(get_theme_mod('header_submenusbordercolor')); ?>;
		}

		.main-header .navbar .navbar-menu ul li.dropdown .sub-menu li a:hover {
			background: <?php echo esc_attr(get_theme_mod('header_submenusbghovercolor')); ?>;
		}

		.main-header .navbar .navbar-menu ul li.dropdown .sub-menu a:hover{
			color: <?php echo esc_attr(get_theme_mod('header_submenustxthovercolor')); ?> !important;
		}

		header .fm-box a i {
			color: <?php echo esc_attr(get_theme_mod('header_phonenumbericoncolor')); ?>;
		}

		header .fm-box a i {
			background: <?php echo esc_attr(get_theme_mod('header_phonenumbericonbgcolor')); ?>;
		}

		header .fm-box a {
			color: <?php echo esc_attr(get_theme_mod('header_phonenumbertextcolor')); ?>;
		}	

		header .fm-box a {
			background: <?php echo esc_attr(get_theme_mod('header_phonenumberboxbgcolor')); ?>;
		}

		header .fm-box a:hover {
			background: <?php echo esc_attr(get_theme_mod('header_phonenumberboxbghrvcolor')); ?>;
		}
	

		/* Banner Section */

		#banner-section .b-contentbx h4 {
			color: <?php echo esc_attr(get_theme_mod('banner_headingcolor')); ?>;
		}

		#banner-section .b-contentbx p {
			color: <?php echo esc_attr(get_theme_mod('banner_descriptioncolor')); ?>;
		}

		#banner-section .b_btn a i {
			color: <?php echo esc_attr(get_theme_mod('banner_btnphoneiconcolor')); ?>;
		}

		#banner-section .b_btn a i {
			background: <?php echo esc_attr(get_theme_mod('banner_btnphoneiconbgcolor')); ?>;
		}

		#banner-section .b_btn a {
			color: <?php echo esc_attr(get_theme_mod('banner_btntextcolor')); ?>;
		}

		#banner-section .form {
			background: <?php echo esc_attr(get_theme_mod('banner_formbgcolor')); ?>;
		}

		#banner-section .banner-form h2 {
			color: <?php echo esc_attr(get_theme_mod('banner_formheadingcolor')); ?>;
		}

		#banner-section .banner-form .fmsubtitle {
			color: <?php echo esc_attr(get_theme_mod('banner_formsubheadingcolor')); ?>;
		}

		#banner-section .banner-form .fmsubtitle:before {
			color: <?php echo esc_attr(get_theme_mod('banner_formheadingbordercolor')); ?>;
		}

		#banner-section form label {
			color: <?php echo esc_attr(get_theme_mod('banner_formlabelcolor')); ?>;
		}

		#banner-section button[type="submit"], #banner-section input[type="button"], #banner-section input[type="reset"], #banner-section input[type="submit"] {
			color: <?php echo esc_attr(get_theme_mod('banner_formbtntextcolor')); ?>;
		}

		#banner-section button[type="submit"], #banner-section input[type="button"], #banner-section input[type="reset"], #banner-section input[type="submit"] {
			background: <?php echo esc_attr(get_theme_mod('banner_formbtnbgcolor')); ?>;
		}

		#banner-section input[type="submit"]:hover {
			background: <?php echo esc_attr(get_theme_mod('banner_formbtnbghrvcolor')); ?>;
		}


	
		/* Our Treatment */

		#ourservice-section .overlay {
			color: <?php echo esc_attr(get_theme_mod('ourservice_headingbgcolor')); ?>;
		}

		#ourservice-section .heading h2 {
			color: <?php echo esc_attr(get_theme_mod('ourservice_headingcolor')); ?>;
		}

		#ourservice-section .heading h3 {
			color: <?php echo esc_attr(get_theme_mod('ourservice_subheadingcolor')); ?>;
		}

		#ourservice-section .box-space h3 {
			color: <?php echo esc_attr(get_theme_mod('ourservice_boxtitlecolor')); ?>;
		}

		#ourservice-section .box-space h3:hover {
			color: <?php echo esc_attr(get_theme_mod('ourservice_boxtitlehrvcolor')); ?>;
		}

		#ourservice-section .box-space p {
			color: <?php echo esc_attr(get_theme_mod('ourservice_boxdescriptioncolor')); ?>;
		}

		#ourservice-section .bttn a {
			color: <?php echo esc_attr(get_theme_mod('ourservice_btntextcolor')); ?>;
		}

		#ourservice-section .bttn a {
			background: <?php echo esc_attr(get_theme_mod('ourservice_btntextbgcolor')); ?>;
		}

		#ourservice-section .bttn a {
			background: <?php echo esc_attr(get_theme_mod('ourservice_btntextbghrvcolor')); ?>;
		}





		/* about us */

		#aboutus-section .abt-dbx h4 {
			color: <?php echo esc_attr(get_theme_mod('aboutus_subtitlecolor')); ?>;
		}

		#aboutus-section .abt-dbx h2 span {
			color: <?php echo esc_attr(get_theme_mod('aboutus_spantitlecolor')); ?>;
		}

		#aboutus-section .abt-dbx h2 {
			color: <?php echo esc_attr(get_theme_mod('aboutus_titlecolor')); ?>;
		}

		#aboutus-section .abt-description p {
			color: <?php echo esc_attr(get_theme_mod('aboutus_descriptioncolor')); ?>;
		}

		#aboutus-section .conbox h2 {
			color: <?php echo esc_attr(get_theme_mod('aboutus_boxheadingcolor')); ?>;
		}

		#aboutus-section .abtdetail .boxdescriptoin p {
			color: <?php echo esc_attr(get_theme_mod('aboutus_boxdescriptioncolor')); ?>;
		}

		#aboutus-section .abt-btn a {
			color: <?php echo esc_attr(get_theme_mod('aboutus_btntextcolor')); ?> !important;
		}

		#aboutus-section .abt-btn a {
			background: <?php echo esc_attr(get_theme_mod('aboutus_btnbgcolor')); ?>;
		}

		#aboutus-section .abt-btn a:hover {
			background: <?php echo esc_attr(get_theme_mod('aboutus_btnbghrvcolor')); ?> !important;
		}
		


		.copy-right p,.copy-right p a {
			color: <?php echo esc_attr(get_theme_mod('footer_copyrightcolor')); ?>;
		}

		.copy-right {
			border-color: <?php echo esc_attr(get_theme_mod('footer_copyrightbrdcolor')); ?>;
		}

		.footer-area {
			background: <?php echo esc_attr(get_theme_mod('footer_bgcolor')); ?>;
		}

		.footer-area .footer-widget .w-title {
			color: <?php echo esc_attr(get_theme_mod('footer_widgettilecolor')); ?>;
		}

		.footer-area .widget_text, .footer-area .widget_text p, .wp-block-latest-comments__comment-excerpt p, .wp-block-latest-comments__comment-date, .has-avatars .wp-block-latest-comments__comment .wp-block-latest-comments__comment-excerpt, .has-avatars .wp-block-latest-comments__comment .wp-block-latest-comments__comment-meta,.footer-area .widget_block h1, .footer-area .widget_block h2, .footer-area .widget_block h3, .footer-area .widget_block h4, .footer-area .widget_block h5, .footer-area .widget_block h6,.footer-area .footer-widget .widget:not(.widget_social_widget):not(.widget_tag_cloud) li a {
			color: <?php echo esc_attr(get_theme_mod('footer_textcolor')); ?>;
		}

		.footer-area li:before, .page-template-home-template .footer-area li:before, .page .footer-area li:before, .single .footer-area li:before {
			color: <?php echo esc_attr(get_theme_mod('footer_iconcolor')); ?>;
		}

		.footer-area .footer-widget .widget:not(.widget_social_widget):not(.widget_tag_cloud) li a:hover {
			color: <?php echo esc_attr(get_theme_mod('footer_listhovercolor')); ?>;
		}

		.scroll-top i {
			color: <?php echo esc_attr(get_theme_mod('footer_scrolltotopiconcolor')); ?>;
		}

		.scroll-top {
			background: <?php echo esc_attr(get_theme_mod('footer_scrolltotopiconbgcolor')); ?>;
		}

		.scroll-top:hover {
			background: <?php echo esc_attr(get_theme_mod('footer_scrolltotopiconbghrvcolor')); ?>;
		}

		
	<?php  ?>


	<?php
		if ( ! display_header_text() ) :
	?>
		.site-title,
		.site-description {
			position: absolute;
			clip: rect(1px, 1px, 1px, 1px);
		}
	<?php
		else :
	?>
		.breadcrumb-section h1{
			color: #<?php echo esc_attr( $header_text_color ); ?>;
		}
	<?php endif; ?>



	<?php
        if ($blog_disable_section == 1):
	?>
		#blog-section {
			display: none;
		}
	<?php
		else :
	?>
		#blog-section {
			display: block;
		}
	<?php endif; ?>


	<?php
        if ($ourservice_disable_section == 1):
	?>
		#ourservice-section {
			display: none;
		}
	<?php
		else :
	?>
		#ourservice-section {
			display: block;
		}
	<?php endif; ?>


	<?php
        if ($aboutus_disable_section == 1):
	?>
		#aboutus-section {
			display: none;
		}
	<?php
		else :
	?>
		#aboutus-section {
			display: block;
		}
	<?php endif; ?>



	</style>
	<?php
}
endif;
