var menu = [];
jQuery('.plumber_manswiper-slide').each( function(index){
    menu.push( jQuery(this).find('.plumber_manslide-inner').attr("data-text") );
});
var interleaveOffset = 0.5;
var swiperOptions = {
    loop: true,
    speed: 1000,
    parallax: true,
    autoplay: {
        delay: 6500,
        disableOnInteraction: false,
    },
    watchSlidesProgress: true,
    pagination: {
        el: '.plumber_manswiper-pagination',
        clickable: true,
    },
    navigation: {
        nextEl: '.plumber_manswiper-button-next',
        prevEl: '.plumber_manswiper-button-prev',
    },
    on: {
        progress: function() {
            var swiper = this;
            for (var i = 0; i < swiper.slides.length; i++) {
                var slideProgress = swiper.slides[i].progress;
                var innerOffset = swiper.width * interleaveOffset;
                var innerTranslate = slideProgress * innerOffset;
                swiper.slides[i].querySelector(".plumber_manslide-inner").style.transform =
                "translate3d(" + innerTranslate + "px, 0, 0)";
            }      
        },

        touchStart: function() {
          var swiper = this;
          for (var i = 0; i < swiper.slides.length; i++) {
            swiper.slides[i].style.transition = "";
          }
        },

        setTransition: function(speed) {
            var swiper = this;
            for (var i = 0; i < swiper.slides.length; i++) {
                swiper.slides[i].style.transition = speed + "ms";
                swiper.slides[i].querySelector(".plumber_manslide-inner").style.transition =
                speed + "ms";
            }
        }
    }
};
var swiper = new Swiper(".plumber_manswiper-container", swiperOptions);


document.getElementById("scroll-down-btn").addEventListener("click", function() {
    document.querySelector("#ourservice-section").scrollIntoView({ 
        behavior: 'smooth' 
    });
});

