<?php
/**
 * Template part for displaying posts.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package plumber_handyman_lite
 */
$plumber_handyman_lite_heading_setting  = get_theme_mod( 'plumber_handyman_lite_post_heading_setting' , true );
$plumber_handyman_lite_meta_setting  = get_theme_mod( 'plumber_handyman_lite_post_meta_setting' , true );
$plumber_handyman_lite_image_setting  = get_theme_mod( 'plumber_handyman_lite_post_image_setting' , true );
$plumber_handyman_lite_content_setting  = get_theme_mod( 'plumber_handyman_lite_post_content_setting' , true );
$plumber_handyman_lite_read_more_setting = get_theme_mod( 'plumber_handyman_lite_read_more_setting' , true );
$plumber_handyman_lite_read_more_text = get_theme_mod( 'plumber_handyman_lite_read_more_text', __( 'Read More', 'plumber-handyman-lite' ) );
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
    <?php 
    $plumber_handyman_lite_meta_order = get_theme_mod('plumber_handyman_lite_blog_meta_order', array('heading', 'author', 'featured-image', 'content', 'button'));
    
    foreach ($plumber_handyman_lite_meta_order as $plumber_handyman_lite_order) :
        if ('heading' === $plumber_handyman_lite_order) :
            if ($plumber_handyman_lite_heading_setting) { ?>
                <header class="entry-header">
                    <?php if (is_single()) {
                        the_title('<h1 class="entry-title" itemprop="headline">', '</h1>');
                    } else {
                        the_title('<h2 class="entry-title" itemprop="headline"><a href="' . esc_url(get_permalink()) . '" rel="bookmark">', '</a></h2>');
                    } ?>
                </header>
            <?php }
        endif;

        if ('author' === $plumber_handyman_lite_order) :
            if ('post' === get_post_type() && $plumber_handyman_lite_meta_setting) { ?>
                <div class="entry-meta">
                    <?php plumber_handyman_lite_posted_on(); ?>
                </div>
            <?php }
        endif;

        if ('featured-image' === $plumber_handyman_lite_order) :
            if ($plumber_handyman_lite_image_setting) { ?>
                <?php echo (!is_single()) ? '<a href="' . esc_url(get_the_permalink()) . '" class="post-thumbnail">' : '<div class="post-thumbnail">'; ?>
                    <?php if (has_post_thumbnail()) {
                        if (is_active_sidebar('right-sidebar')) {
                            the_post_thumbnail('plumber-handyman-lite-with-sidebar', array('itemprop' => 'image'));
                        } else {
                            the_post_thumbnail('plumber-handyman-lite-without-sidebar', array('itemprop' => 'image'));
                        }
                    } else { ?>
                        <img src="<?php echo esc_url(get_stylesheet_directory_uri() . '/images/default.png'); ?>" alt="<?php esc_attr_e('Image', 'plumber-handyman-lite'); ?>">
                    <?php } ?>
                <?php echo (!is_single()) ? '</a>' : '</div>'; ?>
            <?php }
        endif;

        if ('content' === $plumber_handyman_lite_order) :
            if ($plumber_handyman_lite_content_setting) { ?>
                <div class="entry-content" itemprop="text">
                    <?php if (is_single()) {
                        the_content(
                            sprintf(
                                wp_kses(
                                    __('Continue reading %s <span class="meta-nav">&rarr;</span>', 'plumber-handyman-lite'),
                                    array('span' => array('class' => array()))
                                ),
                                '<span class="screen-reader-text">"' . get_the_title() . '"</span>'
                            )
                        );
                    } else {
                        the_excerpt();
                    }
                    
                    wp_link_pages(array(
                        'before' => '<div class="page-links">' . esc_html__('Pages:', 'plumber-handyman-lite'),
                        'after'  => '</div>',
                    ));
                    ?>
                </div>
            <?php }
        endif;

        if ('button' === $plumber_handyman_lite_order) :
            if (!is_single() && $plumber_handyman_lite_read_more_setting) { ?>
                <div class="read-more-button">
                    <a href="<?php echo esc_url(get_permalink()); ?>" class="read-more-button"><?php echo esc_html($plumber_handyman_lite_read_more_text); ?></a>
                </div>
            <?php }
        endif;
    endforeach; ?>
</article>