<?php
/**
 * Template part for displaying posts.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package plumber_handyman_lite
 */
$plumber_handyman_lite_heading_setting  = get_theme_mod( 'plumber_handyman_lite_post_heading_setting' , true );
$plumber_handyman_lite_meta_setting  = get_theme_mod( 'plumber_handyman_lite_post_meta_setting' , true );
$plumber_handyman_lite_content_setting  = get_theme_mod( 'plumber_handyman_lite_post_content_setting' , true );
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<header class="entry-header">
		<?php
		  if ( $plumber_handyman_lite_heading_setting ){ 
			if ( is_single() ) {
				the_title( '<h1 class="entry-title" itemprop="headline">', '</h1>' );
			} else {
				the_title( '<h2 class="entry-title" itemprop="headline"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
			}
		  }

		if ( 'post' === get_post_type() ) : ?>
		<?php
		if ( $plumber_handyman_lite_meta_setting ){ ?>
			<div class="entry-meta">
				<?php plumber_handyman_lite_posted_on(); ?>
			</div><!-- .entry-meta -->
		<?php } ?>
		<?php
		endif; ?>
	</header><!-- .entry-header -->
	 <?php
			// Get the post ID
			$plumber_handyman_lite_post_id = get_the_ID();

			// Check if there are audio embedded in the post content
			$plumber_handyman_lite_post = get_post($plumber_handyman_lite_post_id);
			$plumber_handyman_lite_content = do_shortcode(apply_filters('the_content', $plumber_handyman_lite_post->post_content));
			$plumber_handyman_lite_embeds = get_media_embedded_in_content($plumber_handyman_lite_content);

			if (!empty($plumber_handyman_lite_embeds)) {
			    // Loop through embedded media and display only audio
			    foreach ($plumber_handyman_lite_embeds as $embed) {
			        // Check if the embed code contains an audio tag or specific audio providers like SoundCloud
			        if (strpos($embed, 'audio') !== false || strpos($embed, 'soundcloud') !== false) {
			            ?>
			            <div class="custom-embedded-audio">
			                <div class="media-container">
			                    <?php echo $embed; ?>
			                </div>
			                <div class="media-comments">
			                    <?php
			                    // Add your comments section here
			                    comments_template(); // This will include the default WordPress comments template
			                    ?>
			                </div>
			            </div>
			            <?php
			        }
			    }
			}
		?>
    <?php
	if ( $plumber_handyman_lite_content_setting ){ ?>
		<div class="entry-content" itemprop="text">
			<?php
			if( is_single()){
				the_content( sprintf(
					/* translators: %s: Name of current post. */
					wp_kses( __( 'Continue reading %s <span class="meta-nav">&rarr;</span>', 'plumber-handyman-lite' ), array( 'span' => array( 'class' => array() ) ) ),
					the_title( '<span class="screen-reader-text">"', '"</span>', false )
				) );
				}else{
				the_excerpt();
				}
				wp_link_pages( array(
					'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'plumber-handyman-lite' ),
					'after'  => '</div>',
				) );
			?>
		</div><!-- .entry-content -->
    <?php } ?>
</article><!-- #post-## -->