<?php 
/**
 * Template part for displaying Count Section
 *
 * @package Plumber Handyman Lite
 */

$plumber_handyman_lite_count = get_theme_mod( 'plumber_handyman_lite_count_setting',false );
$plumber_handyman_lite_opening_time_title = get_theme_mod( 'plumber_handyman_lite_opening_time_title' );
?>
<?php if ( $plumber_handyman_lite_count ){?>
    <div id="counter-section" class="section-content" >
        <div class="container">        
            <div class="row">
                <div class="col-lg-4 col-md-6 col-12 py-5 count-timer wow zoomIn" data-wow-duration="2s">
                    <div class="week-days">
                        <?php if ( !empty($plumber_handyman_lite_opening_time_title) ) : ?>
                            <h3><?php echo esc_html($plumber_handyman_lite_opening_time_title); ?></h3>
                        <?php endif; ?>
                        <hr>
                        <?php 
                        $plumber_handyman_lite_days = array(
                            'monday'    => 'Monday',
                            'tuesday'   => 'Tuesday',
                            'wednesday' => 'Wednesday',
                            'thursday'  => 'Thursday',
                            'friday'    => 'Friday',
                            'saturday'  => 'Saturday',
                            'sunday'    => 'Sunday',
                        );
                        foreach ( $plumber_handyman_lite_days as $plumber_handyman_lite_key => $plumber_handyman_lite_label ) :
                            $plumber_handyman_lite_time = get_theme_mod( "plumber_handyman_lite_opening_time_$plumber_handyman_lite_key" );

                            // Fallback default values
                            if ( empty( $plumber_handyman_lite_time ) ) {
                                $plumber_handyman_lite_time = ( $plumber_handyman_lite_key === 'sunday' ) ? '' : '';
                            }
                        ?>
                        <div class="row">
                            <span>
                                <p class="<?php echo esc_attr($plumber_handyman_lite_key); ?>">
                                    <?php echo esc_html($plumber_handyman_lite_label); ?>
                                    <time class="time"> <?php echo esc_html($plumber_handyman_lite_time); ?></time>
                                </p>
                            </span>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 col-12 py-5 count-timer wow zoomIn" data-wow-duration="2s">
                    <div class="counters-sec">
                        <?php if (get_theme_mod('plumber_handyman_lite_total_no_satisfied_customer') != '') { ?>
                            <div class="customer-counter row">
                                <div class="col-xl-4 col-lg-3 col-md-3"></div>
                                <div class="col-xl-8 col-lg-9 col-md-9">
                                    <div class="customer-info">
                                        <div class="customer-no"><?php echo esc_html(get_theme_mod('plumber_handyman_lite_total_no_satisfied_customer')); ?><?php esc_html_e('%', 'plumber-handyman-lite'); ?></div>
                                        <div class=""><?php esc_html_e('Satisfied Customers', 'plumber-handyman-lite'); ?></div>
                                    </div>
                                </div>
                            </div>
                        <?php } ?>
                        <?php if (get_theme_mod('plumber_handyman_lite_total_no_award_win') != '') { ?>
                            <div class="customer-counter row">
                                <div class="col-xl-4 col-lg-3 col-md-3"></div>
                                <div class="col-xl-8 col-lg-9 col-md-9">
                                    <div class="customer-info">
                                        <div class="customer-no"><?php echo esc_html(get_theme_mod('plumber_handyman_lite_total_no_award_win')); ?><?php esc_html_e('+', 'plumber-handyman-lite'); ?></div>
                                        <div class=""><?php esc_html_e('Technicians & Workers', 'plumber-handyman-lite'); ?></div>
                                    </div>
                                </div>
                            </div>
                        <?php } ?>
                        <?php if (get_theme_mod('plumber_handyman_lite_total_no_successfull_projects') != '') { ?>
                            <div class="customer-counter row">
                                <div class="col-xl-4 col-lg-3 col-md-3"></div>
                                <div class="col-xl-8 col-lg-9 col-md-9">
                                    <div class="customer-info">
                                        <div class="customer-no"><?php echo esc_html(get_theme_mod('plumber_handyman_lite_total_no_successfull_projects')); ?><?php esc_html_e('k', 'plumber-handyman-lite'); ?></div>
                                        <div class=""><?php esc_html_e('Repaired', 'plumber-handyman-lite'); ?></div>
                                    </div>
                                </div>
                            </div>
                        <?php } ?>
                        <?php if (get_theme_mod('plumber_handyman_lite_total_year_experience') != '') { ?>
                            <div class="customer-counter row">
                                <div class="col-xl-4 col-lg-3 col-md-3"></div>
                                <div class="col-xl-8 col-lg-9 col-md-9">
                                    <div class="customer-info">
                                        <div class="customer-no"><?php echo esc_html(get_theme_mod('plumber_handyman_lite_total_year_experience')); ?><?php esc_html_e('+', 'plumber-handyman-lite'); ?></div>
                                        <div class=""><?php esc_html_e('Years of experience', 'plumber-handyman-lite'); ?></div>
                                    </div>
                                </div>
                            </div>
                        <?php } ?>
                    </div>
                
                </div>
                <div class="col-lg-4 col-md-9 col-12 wow zoomInUp" data-wow-duration="2s">
                    <div class="plumber-img">
                        <?php if ( get_theme_mod('plumber_handyman_lite_counter_image') ) : ?>
                            <img src="<?php echo esc_url(get_theme_mod('plumber_handyman_lite_counter_image'));?>" alt="<?php esc_attr_e('Image', 'plumber-handyman-lite'); ?>">
                        <?php else: ?>
                            <div>
                                <img src="<?php echo get_stylesheet_directory_uri() . '/images/plumber.png'; ?>" alt="<?php esc_attr_e('Image', 'plumber-handyman-lite'); ?>">
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <?php wp_reset_postdata(); ?>
        </div>
    </div>
<?php } ?>