<?php
/**
 * Banner Section
 * 
 * @package plumber_handyman_lite
 */
$plumber_handyman_lite_slider = get_theme_mod('plumber_handyman_lite_slider_setting', false);
$plumber_handyman_lite_args = array(
    'post_type' => 'post',
    'post_status' => 'publish',
    'category_name' => get_theme_mod('plumber_handyman_lite_blog_slide_category'),
    'posts_per_page' => 3,
);
?>

<?php if ($plumber_handyman_lite_slider): ?>
    <div class="banner">
        <div class="owl-carousel">
            <?php
            $plumber_handyman_lite_arr_posts = new WP_Query($plumber_handyman_lite_args);
            if ($plumber_handyman_lite_arr_posts->have_posts()) :
                while ($plumber_handyman_lite_arr_posts->have_posts()) :
                    $plumber_handyman_lite_arr_posts->the_post();
                    ?>
                    <div class="banner_inner_box">
                        <?php if (has_post_thumbnail()): ?>
                            <?php the_post_thumbnail(); ?>
                        <?php else: ?>
                            <div class="banner_inner_box">
                                <img src="<?php echo get_stylesheet_directory_uri() . '/images/default.png'; ?>" alt="<?php esc_attr_e('Image', 'plumber-handyman-lite'); ?>">
                            </div>
                        <?php endif; ?>
                        <div class="banner_box wow zoomIn" data-wow-duration="2s">
                            <h3 class="my-3"><?php the_title(); ?></h3>
                            <p class="mb-0"><?php echo wp_trim_words(get_the_content(), 30); ?></p>
                            <p class="btn-green mt-4">
                                <a href="<?php echo esc_url(get_permalink($post->ID)); ?>"><?php esc_html_e('Read More', 'plumber-handyman-lite'); ?></a>
                            </p>
                        </div>
                    </div>
                <?php endwhile; ?>
                <?php wp_reset_postdata(); ?>
            <?php endif; ?>
        </div>

        <?php
        $plumber_handyman_lite_social_icon = get_theme_mod('plumber_handyman_lite_social_icon_setting', false);
        if ($plumber_handyman_lite_social_icon):
        ?>
            <div class="social-links">
                <?php
                $plumber_handyman_lite_social_link1 = get_theme_mod('plumber_handyman_lite_social_link_1');
                $plumber_handyman_lite_social_link2 = get_theme_mod('plumber_handyman_lite_social_link_2');
                $plumber_handyman_lite_social_link3 = get_theme_mod('plumber_handyman_lite_social_link_3');
                $plumber_handyman_lite_social_link4 = get_theme_mod('plumber_handyman_lite_social_link_4');

                if (!empty($plumber_handyman_lite_social_link1)) {
                    echo '<a class="social1 wow zoomIn" data-wow-duration="2s"" href="' . esc_url($plumber_handyman_lite_social_link1) . '" target="_blank"><i class="fab fa-facebook-f"></i></a>';
                }
                if (!empty($plumber_handyman_lite_social_link2)) {
                    echo '<a class="social2 wow zoomIn" data-wow-duration="2s"" href="' . esc_url($plumber_handyman_lite_social_link2) . '" target="_blank"><i class="fab fa-twitter"></i></a>';
                }
                if (!empty($plumber_handyman_lite_social_link3)) {
                    echo '<a class="social3 wow zoomIn" data-wow-duration="2s"" href="' . esc_url($plumber_handyman_lite_social_link3) . '" target="_blank"><i class="fab fa-instagram"></i></a>';
                }
                if (!empty($plumber_handyman_lite_social_link4)) {
                    echo '<a class="social4 wow zoomIn" data-wow-duration="2s"" href="' . esc_url($plumber_handyman_lite_social_link4) . '" target="_blank"><i class="fab fa-youtube"></i></a>';
                }
                ?>
            </div>
        <?php endif; ?>

        <div class="banner-video-image wow zoomInUp" data-wow-duration="2s">
            <?php 
            $plumber_handyman_lite_featured_mission_posts = array(get_theme_mod('plumber_handyman_lite_featured_mission_post_'));
            $plumber_handyman_lite_args = array(
                'post_type' => 'page',
                'posts_per_page' => 1,
                'post__in' => $plumber_handyman_lite_featured_mission_posts,
                'orderby' => 'post__in',
                'ignore_sticky_posts' => true,
            );
            $plumber_handyman_lite_loop = new WP_Query($plumber_handyman_lite_args);
            if ($plumber_handyman_lite_loop->have_posts()):
                while ($plumber_handyman_lite_loop->have_posts()): $plumber_handyman_lite_loop->the_post();
                    ?>
                    <div class="featured-mission-box">
                        <?php if (has_post_thumbnail()): ?>
                            <?php the_post_thumbnail(); ?>
                        <?php else: ?>
                            <div class="image-container">
                                <img src="<?php echo get_stylesheet_directory_uri() . '/images/default.png'; ?>" alt="<?php esc_attr_e('Image', 'plumber-handyman-lite'); ?>">
                            </div>
                            <div class="page-btn">
                                <a href="<?php the_permalink(); ?>">
                                <h5><i class="fas fa-link"></i><?php the_title(); ?></h5>
                                </a>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php endwhile; ?>
            <?php endif; ?>
            <?php wp_reset_postdata(); ?>
        </div>
    </div>
<?php endif; ?>
