jQuery(document).ready(function ($) {
	var plumber_handyman_lite_owl = jQuery('.banner .owl-carousel');
		plumber_handyman_lite_owl.owlCarousel({
			margin:20,
			nav: true,
			autoplay : true,
			lazyLoad: true,
			autoplayTimeout: 3000,
			loop: false,
			dots:false,
			navText : ['<i class="fas fa-arrow-left"></i>','<i class="fas fa-arrow-right"></i> '],
			responsive: {
			0: {
				items: 1
			},
			600: {
				items: 1
			},
			1000: {
				items: 1
			}
		},
		autoplayHoverPause : true,
		mouseDrag: true
	});

  if ( typeof $.fn.owlCarousel !== 'function' ) {
      console.warn('Owl Carousel not found.');
      return;
  }

  	//header-search
	jQuery('.search-show').click(function(){
		jQuery('.searchform-inner').css('visibility','visible');
	});

	jQuery('.close').click(function(){
		jQuery('.searchform-inner').css('visibility','hidden');
	});

	$('.mobile-nav .toggle-button').on( 'click', function() {
		$('.mobile-nav .main-navigation').slideToggle();
	});

	$('.mobile-nav-wrap .close ').on( 'click', function() {
		$('.mobile-nav .main-navigation').slideToggle();

	});

	$('<button class="submenu-toggle"></button>').insertAfter($('.mobile-nav ul .menu-item-has-children > a'));
	$('.mobile-nav ul li .submenu-toggle').on( 'click', function() {
		$(this).next().slideToggle();
		$(this).toggleClass('open');
	});

	//accessible menu for edge
	 $("#site-navigation ul li a").on( 'focus', function() {
	   $(this).parents("li").addClass("focus");
	}).on( 'blur', function() {
	    $(this).parents("li").removeClass("focus");
	 });
});

var plumber_handyman_lite_btn = jQuery('#button');

jQuery(window).scroll(function() {
  if (jQuery(window).scrollTop() > 300) {
    plumber_handyman_lite_btn.addClass('show');
  } else {
    plumber_handyman_lite_btn.removeClass('show');
  }
});
plumber_handyman_lite_btn.on('click', function(e) {
  e.preventDefault();
  jQuery('html, body').animate({scrollTop:0}, '300');
});

window.addEventListener('load', (event) => {
    jQuery(".preloader").delay(1000).fadeOut("slow");
});

jQuery(window).scroll(function() {
    var plumber_handyman_lite_data_sticky = jQuery(' .head_bg').attr('data-sticky');

    if (plumber_handyman_lite_data_sticky == 1) {
      if (jQuery(this).scrollTop() > 1){  
        jQuery('.head_bg').addClass("sticky-head");
      } else {
        jQuery('.head_bg').removeClass("sticky-head");
      }
    }
});

function plumber_handyman_lite_preloderFunction() {
    setTimeout(function() {           
        document.getElementById("page-top").scrollIntoView();
        
        $('#ctn-preloader').addClass('loaded');  
        // Once the preloader has finished, the scroll appears 
        $('body').removeClass('no-scroll-y');

        if ($('#ctn-preloader').hasClass('loaded')) {
            // It is so that once the preloader is gone, the entire preloader section will removed
            $('#preloader').delay(1000).queue(function() {
                $(this).remove();
                
                // If you want to do something after removing preloader:
                plumber_handyman_lite_afterLoad();
                
            });
        }
    }, 3000);
}
function plumber_handyman_lite_afterLoad() {
    // After Load function body!
}

document.addEventListener('DOMContentLoaded', function () {
    const plumber_handyman_lite_counters = document.querySelectorAll('.customer-no');

    plumber_handyman_lite_counters.forEach(function (plumber_handyman_lite_counter) {

        // Extract number + symbol separately
        const plumber_handyman_lite_original = plumber_handyman_lite_counter.textContent.trim();
        const plumber_handyman_lite_number = parseInt(plumber_handyman_lite_original.replace(/\D/g, ''), 10);
        const plumber_handyman_lite_symbol = plumber_handyman_lite_original.replace(/[0-9]/g, '');

        let plumber_handyman_lite_count = 0;
        const plumber_handyman_lite_duration = 2000;
        const plumber_handyman_lite_startTime = performance.now();

        function plumber_handyman_lite_updateCounter(plumber_handyman_lite_currentTime) {

            const plumber_handyman_lite_elapsedTime =
                plumber_handyman_lite_currentTime - plumber_handyman_lite_startTime;

            const plumber_handyman_lite_progress =
                Math.min(plumber_handyman_lite_elapsedTime / plumber_handyman_lite_duration, 1);

            plumber_handyman_lite_count =
                Math.floor(plumber_handyman_lite_progress * plumber_handyman_lite_number);

            // Attach symbol while animating
            plumber_handyman_lite_counter.textContent =
                plumber_handyman_lite_count + plumber_handyman_lite_symbol;

            if (plumber_handyman_lite_progress < 1) {
                requestAnimationFrame(plumber_handyman_lite_updateCounter);
            }
        }

        requestAnimationFrame(plumber_handyman_lite_updateCounter);
    });
});
