<?php
/**
 * Widget Social Links
 *
 * @package plumber_handyman_lite
 */

// register Plumber_Handyman_Lite_Social_Links widget 
function plumber_handyman_lite_register_social_links_widget() {
    register_widget( 'Plumber_Handyman_Lite_Social_Links' );
}
add_action( 'widgets_init', 'plumber_handyman_lite_register_social_links_widget' );

if( ! class_exists( 'Plumber_Handyman_Lite_Social_Links' ) ): 
 /**
 * Adds Plumber_Handyman_Lite_Social_Links widget.
 */
class Plumber_Handyman_Lite_Social_Links extends WP_Widget {

	/**
	 * Register widget with WordPress.
	 */
	function __construct() {
		parent::__construct(
			'plumber_handyman_lite_social_links', // Base ID
			esc_html__( 'TI: Social Links', 'plumber-handyman-lite' ), // Name
			array( 'description' => esc_html__( 'A Social Links Widget', 'plumber-handyman-lite' ), ) // Args
		);
	}

	/**
	 * Front-end display of widget.
	 *
	 * @see WP_Widget::widget()
	 *
	 * @param array $args     Widget arguments.
	 * @param array $instance Saved values from database.
	 */
	public function widget( $args, $instance ) {
	   
        $plumber_handyman_lite_title      = ! empty( $instance['title'] ) ? $instance['title'] : '';		
        $plumber_handyman_lite_facebook   = ! empty( $instance['facebook'] ) ? $instance['facebook'] : '' ;
        $plumber_handyman_lite_instagram  = ! empty( $instance['instagram'] ) ? $instance['instagram'] : '' ;
        $plumber_handyman_lite_twitter    = ! empty( $instance['twitter'] ) ? $instance['twitter'] : '' ;
        $plumber_handyman_lite_pinterest  = ! empty( $instance['pinterest'] ) ? $instance['pinterest'] : '' ;
        $plumber_handyman_lite_linkedin   = ! empty( $instance['linkedin'] ) ? $instance['linkedin'] : '' ;
        $plumber_handyman_lite_youtube    = ! empty( $instance['youtube'] ) ? $instance['youtube'] : '' ;
        $plumber_handyman_lite_tiktok    = ! empty( $instance['tiktok'] ) ? $instance['tiktok'] : '' ;
        
        if( $plumber_handyman_lite_facebook || $plumber_handyman_lite_instagram || $plumber_handyman_lite_twitter || $plumber_handyman_lite_pinterest || $plumber_handyman_lite_linkedin || $plumber_handyman_lite_youtube || $plumber_handyman_lite_tiktok ){ 
        echo $args['before_widget'];
        if($plumber_handyman_lite_title)
        echo $args['before_title'] . apply_filters( 'widget_title', $plumber_handyman_lite_title, $instance, $this->id_base ) . $args['after_title'];
        ?>
            <ul class="social-networks">
				<?php if( $plumber_handyman_lite_facebook ){ ?>
                <li><a href="<?php echo esc_url( $plumber_handyman_lite_facebook ); ?>" title="<?php esc_attr_e( 'Facebook', 'plumber-handyman-lite' ); ?>" ><i class="fa fa-facebook"></i></a></li>
				<?php } if( $plumber_handyman_lite_instagram ){ ?>
                <li><a href="<?php echo esc_url( $plumber_handyman_lite_instagram ); ?>" title="<?php esc_attr_e( 'Instagram', 'plumber-handyman-lite' ); ?>"><i class="fa fa-instagram"></i></a></li>
                <?php } if( $plumber_handyman_lite_twitter ){ ?>
                <li><a href="<?php echo esc_url( $plumber_handyman_lite_twitter ); ?>" title="<?php esc_attr_e( 'Twitter', 'plumber-handyman-lite' ); ?>"><i class="fa fa-twitter"></i></a></li>
				<?php } if( $plumber_handyman_lite_pinterest ){ ?>
                <li><a href="<?php echo esc_url( $plumber_handyman_lite_pinterest ); ?>"  title="<?php esc_attr_e( 'Pinterest', 'plumber-handyman-lite' ); ?>"><i class="fa fa-pinterest-p"></i></a></li>
				<?php } if( $plumber_handyman_lite_linkedin ){ ?>
                <li><a href="<?php echo esc_url( $plumber_handyman_lite_linkedin ); ?>" title="<?php esc_attr_e( 'Linkedin', 'plumber-handyman-lite' ); ?>"><i class="fa fa-linkedin"></i></a></li>
				<?php } if( $plumber_handyman_lite_youtube ){ ?>
                <li><a href="<?php echo esc_url( $plumber_handyman_lite_youtube ); ?>" title="<?php esc_attr_e( 'YouTube', 'plumber-handyman-lite' ); ?>"><i class="fa fa-youtube"></i></a></li>
                <?php } if( $plumber_handyman_lite_tiktok ){ ?>
                <li><a href="<?php echo esc_url( $plumber_handyman_lite_tiktok ); ?>" title="<?php esc_attr_e( 'Tiktok', 'plumber-handyman-lite' ); ?>"><i class="fab fa-tiktok"></i></a></li>
                <?php } ?>
			</ul>
        <?php
        echo $args['after_widget'];
        }
	}

	/**
	 * Back-end widget form.
	 *
	 * @see WP_Widget::form()
	 *
	 * @param array $instance Previously saved values from database.
	 */
	public function form( $instance ) {
        
        $plumber_handyman_lite_title      = ! empty( $instance['title'] ) ? $instance['title'] : '';		
        $plumber_handyman_lite_facebook   = ! empty( $instance['facebook'] ) ? $instance['facebook'] : '' ;
        $plumber_handyman_lite_instagram  = ! empty( $instance['instagram'] ) ? $instance['instagram'] : '' ;
        $plumber_handyman_lite_twitter    = ! empty( $instance['twitter'] ) ? $instance['twitter'] : '' ;
        $plumber_handyman_lite_pinterest  = ! empty( $instance['pinterest'] ) ? $instance['pinterest'] : '' ;
        $plumber_handyman_lite_linkedin   = ! empty( $instance['linkedin'] ) ? $instance['linkedin'] : '' ;
        $plumber_handyman_lite_youtube    = ! empty( $instance['youtube'] ) ? $instance['youtube'] : '' ;
        $plumber_handyman_lite_tiktok    = ! empty( $instance['tiktok'] ) ? $instance['tiktok'] : '' ;
        
        ?>
		
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title', 'plumber-handyman-lite' ); ?></label> 
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $plumber_handyman_lite_title ); ?>" />
		</p>
        
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'facebook' ) ); ?>"><?php esc_html_e( 'Facebook', 'plumber-handyman-lite' ); ?></label> 
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'facebook' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'facebook' ) ); ?>" type="text" value="<?php echo esc_attr( $plumber_handyman_lite_facebook ); ?>" />
		</p>
        
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'instagram' ) ); ?>"><?php esc_html_e( 'Instagram', 'plumber-handyman-lite' ); ?></label> 
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'instagram' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'instagram' ) ); ?>" type="text" value="<?php echo esc_attr( $plumber_handyman_lite_instagram ); ?>" />
		</p>
                
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'twitter' ) ); ?>"><?php esc_html_e( 'Twitter', 'plumber-handyman-lite' ); ?></label> 
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'twitter' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'twitter' ) ); ?>" type="text" value="<?php echo esc_attr( $plumber_handyman_lite_twitter ); ?>" />
		</p>
        
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'pinterest' ) ); ?>"><?php esc_html_e( 'Pinterest', 'plumber-handyman-lite' ); ?></label> 
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'pinterest' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'pinterest' ) ); ?>" type="text" value="<?php echo esc_attr( $plumber_handyman_lite_pinterest ); ?>" />
		</p>
        
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'linkedin' ) ); ?>"><?php esc_html_e( 'LinkedIn', 'plumber-handyman-lite' ); ?></label> 
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'linkedin' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'linkedin' ) ); ?>" type="text" value="<?php echo esc_attr( $plumber_handyman_lite_linkedin ); ?>" />
		</p>
        
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'youtube' ) ); ?>"><?php esc_html_e( 'YouTube', 'plumber-handyman-lite' ); ?></label> 
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'youtube' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'youtube' ) ); ?>" type="text" value="<?php echo esc_attr( $plumber_handyman_lite_youtube ); ?>" />
		</p>

        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'tiktok' ) ); ?>"><?php esc_html_e( 'Tiktok', 'plumber-handyman-lite' ); ?></label> 
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'tiktok' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'tiktok' ) ); ?>" type="text" value="<?php echo esc_attr( $plumber_handyman_lite_tiktok ); ?>" />
		</p>
		<?php 
	}

	/**
	 * Sanitize widget form values as they are saved.
	 *
	 * @see WP_Widget::update()
	 *
	 * @param array $new_instance Values just sent to be saved.
	 * @param array $old_instance Previously saved values from database.
	 *
	 * @return array Updated safe values to be saved.
	 */
	public function update( $new_instance, $old_instance ) {
		
        $instance = array();
		
        $instance['title']     = ! empty( $new_instance['title'] ) ? sanitize_text_field( $new_instance['title'] ) :'';
        $instance['facebook']  = ! empty( $new_instance['facebook'] ) ? esc_url_raw( $new_instance['facebook'] ) : '';
        $instance['instagram'] = ! empty( $new_instance['instagram'] ) ? esc_url_raw( $new_instance['instagram'] ) : '';
        $instance['twitter']   = ! empty( $new_instance['twitter'] ) ? esc_url_raw( $new_instance['twitter'] ) : '';
        $instance['pinterest'] = ! empty( $new_instance['pinterest'] ) ? esc_url_raw( $new_instance['pinterest'] ) : '';
        $instance['linkedin']  = ! empty( $new_instance['linkedin'] ) ? esc_url_raw( $new_instance['linkedin'] ) : '';
        $instance['youtube']   = ! empty( $new_instance['youtube'] ) ? esc_url_raw( $new_instance['youtube'] ) : '';
        $instance['tiktok']    = ! empty( $new_instance['tiktok'] ) ? esc_url_raw( $new_instance['tiktok'] ) : '';
		
        return $instance;
                
	}

} // class Plumber_Handyman_Lite_Social_Links 
endif;