<?php
/**
 * Help Panel.
 *
 * @package Plumber_Handyman_Lite
 */
?>

<div id="help-panel" class="panel-left visible">

    <div class="panel-aside active">
        <h4><?php printf( esc_html__( ' DEMO CONTENT IMPORTER', 'plumber-handyman-lite' )); ?></h4>
        <p><?php esc_html_e( 'Your journey to a powerful and stylish website begins here. Let’s get everything set up in just a few clicks!', 'plumber-handyman-lite' ); ?></p>
        <a class="button button-primary" href="<?php echo esc_url(admin_url('themes.php?page=plumberhandymanlite-wizard')); ?>" title="<?php esc_attr_e( 'Demo Importer', 'plumber-handyman-lite' ); ?>" target="_blank">
            <?php esc_html_e( 'DEMO IMPORTER', 'plumber-handyman-lite' ); ?>
        </a>
    </div>

    <div class="panel-aside">
        <h4><?php printf( esc_html__( ' VISIT FREE DOCUMENTATION', 'plumber-handyman-lite' )); ?></h4>
        <p><?php esc_html_e( 'Are you a newcomer to the WordPress universe? Our comprehensive and user-friendly documentation guide is designed to assist you in effortlessly building a captivating and interactive website, even if you lack any coding expertise or prior experience. Follow our step-by-step instructions to create a visually appealing and engaging online presence.', 'plumber-handyman-lite' ); ?></p>
        <a class="button button-primary" href="<?php echo esc_url( PLUMBER_HANDYMAN_LITE_FREE_DOC_URL ); ?>" title="<?php esc_attr_e( 'Visit the Documentation', 'plumber-handyman-lite' ); ?>" target="_blank">
            <?php esc_html_e( 'FREE DOCUMENTATION', 'plumber-handyman-lite' ); ?>
        </a>
    </div>

    <div class="panel-aside">
        <h4><?php esc_html_e( 'REVIEW', 'plumber-handyman-lite' ); ?></h4>
        <p><?php esc_html_e( 'If you are passionate about the Plumber Handyman Lite theme, we would love to hear your thoughts and feedback regarding our theme. Your review will be highly valuable to us as we strive to enhance and improve our theme based on the needs and preferences of our users. Your opinion matters, and we sincerely appreciate your time and effort in sharing your experience with the Plumber Handyman Lite theme.', 'plumber-handyman-lite' ); ?></p>
        <a class="button button-primary" href="<?php echo esc_url( PLUMBER_HANDYMAN_LITE_REVIEW_URL ); ?>" title="<?php esc_attr_e( 'Visit the Review', 'plumber-handyman-lite' ); ?>" target="_blank">
            <?php esc_html_e( 'REVIEW', 'plumber-handyman-lite' ); ?>
        </a>
    </div>
    
    <div class="panel-aside">
        <h4><?php esc_html_e( 'CONTACT SUPPORT', 'plumber-handyman-lite' ); ?></h4>
        <p>
            <?php esc_html_e( 'Thank you for choosing Plumber Handyman Lite! We appreciate your interest in our theme and are here to assist you with any support you may need.', 'plumber-handyman-lite' ); ?></p>
        <a class="button button-primary" href="<?php echo esc_url( PLUMBER_HANDYMAN_LITE_SUPPORT_URL ); ?>" title="<?php esc_attr_e( 'Visit the Support', 'plumber-handyman-lite' ); ?>" target="_blank">
            <?php esc_html_e( 'CONTACT SUPPORT', 'plumber-handyman-lite' ); ?>
        </a>
    </div>
</div>