<?php
/**
 * Custom functions that act independently of the theme templates.
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package plumber_handyman_lite
 */

/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 * @return array
 */
function plumber_handyman_lite_body_classes( $classes ) {
  global $plumber_handyman_lite_post;
  
    if( !is_page_template( 'template-home.php' ) ){
        $classes[] = 'inner';
        // Adds a class of group-blog to blogs with more than 1 published author.
    }

    if ( is_multi_author() ) {
        $classes[] = 'group-blog ';
    }

    // Adds a class of custom-background-image to sites with a custom background image.
    if ( get_background_image() ) {
        $classes[] = 'custom-background-image';
    }
    
    // Adds a class of custom-background-color to sites with a custom background color.
    if ( get_background_color() != 'ffffff' ) {
        $classes[] = 'custom-background-color';
    }
    

    if( plumber_handyman_lite_woocommerce_activated() && ( is_shop() || is_product_category() || is_product_tag() || 'product' === get_post_type() ) && ! is_active_sidebar( 'shop-sidebar' ) ){
        $classes[] = 'full-width';
    }    

    // Adds a class of hfeed to non-singular pages.
    if ( ! is_page() ) {
        $classes[] = 'hfeed ';
    }
  
    if( is_404() ||  is_search() ){
        $classes[] = 'full-width';
    }
  
    if( ! is_active_sidebar( 'right-sidebar' ) ) {
        $classes[] = 'full-width'; 
    }

    return $classes;
}
add_filter( 'body_class', 'plumber_handyman_lite_body_classes' );

 /**
 * 
 * @link http://www.altafweb.com/2011/12/remove-specific-tag-from-php-string.html
 */
function plumber_handyman_lite_strip_single( $tag, $string ){
    $string=preg_replace('/<'.$tag.'[^>]*>/i', '', $string);
    $string=preg_replace('/<\/'.$tag.'>/i', '', $string);
    return $string;
}

if ( ! function_exists( 'plumber_handyman_lite_excerpt_more' ) ) :
/**
 * Replaces "[...]" (appended to automatically generated excerpts) with ... * 
 */
function plumber_handyman_lite_excerpt_more($more) {
  return is_admin() ? $more : ' &hellip; ';
}
endif;
add_filter( 'excerpt_more', 'plumber_handyman_lite_excerpt_more' );

if( ! function_exists( 'plumber_handyman_lite_footer_credit' ) ):
/**
 * Footer Credits
*/
function plumber_handyman_lite_footer_credit() {

    // Check if footer copyright is enabled
    $plumber_handyman_lite_show_footer_copyright = get_theme_mod( 'plumber_handyman_lite_footer_setting', true );

    if ( ! $plumber_handyman_lite_show_footer_copyright ) {
        return; 
    }

    $plumber_handyman_lite_copyright_text = get_theme_mod('plumber_handyman_lite_footer_copyright_text');

    $plumber_handyman_lite_text = '<div class="site-info"><div class="container"><span class="copyright">';
    if ($plumber_handyman_lite_copyright_text) {
        $plumber_handyman_lite_text .= wp_kses_post($plumber_handyman_lite_copyright_text); 
    } else {
        $plumber_handyman_lite_text .= esc_html__('&copy; ', 'plumber-handyman-lite') . date_i18n(esc_html__('Y', 'plumber-handyman-lite')); 
        $plumber_handyman_lite_text .= ' <a href="' . esc_url(home_url('/')) . '">' . esc_html(get_bloginfo('name')) . '</a>' . esc_html__('. All Rights Reserved.', 'plumber-handyman-lite');
    }
    $plumber_handyman_lite_text .= '</span>';
    $plumber_handyman_lite_text .= '<span class="by"> <a href="' . esc_url('https://www.themeignite.com/products/plumber-handyman-lite') . '" rel="nofollow" target="_blank">' . PLUMBER_HANDYMAN_LITE_THEME_NAME . '</a>' . esc_html__(' By ', 'plumber-handyman-lite') . '<a href="' . esc_url('https://themeignite.com/') . '" rel="nofollow" target="_blank">' . esc_html__('Themeignite', 'plumber-handyman-lite') . '</a>.';
    $plumber_handyman_lite_text .= sprintf(esc_html__(' Powered By %s', 'plumber-handyman-lite'), '<a href="' . esc_url(__('https://wordpress.org/', 'plumber-handyman-lite')) . '" target="_blank">WordPress</a>.');
    if (function_exists('the_privacy_policy_link')) {
        $plumber_handyman_lite_text .= get_the_privacy_policy_link();
    }
    $plumber_handyman_lite_text .= '</span></div></div>';
    echo apply_filters('plumber_handyman_lite_footer_text', $plumber_handyman_lite_text);
}
add_action('plumber_handyman_lite_footer', 'plumber_handyman_lite_footer_credit');
endif;

/**
 * Is Woocommerce activated
*/
if ( ! function_exists( 'plumber_handyman_lite_woocommerce_activated' ) ) {
  function plumber_handyman_lite_woocommerce_activated() {
    if ( class_exists( 'woocommerce' ) ) { return true; } else { return false; }
  }
}

if( ! function_exists( 'plumber_handyman_lite_change_comment_form_default_fields' ) ) :
/**
 * Change Comment form default fields i.e. author, email & url.
 * https://blog.josemcastaneda.com/2016/08/08/copy-paste-hurting-theme/
*/
function plumber_handyman_lite_change_comment_form_default_fields( $fields ){    
    // get the current commenter if available
    $plumber_handyman_lite_commenter = wp_get_current_commenter();
 
    // core functionality
    $req      = get_option( 'require_name_email' );
    $plumber_handyman_lite_aria_req = ( $req ? " aria-required='true'" : '' );
    $plumber_handyman_lite_required = ( $req ? " required" : '' );
    $plumber_handyman_lite_author   = ( $req ? __( 'Name*', 'plumber-handyman-lite' ) : __( 'Name', 'plumber-handyman-lite' ) );
    $plumber_handyman_lite_email    = ( $req ? __( 'Email*', 'plumber-handyman-lite' ) : __( 'Email', 'plumber-handyman-lite' ) );
 
    // Change just the author field
    $fields['author'] = '<p class="comment-form-author"><label class="screen-reader-text" for="author">' . esc_html__( 'Name', 'plumber-handyman-lite' ) . '<span class="required">*</span></label><input id="author" name="author" placeholder="' . esc_attr( $plumber_handyman_lite_author ) . '" type="text" value="' . esc_attr( $plumber_handyman_lite_commenter['comment_author'] ) . '" size="30"' . $plumber_handyman_lite_aria_req . $plumber_handyman_lite_required . ' /></p>';
    
    $fields['email'] = '<p class="comment-form-email"><label class="screen-reader-text" for="email">' . esc_html__( 'Email', 'plumber-handyman-lite' ) . '<span class="required">*</span></label><input id="email" name="email" placeholder="' . esc_attr( $plumber_handyman_lite_email ) . '" type="text" value="' . esc_attr(  $plumber_handyman_lite_commenter['comment_author_email'] ) . '" size="30"' . $plumber_handyman_lite_aria_req . $plumber_handyman_lite_required. ' /></p>';
    
    $fields['url'] = '<p class="comment-form-url"><label class="screen-reader-text" for="url">' . esc_html__( 'Website', 'plumber-handyman-lite' ) . '</label><input id="url" name="url" placeholder="' . esc_attr__( 'Website', 'plumber-handyman-lite' ) . '" type="text" value="' . esc_attr( $plumber_handyman_lite_commenter['comment_author_url'] ) . '" size="30" /></p>'; 
    
    return $fields;    
}
endif;
add_filter( 'comment_form_default_fields', 'plumber_handyman_lite_change_comment_form_default_fields' );

if( ! function_exists( 'plumber_handyman_lite_change_comment_form_defaults' ) ) :
/**
 * Change Comment Form defaults
 * https://blog.josemcastaneda.com/2016/08/08/copy-paste-hurting-theme/
*/
function plumber_handyman_lite_change_comment_form_defaults( $defaults ){    
    $defaults['comment_field'] = '<p class="comment-form-comment"><label class="screen-reader-text" for="comment">' . esc_html__( 'Comment', 'plumber-handyman-lite' ) . '</label><textarea id="comment" name="comment" placeholder="' . esc_attr__( 'Comment', 'plumber-handyman-lite' ) . '" cols="45" rows="8" aria-required="true" required></textarea></p>';
    
    return $defaults;    
}
endif;
add_filter( 'comment_form_defaults', 'plumber_handyman_lite_change_comment_form_defaults' );

if( ! function_exists( 'plumber_handyman_lite_escape_text_tags' ) ) :
/**
 * Remove new line tags from string
 *
 * @param $text
 * @return string
 */
function plumber_handyman_lite_escape_text_tags( $text ) {
    return (string) str_replace( array( "\r", "\n" ), '', strip_tags( $text ) );
}
endif;

if( ! function_exists( 'wp_body_open' ) ) :
/**
 * Fire the wp_body_open action.
 * Added for backwards compatibility to support pre 5.2.0 WordPress versions.
*/
function wp_body_open() {
    /**
     * Triggered after the opening <body> tag.
    */
    do_action( 'wp_body_open' );
}
endif;

if ( ! function_exists( 'plumber_handyman_lite_get_fallback_svg' ) ) :    
/**
 * Get Fallback SVG
*/
function plumber_handyman_lite_get_fallback_svg( $plumber_handyman_lite_post_thumbnail ) {
    if( ! $plumber_handyman_lite_post_thumbnail ){
        return;
    }
    
    $plumber_handyman_lite_image_size = plumber_handyman_lite_get_image_sizes( $plumber_handyman_lite_post_thumbnail );
     
    if( $plumber_handyman_lite_image_size ){ ?>
        <div class="svg-holder">
             <svg class="fallback-svg" viewBox="0 0 <?php echo esc_attr( $plumber_handyman_lite_image_size['width'] ); ?> <?php echo esc_attr( $plumber_handyman_lite_image_size['height'] ); ?>" preserveAspectRatio="none">
                    <rect width="<?php echo esc_attr( $plumber_handyman_lite_image_size['width'] ); ?>" height="<?php echo esc_attr( $plumber_handyman_lite_image_size['height'] ); ?>" style="fill:#dedddd;"></rect>
            </svg>
        </div>
        <?php
    }
}
endif;

function plumber_handyman_lite_enqueue_google_fonts() {

    require get_template_directory() . '/inc/wptt-webfont-loader.php';

    wp_enqueue_style(
        'google-fonts-inter',
        plumber_handyman_lite_wptt_get_webfont_url( 'https://fonts.googleapis.com/css2?family=Inter:ital,opsz,wght@0,14..32,100..900;1,14..32,100..900&display=swap' ),
        array(),
        '1.0'
    );

    wp_enqueue_style(
        'google-fonts-poppins',
        plumber_handyman_lite_wptt_get_webfont_url( 'https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap' ),
        array(),
        '1.0'
    );
}
add_action( 'wp_enqueue_scripts', 'plumber_handyman_lite_enqueue_google_fonts' );


if( ! function_exists( 'plumber_handyman_lite_site_branding' ) ) :
/**
 * Site Branding
*/
function plumber_handyman_lite_site_branding(){
    $plumber_handyman_lite_logo_site_title = get_theme_mod( 'header_site_title', 1 );
    $plumber_handyman_lite_tagline = get_theme_mod( 'header_tagline', false );

    ?>
    <div class="site-branding">
        <?php 
        // Check if custom logo is set and display it
        if (function_exists('has_custom_logo') && has_custom_logo()) {
            the_custom_logo();
        }
        if ($plumber_handyman_lite_logo_site_title):
             if (is_front_page()): ?>
            <h1 class="site-title" style="font-size: <?php echo esc_attr(get_theme_mod('plumber_handyman_lite_site_title_size', '20')); ?>px;">
            <a href="<?php echo esc_url(home_url('/')); ?>" rel="home"><?php bloginfo('name'); ?></a>
          </h1>
            <?php else: ?>
                <p class="site-title" itemprop="name">
                    <a href="<?php echo esc_url(home_url('/')); ?>" rel="home"><?php bloginfo('name'); ?></a>
                </p>
            <?php endif; ?>
        <?php endif; 
    
        if ($plumber_handyman_lite_tagline) :
            $plumber_handyman_lite_description = get_bloginfo('description', 'display');
            if ($plumber_handyman_lite_description || is_customize_preview()) :
        ?>
                <p class="site-description" itemprop="description"><?php echo $plumber_handyman_lite_description; ?></p>
            <?php endif;
        endif;
        ?>
    </div>
    <?php
}
endif;
if( ! function_exists( 'plumber_handyman_lite_navigation' ) ) :
    /**
     * Site Navigation
    */
    function plumber_handyman_lite_navigation(){
        ?>
        <nav class="main-navigation" id="site-navigation" role="navigation">
            <?php 
            wp_nav_menu( array( 
                'theme_location' => 'primary', 
                'menu_id' => 'primary-menu' 
            ) ); 
            ?>
        </nav>
        <?php
    }
endif;

if( ! function_exists( 'plumber_handyman_lite_header' ) ) :
/**
 * Header Start
*/
function plumber_handyman_lite_header(){
        $plumber_handyman_lite_header_image = get_header_image();
        $plumber_handyman_lite_sticky_header = get_theme_mod('plumber_handyman_lite_sticky_header');
        $plumber_handyman_lite_location     = get_theme_mod( 'plumber_handyman_lite_header_location' );
        $plumber_handyman_lite_phone        = get_theme_mod( 'plumber_handyman_lite_header_phone' );
        $plumber_handyman_lite_email        = get_theme_mod( 'plumber_handyman_lite_header_email' );
        $plumber_handyman_lite_header_btn_text     = get_theme_mod( 'plumber_handyman_lite_header_btn_text' );
        $plumber_handyman_lite_header_btn_url     = get_theme_mod( 'plumber_handyman_lite_header_btn_url' );
        $plumber_handyman_lite_header_setting = get_theme_mod('plumber_handyman_lite_header_setting', false);
    ?>
    <div id="page-site-header">   
            <header id="masthead" class="site-header head_bg" style="background-image: url('<?php echo esc_url( $plumber_handyman_lite_header_image ); ?>'); background-repeat: no-repeat; background-size: cover" data-sticky="<?php echo $plumber_handyman_lite_sticky_header; ?>" role="banner">
                <div class="container-fluid">
                    <div class="row logo-border">
                        <div class="col-xl-3 col-lg-3 col-md-12 align-self-center">
                            <?php plumber_handyman_lite_site_branding(); ?>
                        </div>
                        <div class="col-xl-9 col-lg-9 col-md-0 align-self-center">
                            <?php if ($plumber_handyman_lite_header_setting): ?>
                                <div class="row py-2 head-border">
                                    <div class="col-xl-3 col-lg-3 col-md-3 col-sm-4 align-self-center py-1">
                                        <?php if ( ! empty( $plumber_handyman_lite_location ) ) { ?>
                                            <span><a href="https://www.google.com/maps/search/<?php echo urlencode( $plumber_handyman_lite_location ); ?>" target="_blank" rel="noopener">
                                                <i class="<?php echo esc_attr( get_theme_mod( 'plumber_handyman_lite_marker_icon', 'fas fa-map-marker-alt' ) ); ?>"></i>
                                                <?php echo esc_html( $plumber_handyman_lite_location ); ?>
                                            </a></span>
                                        <?php } ?>
                                    </div>
                                    <div class="col-xl-3 col-lg-3 col-md-3 col-sm-4 align-self-center py-1">
                                    <?php if ( $plumber_handyman_lite_email ){?>
                                            <span><a href="mailto:<?php echo esc_attr($plumber_handyman_lite_email);?>"><i class="<?php echo esc_attr(get_theme_mod('plumber_handyman_lite_mail_icon','fas fa-envelope')); ?>"></i> <?php echo esc_html($plumber_handyman_lite_email);?></a></span>
                                        <?php } ?>  
                                    </div>
                                    <div class="col-xl-3 col-lg-3 col-md-3 col-sm-4 align-self-center py-1">
                                    <?php if ( $plumber_handyman_lite_phone ){?>
                                        <span><a href="tel:<?php echo esc_attr($plumber_handyman_lite_phone);?>"><i class="<?php echo esc_attr(get_theme_mod('plumber_handyman_lite_phone_icon','fas fa-phone')); ?>"></i>
                                        <?php echo esc_html( $plumber_handyman_lite_phone);?></span></a></span><?php } ?>      
                                    </div>
                                    <div class="col-xl-3 col-lg-3 col-md-3 col-sm-12 align-self-center">
                                    <?php if ( $plumber_handyman_lite_header_btn_text ){?>
                                            <div class="menudiv-button">
                                                <i class="fas fa-calendar-week"></i><a href="<?php echo esc_url($plumber_handyman_lite_header_btn_url);?>"> <?php echo esc_html($plumber_handyman_lite_header_btn_text);?></a>
                                            </div>
                                        <?php } ?>   
                                    </div>
                                </div>
                            <?php endif; ?>
                            <div class="row head-border">
                                <div class="col-xl-9 col-lg-9 align-self-center">
                                <?php plumber_handyman_lite_navigation(); ?>  
                                </div>
                                <div class="col-xl-3 col-lg-2 text-center align-self-center position-relative">
                                <?php if( get_theme_mod('plumber_handyman_lite_show_hide_search',false) != ''){ ?>
                                        <span class="search-body text-center position-relative align-self-center">
                                            <button type="button" class="search-show"><i class="<?php echo esc_attr(get_theme_mod('plumber_handyman_lite_search_icon','fas fa-search')); ?>"></i></button>
                                        </span>
                                    <?php } ?>
                                    <div class="searchform-inner">
                                        <?php get_search_form(); ?>
                                        <button type="button" class="close" aria-label="<?php esc_attr_e('Close', 'plumber-handyman-lite'); ?>"><span aria-hidden="true">X</span></button>
                                    </div>   
                                </div>
                                <div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </header>
    </div>
    <?php
}
endif;
add_action( 'plumber_handyman_lite_header', 'plumber_handyman_lite_header', 20 );
