<?php
/**
 * Plumber Handyman Lite Theme Customizer.
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package plumber_handyman_lite
 */

if( ! function_exists( 'plumber_handyman_lite_customize_register' ) ):  
/**
 * Add postMessage support for site title and description for the Theme Customizer.F
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function plumber_handyman_lite_customize_register( $wp_customize ) {
    require get_parent_theme_file_path('/inc/controls/changeable-icon.php');

    require get_parent_theme_file_path('/inc/controls/sortable-control.php');
    
    //Register the sortable control type.
    $wp_customize->register_control_type( 'Plumber_Handyman_Lite_Control_Sortable' ); 
    

    if ( version_compare( get_bloginfo('version'),'4.9', '>=') ) {
        $wp_customize->get_section( 'static_front_page' )->title = __( 'Static Front Page', 'plumber-handyman-lite' );
    }
	
    /* Option list of all post */	
    $plumber_handyman_lite_options_posts = array();
    $plumber_handyman_lite_options_posts_obj = get_posts('posts_per_page=-1');
    $plumber_handyman_lite_options_posts[''] = esc_html__( 'Choose Post', 'plumber-handyman-lite' );
    foreach ( $plumber_handyman_lite_options_posts_obj as $plumber_handyman_lite_posts ) {
    	$plumber_handyman_lite_options_posts[$plumber_handyman_lite_posts->ID] = $plumber_handyman_lite_posts->post_title;
    }
    
    /* Option list of all categories */
    $plumber_handyman_lite_args = array(
	   'type'                     => 'post',
	   'orderby'                  => 'name',
	   'order'                    => 'ASC',
	   'hide_empty'               => 1,
	   'hierarchical'             => 1,
	   'taxonomy'                 => 'category'
    ); 
    $plumber_handyman_lite_option_categories = array();
    $plumber_handyman_lite_category_lists = get_categories( $plumber_handyman_lite_args );
    $plumber_handyman_lite_option_categories[''] = esc_html__( 'Choose Category', 'plumber-handyman-lite' );
    foreach( $plumber_handyman_lite_category_lists as $plumber_handyman_lite_category ){
        $plumber_handyman_lite_option_categories[$plumber_handyman_lite_category->term_id] = $plumber_handyman_lite_category->name;
    }
    
    /** Default Settings */    
    $wp_customize->add_panel( 
        'wp_default_panel',
         array(
            'priority' => 10,
            'capability' => 'edit_theme_options',
            'theme_supports' => '',
            'title' => esc_html__( 'Default Settings', 'plumber-handyman-lite' ),
            'description' => esc_html__( 'Default section provided by wordpress customizer.', 'plumber-handyman-lite' ),
        ) 
    );
    
    $wp_customize->get_section( 'title_tagline' )->panel                  = 'wp_default_panel';
    $wp_customize->get_section( 'colors' )->panel                         = 'wp_default_panel';
    $wp_customize->get_section( 'header_image' )->panel                   = 'wp_default_panel';
    $wp_customize->get_section( 'background_image' )->panel               = 'wp_default_panel';
    $wp_customize->get_section( 'static_front_page' )->panel              = 'wp_default_panel';
    
    $wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';
    
    /** Default Settings Ends */
    
    /** Site Title control */
    $wp_customize->add_setting( 
        'header_site_title', 
        array(
            'default'           => true,
            'sanitize_callback' => 'plumber_handyman_lite_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'header_site_title',
        array(
            'label'       => __( 'Show / Hide Site Title', 'plumber-handyman-lite' ),
            'section'     => 'title_tagline',
            'type'        => 'checkbox',
        )
    );

    /** Tagline control */
    $wp_customize->add_setting( 
        'header_tagline', 
        array(
            'default'           => false,
            'sanitize_callback' => 'plumber_handyman_lite_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'header_tagline',
        array(
            'label'       => __( 'Show / Hide Tagline', 'plumber-handyman-lite' ),
            'section'     => 'title_tagline',
            'type'        => 'checkbox',
        )
    );

    $wp_customize->add_setting( 'plumber_handyman_lite_site_title_size', array(
        'default'           => 20, // Default font size in pixels
        'sanitize_callback' => 'absint', // Sanitize the input as a positive integer
    ) );

    // Add control for site title size
    $wp_customize->add_control( 'plumber_handyman_lite_site_title_size', array(
        'type'        => 'number',
        'section'     => 'title_tagline', // You can change this section to your preferred section
        'label'       => __( 'Site Title Font Size (px)', 'plumber-handyman-lite' ),
        'input_attrs' => array(
            'min'  => 10,
            'max'  => 100,
            'step' => 1,
        ),
    ) );

    /** Post & Pages Settings */
    $wp_customize->add_panel( 
        'plumber_handyman_lite_post_settings',
         array(
            'priority' => 11,
            'capability' => 'edit_theme_options',
            'title' => esc_html__( 'Post & Pages Settings', 'plumber-handyman-lite' ),
            'description' => esc_html__( 'Customize Post & Pages Settings', 'plumber-handyman-lite' ),
        ) 
    );

        /** Post Layouts */
    
    $wp_customize->add_section(
        'plumber_handyman_lite_post_layout_section',
        array(
            'title' => esc_html__( 'Post Layout Settings', 'plumber-handyman-lite' ),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel' => 'plumber_handyman_lite_post_settings',
        )
    );

    $wp_customize->add_setting('plumber_handyman_lite_post_layout_setting', array(
        'default'           => 'right-sidebar',
        'sanitize_callback' => 'plumber_handyman_lite_sanitize_post_layout',
    ));

    $wp_customize->add_control('plumber_handyman_lite_post_layout_setting', array(
        'label'    => __('Post Column Settings', 'plumber-handyman-lite'),
        'section'  => 'plumber_handyman_lite_post_layout_section',
        'settings' => 'plumber_handyman_lite_post_layout_setting',
        'type'     => 'select',
        'choices'  => array(
            'one-column'   => __('One Column', 'plumber-handyman-lite'),
            'right-sidebar'   => __('Right Sidebar', 'plumber-handyman-lite'),
            'left-sidebar'   => __('Left Sidebar', 'plumber-handyman-lite'),
            'three-column'   => __('Three Columns', 'plumber-handyman-lite'),
            'four-column'   => __('Four Columns', 'plumber-handyman-lite'),
        ),
    ));

     /** Post Layouts Ends */
     
    /** Post Settings */
    $wp_customize->add_section(
        'plumber_handyman_lite_post_settings',
        array(
            'title' => esc_html__( 'Post Settings', 'plumber-handyman-lite' ),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel' => 'plumber_handyman_lite_post_settings',
        )
    );

    /** Post Heading control */
    $wp_customize->add_setting( 
        'plumber_handyman_lite_post_heading_setting', 
        array(
            'default'           => true,
            'sanitize_callback' => 'plumber_handyman_lite_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'plumber_handyman_lite_post_heading_setting',
        array(
            'label'       => __( 'Show / Hide Post Heading', 'plumber-handyman-lite' ),
            'section'     => 'plumber_handyman_lite_post_settings',
            'type'        => 'checkbox',
        )
    );

    /** Post Meta control */
    $wp_customize->add_setting( 
        'plumber_handyman_lite_post_meta_setting', 
        array(
            'default'           => true,
            'sanitize_callback' => 'plumber_handyman_lite_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'plumber_handyman_lite_post_meta_setting',
        array(
            'label'       => __( 'Show / Hide Post Meta', 'plumber-handyman-lite' ),
            'section'     => 'plumber_handyman_lite_post_settings',
            'type'        => 'checkbox',
        )
    );

    /** Post Image control */
    $wp_customize->add_setting( 
        'plumber_handyman_lite_post_image_setting', 
        array(
            'default'           => true,
            'sanitize_callback' => 'plumber_handyman_lite_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'plumber_handyman_lite_post_image_setting',
        array(
            'label'       => __( 'Show / Hide Post Image', 'plumber-handyman-lite' ),
            'section'     => 'plumber_handyman_lite_post_settings',
            'type'        => 'checkbox',
        )
    );

    /** Post Content control */
    $wp_customize->add_setting( 
        'plumber_handyman_lite_post_content_setting', 
        array(
            'default'           => true,
            'sanitize_callback' => 'plumber_handyman_lite_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'plumber_handyman_lite_post_content_setting',
        array(
            'label'       => __( 'Show / Hide Post Content', 'plumber-handyman-lite' ),
            'section'     => 'plumber_handyman_lite_post_settings',
            'type'        => 'checkbox',
        )
    );
    /** Post ReadMore control */
     $wp_customize->add_setting( 'plumber_handyman_lite_read_more_setting`', array(
        'default'           => true,
        'sanitize_callback' => 'plumber_handyman_lite_sanitize_checkbox',
    ) );

    $wp_customize->add_control( 'plumber_handyman_lite_read_more_setting`', array(
        'type'        => 'checkbox',
        'section'     => 'plumber_handyman_lite_post_settings', 
        'label'       => __( 'Display Read More Button', 'plumber-handyman-lite' ),
    ) );

    $wp_customize->add_setting('plumber_handyman_lite_blog_meta_order', array(
        'default' => array('heading', 'author', 'featured-image', 'content','button'),
        'sanitize_callback' => 'plumber_handyman_lite_sanitize_sortable',
    ));
    $wp_customize->add_control(new Plumber_Handyman_Lite_Control_Sortable($wp_customize, 'plumber_handyman_lite_blog_meta_order', array(
        'label' => esc_html__('Post Meta Ordering', 'plumber-handyman-lite'),
        'description' => __('Drag & drop post items to rearrange the ordering ( this control will not function by post format )', 'plumber-handyman-lite') ,
        'section' => 'plumber_handyman_lite_post_settings',
        'choices' => array(
            'heading' => __('heading', 'plumber-handyman-lite') ,
            'author' => __('author', 'plumber-handyman-lite') ,
            'featured-image' => __('featured-image', 'plumber-handyman-lite') ,
            'content' => __('content', 'plumber-handyman-lite') ,
            'button' => __('button', 'plumber-handyman-lite') ,
        ) ,
    )));

    /** Post Settings Ends */

     /** Single Post Settings */
    $wp_customize->add_section(
        'plumber_handyman_lite_single_post_settings',
        array(
            'title' => esc_html__( 'Single Post Settings', 'plumber-handyman-lite' ),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel' => 'plumber_handyman_lite_post_settings',
        )
    );

    /** Single Post Meta control */
    $wp_customize->add_setting( 
        'plumber_handyman_lite_single_post_meta_setting', 
        array(
            'default'           => true,
            'sanitize_callback' => 'plumber_handyman_lite_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'plumber_handyman_lite_single_post_meta_setting',
        array(
            'label'       => __( 'Show / Hide Single Post Meta', 'plumber-handyman-lite' ),
            'section'     => 'plumber_handyman_lite_single_post_settings',
            'type'        => 'checkbox',
        )
    );

    /** Single Post Content control */
    $wp_customize->add_setting( 
        'plumber_handyman_lite_single_post_content_setting', 
        array(
            'default'           => true,
            'sanitize_callback' => 'plumber_handyman_lite_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'plumber_handyman_lite_single_post_content_setting',
        array(
            'label'       => __( 'Show / Hide Single Post Content', 'plumber-handyman-lite' ),
            'section'     => 'plumber_handyman_lite_single_post_settings',
            'type'        => 'checkbox',
        )
    );

    //Global Color
    $wp_customize->add_section(
        'plumber_handyman_lite_global_color',
        array(
            'title' => esc_html__( 'Global Color Settings', 'plumber-handyman-lite' ),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel' => 'plumber_handyman_lite_general_settings',
        )
    );

    $wp_customize->add_setting('plumber_handyman_lite_primary_color', array(
        'default'           => '#FFC527',
        'sanitize_callback' => 'sanitize_hex_color',
    ));
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'plumber_handyman_lite_primary_color', array(
        'label'    => __('Theme Primary Color', 'plumber-handyman-lite'),
        'section'  => 'plumber_handyman_lite_global_color',
        'settings' => 'plumber_handyman_lite_primary_color',
    )));    

    $wp_customize->add_setting('plumber_handyman_lite_second_color', array(
        'default'           => '#267ECE',
        'sanitize_callback' => 'sanitize_hex_color',
    ));
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'plumber_handyman_lite_second_color', array(
        'label'    => __('Theme Secondary Color', 'plumber-handyman-lite'),
        'section'  => 'plumber_handyman_lite_global_color',
        'settings' => 'plumber_handyman_lite_second_color',
    )));

    /** Single Post Settings Ends */

         // Typography Settings Section
    $wp_customize->add_section('plumber_handyman_lite_typography_settings', array(
        'title'      => esc_html__('Typography Settings', 'plumber-handyman-lite'),
        'priority'   => 30,
        'capability' => 'edit_theme_options',
        'panel' => 'plumber_handyman_lite_general_settings',
    ));

    // Array of fonts to choose from
    $font_choices = array(
        ''               => __('Select', 'plumber-handyman-lite'),
        'Arial'          => 'Arial, sans-serif',
        'Verdana'        => 'Verdana, sans-serif',
        'Helvetica'      => 'Helvetica, sans-serif',
        'Times New Roman'=> '"Times New Roman", serif',
        'Georgia'        => 'Georgia, serif',
        'Courier New'    => '"Courier New", monospace',
        'Trebuchet MS'   => '"Trebuchet MS", sans-serif',
        'Tahoma'         => 'Tahoma, sans-serif',
        'Palatino'       => '"Palatino Linotype", serif',
        'Garamond'       => 'Garamond, serif',
        'Impact'         => 'Impact, sans-serif',
        'Comic Sans MS'  => '"Comic Sans MS", cursive, sans-serif',
        'Lucida Sans'    => '"Lucida Sans Unicode", sans-serif',
        'Arial Black'    => '"Arial Black", sans-serif',
        'Gill Sans'      => '"Gill Sans", sans-serif',
        'Segoe UI'       => '"Segoe UI", sans-serif',
        'Open Sans'      => '"Open Sans", sans-serif',
        'Inter'         => 'Inter, sans-serif',
        'Lato'           => 'Lato, sans-serif',
        'Montserrat'     => 'Montserrat, sans-serif',
        'Libre Baskerville' => 'Libre Baskerville',
    );

    // Heading Font Setting
    $wp_customize->add_setting('plumber_handyman_lite_heading_font_family', array(
        'default'           => '',
        'sanitize_callback' => 'plumber_handyman_lite_sanitize_choicess',
    ));
    $wp_customize->add_control('plumber_handyman_lite_heading_font_family', array(
        'type'    => 'select',
        'choices' => $font_choices,
        'label'   => __('Select Font for Heading', 'plumber-handyman-lite'),
        'section' => 'plumber_handyman_lite_typography_settings',
    ));

    // Body Font Setting
    $wp_customize->add_setting('plumber_handyman_lite_body_font_family', array(
        'default'           => '',
        'sanitize_callback' => 'plumber_handyman_lite_sanitize_choicess',
    ));
    $wp_customize->add_control('plumber_handyman_lite_body_font_family', array(
        'type'    => 'select',
        'choices' => $font_choices,
        'label'   => __('Select Font for Body', 'plumber-handyman-lite'),
        'section' => 'plumber_handyman_lite_typography_settings',
    ));

    /** Typography Settings Section End */

    /** General Settings */
    $wp_customize->add_panel( 
        'plumber_handyman_lite_general_settings',
         array(
            'priority' => 11,
            'capability' => 'edit_theme_options',
            'title' => esc_html__( 'General Settings', 'plumber-handyman-lite' ),
            'description' => esc_html__( 'Customize General Settings', 'plumber-handyman-lite' ),
        ) 
    );

    /** General Settings */
    $wp_customize->add_section(
        'plumber_handyman_lite_general_settings',
        array(
            'title' => esc_html__( 'Loader Settings', 'plumber-handyman-lite' ),
            'priority' => 30,
            'capability' => 'edit_theme_options',
            'panel' => 'plumber_handyman_lite_general_settings',
        )
    );

    /** Preloader control */
    $wp_customize->add_setting( 
        'plumber_handyman_lite_header_preloader', 
        array(
            'default' => false,
            'sanitize_callback' => 'plumber_handyman_lite_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'plumber_handyman_lite_header_preloader',
        array(
            'label'       => __( 'Show Preloader', 'plumber-handyman-lite' ),
            'section'     => 'plumber_handyman_lite_general_settings',
            'type'        => 'checkbox',
        )
    );

    $wp_customize->add_setting('plumber_handyman_lite_loader_layout_setting', array(
        'default' => 'load',
        'sanitize_callback' => 'sanitize_text_field',
    ));

    // Add control for loader layout
    $wp_customize->add_control('plumber_handyman_lite_loader_layout_control', array(
        'label' => __('Preloader Layout', 'plumber-handyman-lite'),
        'section' => 'plumber_handyman_lite_general_settings',
        'settings' => 'plumber_handyman_lite_loader_layout_setting',
        'type' => 'select',
        'choices' => array(
            'load' => __('Preloader 1', 'plumber-handyman-lite'),
            'load-one' => __('Preloader 2', 'plumber-handyman-lite'),
            'ctn-preloader' => __('Preloader 3', 'plumber-handyman-lite'),
        ),
    ));

    /** Home Page Settings **/
    $wp_customize->add_panel( 'plumber_handyman_lite_home_page_settings', array(
        'priority'    => 9,
        'capability'  => 'edit_theme_options',
        'title'       => esc_html__( 'Home Page Settings', 'plumber-handyman-lite' ),
        'description' => esc_html__( 'Customize Home Page Settings', 'plumber-handyman-lite' ),
    ) );

    /** Header Section Settings */
    $wp_customize->add_section(
        'plumber_handyman_lite_header_section_settings',
        array(
            'title'      => esc_html__( 'Header Section Settings', 'plumber-handyman-lite' ),
            'priority'   => 30,
            'capability' => 'edit_theme_options',
            'panel'      => 'plumber_handyman_lite_home_page_settings',
        )
    );

    /** Show Header checkbox */
    $wp_customize->add_setting(
        'plumber_handyman_lite_header_setting',
        array(
            'default'           => false,
            'sanitize_callback' => 'plumber_handyman_lite_sanitize_checkbox',
            'capability'        => 'edit_theme_options',
        )
    );
    $wp_customize->add_control(
        'plumber_handyman_lite_header_setting',
        array(
            'label'   => esc_html__( 'Show Header', 'plumber-handyman-lite' ),
            'section' => 'plumber_handyman_lite_header_section_settings',
            'type'    => 'checkbox',
        )
    );

    /** Location (text) */
    $wp_customize->add_setting(
        'plumber_handyman_lite_header_location',
        array(
            'default'           => '',
            'sanitize_callback' => 'sanitize_text_field',
            'transport'         => 'refresh',
        )
    );
    $wp_customize->add_control(
        'plumber_handyman_lite_header_location',
        array(
            'label'   => esc_html__( 'Add Location', 'plumber-handyman-lite' ),
            'section' => 'plumber_handyman_lite_header_section_settings',
            'type'    => 'text',
        )
    );

    /** Location icon */
    $wp_customize->add_setting(
        'plumber_handyman_lite_marker_icon',
        array(
            'default'           => 'fas fa-map-marker-alt',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        new Plumber_Handyman_Lite_Changeable_Icon(
            $wp_customize,
            'plumber_handyman_lite_marker_icon',
            array(
                'label'     => esc_html__( 'Location Icon', 'plumber-handyman-lite' ),
                'transport' => 'refresh',
                'section'   => 'plumber_handyman_lite_header_section_settings',
                'type'      => 'icon',
            )
        )
    );

    /** Email */
    $wp_customize->add_setting(
        'plumber_handyman_lite_header_email',
        array(
            'default'           => '',
            'sanitize_callback' => 'sanitize_text_field',
            'transport'         => 'refresh',
        )
    );
    $wp_customize->add_control(
        'plumber_handyman_lite_header_email',
        array(
            'label'   => esc_html__( 'Add Email', 'plumber-handyman-lite' ),
            'section' => 'plumber_handyman_lite_header_section_settings',
            'type'    => 'text',
        )
    );

    $wp_customize->add_setting(
        'plumber_handyman_lite_mail_icon',
        array(
            'default'           => 'fas fa-envelope',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        new Plumber_Handyman_Lite_Changeable_Icon(
            $wp_customize,
            'plumber_handyman_lite_mail_icon',
            array(
                'label'     => esc_html__( 'Mail Icon', 'plumber-handyman-lite' ),
                'transport' => 'refresh',
                'section'   => 'plumber_handyman_lite_header_section_settings',
                'type'      => 'icon',
            )
        )
    );

    /** Phone */
    $wp_customize->add_setting(
        'plumber_handyman_lite_header_phone',
        array(
            'default'           => '',
            'sanitize_callback' => 'sanitize_text_field',
            'transport'         => 'refresh',
        )
    );
    $wp_customize->add_control(
        'plumber_handyman_lite_header_phone',
        array(
            'label'   => esc_html__( 'Add Phone', 'plumber-handyman-lite' ),
            'section' => 'plumber_handyman_lite_header_section_settings',
            'type'    => 'text',
        )
    );

    $wp_customize->add_setting(
        'plumber_handyman_lite_phone_icon',
        array(
            'default'           => 'fas fa-phone-volume',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        new Plumber_Handyman_Lite_Changeable_Icon(
            $wp_customize,
            'plumber_handyman_lite_phone_icon',
            array(
                'label'     => esc_html__( 'Phone Icon', 'plumber-handyman-lite' ),
                'transport' => 'refresh',
                'section'   => 'plumber_handyman_lite_header_section_settings',
                'type'      => 'icon',
            )
        )
    );

    /** Appointment Button text & url */
    $wp_customize->add_setting(
        'plumber_handyman_lite_header_btn_text',
        array(
            'default'           => '',
            'sanitize_callback' => 'sanitize_text_field',
            'transport'         => 'refresh',
        )
    );
    $wp_customize->add_control(
        'plumber_handyman_lite_header_btn_text',
        array(
            'label'   => esc_html__( 'Add Button Text', 'plumber-handyman-lite' ),
            'section' => 'plumber_handyman_lite_header_section_settings',
            'type'    => 'text',
        )
    );

    $wp_customize->add_setting(
        'plumber_handyman_lite_header_btn_url',
        array(
            'default'           => '',
            'sanitize_callback' => 'esc_url_raw',
            'transport'         => 'refresh',
        )
    );
    $wp_customize->add_control(
        'plumber_handyman_lite_header_btn_url',
        array(
            'label'   => esc_html__( 'Add Button URL', 'plumber-handyman-lite' ),
            'section' => 'plumber_handyman_lite_header_section_settings',
            'type'    => 'url',
        )
    );

    /** Show Search Icon */
    $wp_customize->add_setting(
        'plumber_handyman_lite_show_hide_search',
        array(
            'default'           => false,
            'sanitize_callback' => 'plumber_handyman_lite_sanitize_checkbox',
        )
    );
    $wp_customize->add_control(
        'plumber_handyman_lite_show_hide_search',
        array(
            'label'   => esc_html__( 'Show Search Icon', 'plumber-handyman-lite' ),
            'section' => 'plumber_handyman_lite_header_section_settings',
            'type'    => 'checkbox',
        )
    );

    $wp_customize->add_setting(
        'plumber_handyman_lite_search_icon',
        array(
            'default'           => 'fas fa-search',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        new Plumber_Handyman_Lite_Changeable_Icon(
            $wp_customize,
            'plumber_handyman_lite_search_icon',
            array(
                'label'     => esc_html__( 'Search Icon', 'plumber-handyman-lite' ),
                'transport' => 'refresh',
                'section'   => 'plumber_handyman_lite_header_section_settings',
                'type'      => 'icon',
            )
        )
    );

    /** Sticky Header */
    $wp_customize->add_setting(
        'plumber_handyman_lite_sticky_header',
        array(
            'default'           => false,
            'sanitize_callback' => 'plumber_handyman_lite_sanitize_checkbox',
        )
    );
    $wp_customize->add_control(
        'plumber_handyman_lite_sticky_header',
        array(
            'label'   => esc_html__( 'Show Sticky Header', 'plumber-handyman-lite' ),
            'section' => 'plumber_handyman_lite_header_section_settings',
            'type'    => 'checkbox',
        )
    );

    /** Menu Font Weight */
    $wp_customize->add_setting(
        'plumber_handyman_lite_menu_font_weight',
        array(
            'default'           => '500',
            'sanitize_callback' => 'plumber_handyman_lite_sanitize_font_weight',
        )
    );
    $wp_customize->add_control(
        'plumber_handyman_lite_menu_font_weight',
        array(
            'label'   => esc_html__( 'Menu Font Weight', 'plumber-handyman-lite' ),
            'section' => 'plumber_handyman_lite_header_section_settings',
            'type'    => 'select',
            'choices' => array(
                '100' => esc_html__( '100 - Thin', 'plumber-handyman-lite' ),
                '200' => esc_html__( '200 - Extra Light', 'plumber-handyman-lite' ),
                '300' => esc_html__( '300 - Light', 'plumber-handyman-lite' ),
                '400' => esc_html__( '400 - Normal', 'plumber-handyman-lite' ),
                '500' => esc_html__( '500 - Medium', 'plumber-handyman-lite' ),
                '600' => esc_html__( '600 - Semi Bold', 'plumber-handyman-lite' ),
                '700' => esc_html__( '700 - Bold', 'plumber-handyman-lite' ),
                '800' => esc_html__( '800 - Extra Bold', 'plumber-handyman-lite' ),
                '900' => esc_html__( '900 - Black', 'plumber-handyman-lite' ),
            ),
        )
    );

    /** Menu Text Transform */
    $wp_customize->add_setting(
        'plumber_handyman_lite_menu_text_transform',
        array(
            'default'           => 'capitalize',
            'sanitize_callback' => 'plumber_handyman_lite_sanitize_text_transform',
        )
    );
    $wp_customize->add_control(
        'plumber_handyman_lite_menu_text_transform',
        array(
            'label'   => esc_html__( 'Menu Text Transform', 'plumber-handyman-lite' ),
            'section' => 'plumber_handyman_lite_header_section_settings',
            'type'    => 'select',
            'choices' => array(
                'none'       => esc_html__( 'None', 'plumber-handyman-lite' ),
                'capitalize' => esc_html__( 'Capitalize', 'plumber-handyman-lite' ),
                'uppercase'  => esc_html__( 'Uppercase', 'plumber-handyman-lite' ),
                'lowercase'  => esc_html__( 'Lowercase', 'plumber-handyman-lite' ),
            ),
        )
    );

    /** Menu Hover Style */
    $wp_customize->add_setting(
        'plumber_handyman_lite_menus_style',
        array(
            'default'           => '',
            'sanitize_callback' => 'plumber_handyman_lite_sanitize_choices',
        )
    );
    $wp_customize->add_control(
        'plumber_handyman_lite_menus_style',
        array(
            'type'    => 'select',
            'label'   => esc_html__( 'Menu Hover Style', 'plumber-handyman-lite' ),
            'section' => 'plumber_handyman_lite_header_section_settings',
            'choices' => array(
                ''       => esc_html__( 'None', 'plumber-handyman-lite' ),
                'zoom'   => esc_html__( 'Zoom In', 'plumber-handyman-lite' ),
            ),
        )
    );

    /** Slider / Banner Section */
    $wp_customize->add_section(
        'plumber_handyman_lite_slider_section_settings',
        array(
            'title'      => esc_html__( 'Slider Section Settings', 'plumber-handyman-lite' ),
            'priority'   => 30,
            'capability' => 'edit_theme_options',
            'panel'      => 'plumber_handyman_lite_home_page_settings',
        )
    );

    $wp_customize->add_setting(
        'plumber_handyman_lite_slider_setting',
        array(
            'default'           => false,
            'sanitize_callback' => 'plumber_handyman_lite_sanitize_checkbox',
        )
    );
    $wp_customize->add_control(
        'plumber_handyman_lite_slider_setting',
        array(
            'label'   => esc_html__( 'Show Slider', 'plumber-handyman-lite' ),
            'section' => 'plumber_handyman_lite_slider_section_settings',
            'type'    => 'checkbox',
        )
    );

    /** Build categories choices safely */
    $plumber_handyman_lite_categories = get_categories();
    $plumber_handyman_lite_cat_posts = array();
    $plumber_handyman_lite_cat_posts[''] = esc_html__( 'Select', 'plumber-handyman-lite' );

    foreach ( $plumber_handyman_lite_categories as $cat ) {
        $plumber_handyman_lite_cat_posts[ $cat->slug ] = $cat->name;
    }

    $wp_customize->add_setting(
        'plumber_handyman_lite_blog_slide_category',
        array(
            'default'           => '',
            'sanitize_callback' => 'plumber_handyman_lite_sanitize_choices',
        )
    );
    $wp_customize->add_control(
        'plumber_handyman_lite_blog_slide_category',
        array(
            'type'    => 'select',
            'choices' => $plumber_handyman_lite_cat_posts,
            'label'   => esc_html__( 'Select Category to display Latest Post', 'plumber-handyman-lite' ),
            'section' => 'plumber_handyman_lite_slider_section_settings',
        )
    );

    /** Page dropdown */
    $wp_customize->add_setting(
        'plumber_handyman_lite_featured_mission_post_',
        array(
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'plumber_handyman_lite_dropdown_pages',
        )
    );
    $wp_customize->add_control(
        'plumber_handyman_lite_featured_mission_post_',
        array(
            'label'    => esc_html__( 'Pages Dropdown', 'plumber-handyman-lite' ),
            'section'  => 'plumber_handyman_lite_slider_section_settings',
            'settings' => 'plumber_handyman_lite_featured_mission_post_',
            'type'     => 'dropdown-pages',
        )
    );

    /** Social Section */
    $wp_customize->add_section(
        'plumber_handyman_lite_social_section_settings',
        array(
            'title'      => esc_html__( 'Social Media Section Settings', 'plumber-handyman-lite' ),
            'priority'   => 30,
            'capability' => 'edit_theme_options',
            'panel'      => 'plumber_handyman_lite_home_page_settings',
        )
    );

    $wp_customize->add_setting(
        'plumber_handyman_lite_social_icon_setting',
        array(
            'default'           => false,
            'sanitize_callback' => 'plumber_handyman_lite_sanitize_checkbox',
        )
    );
    $wp_customize->add_control(
        'plumber_handyman_lite_social_icon_setting',
        array(
            'label'   => esc_html__( 'Show Social Icon', 'plumber-handyman-lite' ),
            'section' => 'plumber_handyman_lite_social_section_settings',
            'type'    => 'checkbox',
        )
    );

    /** Social links */
    for ( $plumber_handyman_lite_i = 1; $plumber_handyman_lite_i <= 4; $plumber_handyman_lite_i++ ) {
        $wp_customize->add_setting(
            "plumber_handyman_lite_social_link_{$plumber_handyman_lite_i}",
            array(
                'default'           => '',
                'sanitize_callback' => 'esc_url_raw',
                'transport'         => 'refresh',
            )
        );
    }
    $wp_customize->add_control(
        'plumber_handyman_lite_social_link_1',
        array(
            'label'   => esc_html__( 'Add Facebook Link', 'plumber-handyman-lite' ),
            'section' => 'plumber_handyman_lite_social_section_settings',
            'type'    => 'url',
        )
    );
    $wp_customize->add_control(
        'plumber_handyman_lite_social_link_2',
        array(
            'label'   => esc_html__( 'Add Twitter Link', 'plumber-handyman-lite' ),
            'section' => 'plumber_handyman_lite_social_section_settings',
            'type'    => 'url',
        )
    );
    $wp_customize->add_control(
        'plumber_handyman_lite_social_link_3',
        array(
            'label'   => esc_html__( 'Add Instagram Link', 'plumber-handyman-lite' ),
            'section' => 'plumber_handyman_lite_social_section_settings',
            'type'    => 'url',
        )
    );
    $wp_customize->add_control(
        'plumber_handyman_lite_social_link_4',
        array(
            'label'   => esc_html__( 'Add Youtube Link', 'plumber-handyman-lite' ),
            'section' => 'plumber_handyman_lite_social_section_settings',
            'type'    => 'url',
        )
    );

    /** Count Section */
    $wp_customize->add_section(
        'plumber_handyman_lite_count_section_settings',
        array(
            'title'      => esc_html__( 'Count Section', 'plumber-handyman-lite' ),
            'priority'   => 30,
            'capability' => 'edit_theme_options',
            'panel'      => 'plumber_handyman_lite_home_page_settings',
        )
    );

    $wp_customize->add_setting(
        'plumber_handyman_lite_count_setting',
        array(
            'default'           => false,
            'sanitize_callback' => 'plumber_handyman_lite_sanitize_checkbox',
        )
    );
    $wp_customize->add_control(
        'plumber_handyman_lite_count_setting',
        array(
            'label'   => esc_html__( 'Count Section', 'plumber-handyman-lite' ),
            'section' => 'plumber_handyman_lite_count_section_settings',
            'type'    => 'checkbox',
        )
    );

    /** Opening Time title */
    $wp_customize->add_setting(
        'plumber_handyman_lite_opening_time_title',
        array(
            'default'           => '',
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        'plumber_handyman_lite_opening_time_title',
        array(
            'label'    => esc_html__( 'Opening Time Title', 'plumber-handyman-lite' ),
            'section'  => 'plumber_handyman_lite_count_section_settings',
            'settings' => 'plumber_handyman_lite_opening_time_title',
            'type'     => 'text',
        )
    );

    /** Opening times per day */
    $plumber_handyman_lite_days = array(
        'monday'    => esc_html__( 'Monday', 'plumber-handyman-lite' ),
        'tuesday'   => esc_html__( 'Tuesday', 'plumber-handyman-lite' ),
        'wednesday' => esc_html__( 'Wednesday', 'plumber-handyman-lite' ),
        'thursday'  => esc_html__( 'Thursday', 'plumber-handyman-lite' ),
        'friday'    => esc_html__( 'Friday', 'plumber-handyman-lite' ),
        'saturday'  => esc_html__( 'Saturday', 'plumber-handyman-lite' ),
        'sunday'    => esc_html__( 'Sunday', 'plumber-handyman-lite' ),
    );

    foreach ( $plumber_handyman_lite_days as $plumber_handyman_lite_key => $plumber_handyman_lite_label ) {
        $wp_customize->add_setting(
            "plumber_handyman_lite_opening_time_{$plumber_handyman_lite_key}",
            array(
                'default'           => '',
                'sanitize_callback' => 'sanitize_text_field',
            )
        );
        $wp_customize->add_control(
            "plumber_handyman_lite_opening_time_{$plumber_handyman_lite_key}",
            array(
                /* translators: %s: Day of the week */
                'label' => sprintf( __( '%s Time', 'plumber-handyman-lite' ), $plumber_handyman_lite_label ),
                'section'     => 'plumber_handyman_lite_count_section_settings',
                'type'        => 'text',
                'input_attrs' => array(
                    'placeholder' => esc_html__( '8:00 - 16:00', 'plumber-handyman-lite' ),
                ),
            )
        );
    }

    /** Customer Counters and other numeric/text fields */
    $plumber_handyman_lite_numeric_fields = array(
        'plumber_handyman_lite_total_no_satisfied_customer'     => esc_html__( 'Add Total Number of Satisfied Customers', 'plumber-handyman-lite' ),
        'plumber_handyman_lite_total_no_award_win'              => esc_html__( 'Add Total Number of Technicians & Workers', 'plumber-handyman-lite' ),
        'plumber_handyman_lite_total_no_successfull_projects'   => esc_html__( 'Add Total Number of Repaired', 'plumber-handyman-lite' ),
        'plumber_handyman_lite_total_year_experience'           => esc_html__( 'Add Total Years of experience', 'plumber-handyman-lite' ),
    );

    foreach ( $plumber_handyman_lite_numeric_fields as $plumber_handyman_lite_setting => $plumber_handyman_lite_label ) {
        $wp_customize->add_setting(
            $plumber_handyman_lite_setting,
            array(
                'default'           => '',
                'sanitize_callback' => 'sanitize_text_field',
            )
        );
        $wp_customize->add_control(
            $plumber_handyman_lite_setting,
            array(
                'label'       => $plumber_handyman_lite_label,
                'section'     => 'plumber_handyman_lite_count_section_settings',
                'type'        => 'text',
                'input_attrs' => array(
                    'placeholder' => '', // set per field if needed
                ),
            )
        );
    }

    /** Counter image */
    $wp_customize->add_setting(
        'plumber_handyman_lite_counter_image',
        array(
            'sanitize_callback' => 'esc_url_raw',
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Image_Control(
            $wp_customize,
            'plumber_handyman_lite_counter_image',
            array(
                'label'   => esc_html__( 'Add Image', 'plumber-handyman-lite' ),
                'section' => 'plumber_handyman_lite_count_section_settings',
                'settings'=> 'plumber_handyman_lite_counter_image',
            )
        )
    );
    
    /** Footer Section */
    $wp_customize->add_section(
        'plumber_handyman_lite_footer_section',
        array(
            'title' => __( 'Footer Settings', 'plumber-handyman-lite' ),
            'priority' => 70,
            'panel' => 'plumber_handyman_lite_home_page_settings',
        )
    );

    /** Footer Widget Columns */
    $wp_customize->add_setting('plumber_handyman_lite_footer_widget_areas', array(
        'default'           => 4,
        'sanitize_callback' => 'plumber_handyman_lite_sanitize_choices',
    ));

    $wp_customize->add_control('plumber_handyman_lite_footer_widget_areas', array(
        'label'    => __('Footer Widget Columns', 'plumber-handyman-lite'),
        'section'  => 'plumber_handyman_lite_footer_section',
        'settings' => 'plumber_handyman_lite_footer_widget_areas',
        'type'     => 'select',
        'choices'  => array(
		   '1'     => __('One', 'plumber-handyman-lite'),
		   '2'     => __('Two', 'plumber-handyman-lite'),
		   '3'     => __('Three', 'plumber-handyman-lite'),
		   '4'     => __('Four', 'plumber-handyman-lite')
        ),
    ));
    
    /** Copyright Text */
    $wp_customize->add_setting(
        'plumber_handyman_lite_footer_copyright_text',
        array(
            'default' => '',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    
    $wp_customize->add_control(
        'plumber_handyman_lite_footer_copyright_text',
        array(
            'label' => __( 'Copyright Info', 'plumber-handyman-lite' ),
            'section' => 'plumber_handyman_lite_footer_section',
            'type' => 'text',
        )
    );  
    $wp_customize->add_setting('plumber_handyman_lite_footer_background_image',
        array(
        'default' => '',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'absint',
        )
    );

    $wp_customize->add_control(
         new WP_Customize_Cropped_Image_Control($wp_customize, 'plumber_handyman_lite_footer_background_image',
            array(
                'label' => esc_html__('Footer Background Image', 'plumber-handyman-lite'),
                /* translators: 1: Recommended width in pixels, 2: Recommended height in pixels */
                'description' => sprintf(esc_html__('Recommended Size %1$s px X %2$s px', 'plumber-handyman-lite'), 1024, 800),
                'section' => 'plumber_handyman_lite_footer_section',
                'width' => 1024,
                'height' => 800,
                'flex_width' => true,
                'flex_height' => true,
            )
        )
    );

    /** Footer Background Image Attachment */
    $wp_customize->add_setting('plumber_handyman_lite_background_attachment', array(
        'default'           => 'scroll',
        'sanitize_callback' => 'plumber_handyman_lite_sanitize_choices',
    ));

    $wp_customize->add_control('plumber_handyman_lite_background_attachment', array(
        'label'    => __('Footer Background Attachment', 'plumber-handyman-lite'),
        'section'  => 'plumber_handyman_lite_footer_section',
        'settings' => 'plumber_handyman_lite_background_attachment',
        'type'     => 'select',
        'choices'  => array(
            'fixed' => __('fixed','plumber-handyman-lite'),
            'scroll' => __('scroll','plumber-handyman-lite'),
        ),
    ));

    /* Footer Background Color*/
    $wp_customize->add_setting(
        'plumber_handyman_lite_footer_background_color',
        array(
            'default' => '',
            'sanitize_callback' => 'sanitize_hex_color',
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'plumber_handyman_lite_footer_background_color',
            array(
                'label' => __('Footer Widget Area Background Color', 'plumber-handyman-lite'),
                'section' => 'plumber_handyman_lite_footer_section',
                'type' => 'color',
            )
        )
    );

    $wp_customize->add_setting('plumber_handyman_lite_scroll_icon',array(
        'default'   => 'fas fa-arrow-up',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control(new Plumber_Handyman_Lite_Changeable_Icon(
        $wp_customize,'plumber_handyman_lite_scroll_icon',array(
        'label' => __('Scroll Top Icon','plumber-handyman-lite'),
        'transport' => 'refresh',
        'section'   => 'plumber_handyman_lite_footer_section',
        'type'      => 'icon'
    )));

    /** Scroll to top button shape */
    $wp_customize->add_setting('plumber_handyman_lite_scroll_to_top_radius', array(
        'default'           => 'curved-box',
        'sanitize_callback' => 'plumber_handyman_lite_sanitize_choices',
    ));

    $wp_customize->add_control('plumber_handyman_lite_scroll_to_top_radius', array(
        'label'    => __('Scroll Top Button Shape', 'plumber-handyman-lite'),
        'section'  => 'plumber_handyman_lite_footer_section',
        'settings' => 'plumber_handyman_lite_scroll_to_top_radius',
        'type'     => 'select',
        'choices'  => array(
            'box'        => __( 'Box', 'plumber-handyman-lite' ),
            'curved-box' => __( 'Curved Box', 'plumber-handyman-lite' ),
            'circle'     => __( 'Circle', 'plumber-handyman-lite' ),
        ),
    ));

    // 404 PAGE SETTINGS
    $wp_customize->add_section(
        'plumber_handyman_lite_404_section',
        array(
            'title' => __( '404 Page Settings', 'plumber-handyman-lite' ),
            'priority' => 70,
            'panel' => 'plumber_handyman_lite_general_settings',
        )
    );
   
    $wp_customize->add_setting('404_page_image', array(
        'default' => '',
        'transport' => 'refresh',
        'sanitize_callback' => 'esc_url_raw', // Sanitize as URL
    ));

    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, '404_page_image', array(
        'label' => __('404 Page Image', 'plumber-handyman-lite'),
        'section' => 'plumber_handyman_lite_404_section',
        'settings' => '404_page_image',
    )));

    $wp_customize->add_setting('404_pagefirst_header', array(
        'default' => __('404', 'plumber-handyman-lite'),
        'transport' => 'refresh',
        'sanitize_callback' => 'sanitize_text_field', // Sanitize as text field
    ));

    $wp_customize->add_control('404_pagefirst_header', array(
        'type' => 'text',
        'label' => __('Heading', 'plumber-handyman-lite'),
        'section' => 'plumber_handyman_lite_404_section',
    ));

    // Setting for 404 page header
    $wp_customize->add_setting('404_page_header', array(
        'default' => __('Sorry, that page can\'t be found!', 'plumber-handyman-lite'),
        'transport' => 'refresh',
        'sanitize_callback' => 'sanitize_text_field', // Sanitize as text field
    ));

    $wp_customize->add_control('404_page_header', array(
        'type' => 'text',
        'label' => __('Heading', 'plumber-handyman-lite'),
        'section' => 'plumber_handyman_lite_404_section',
    ));

}
add_action( 'customize_register', 'plumber_handyman_lite_customize_register' );
endif;

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function plumber_handyman_lite_customize_preview_js() {
    // Use minified libraries if SCRIPT_DEBUG is false
    $plumber_handyman_lite_build  = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '/build' : '';
    $plumber_handyman_lite_suffix = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';
	wp_enqueue_script( 'plumber_handyman_lite_customizer', get_template_directory_uri() . '/js' . $plumber_handyman_lite_build . '/customizer' . $plumber_handyman_lite_suffix . '.js', array( 'customize-preview' ), '20130508', true );
}
add_action( 'customize_preview_init', 'plumber_handyman_lite_customize_preview_js' );