<?php
/**
 * The template for displaying the homepage.
 *
 * This page template will display any functions hooked into the `homepage` action.
 * By default this includes a variety of product displays and the page content itself. To change the order or toggle these components
 * use the Homepage Control plugin.
 * https://wordpress.org/plugins/homepage-control/
 *
 * Template name: Homepage With Sidebar
 *
 * @package Plug Store
 */

get_header();

	do_action('plug_shop_before_content');

		/**
		 * Functions hooked in to homepage action
		 *
		 * @hooked plug_shop_homepage_content      - 10
		 * @hooked plug_shop_product_categories    - 20
		 * @hooked plug_shop_recent_products       - 30
		 * @hooked plug_shop_featured_products     - 40
		 * @hooked plug_shop_popular_products      - 50
		 * @hooked plug_shop_on_sale_products      - 60
		 * @hooked plug_shop_best_selling_products - 70
		 */
		do_action( 'homepage' );

	do_action('plug_shop_after_content');

	if ( is_active_sidebar( 'sidebar-3' ) ) {
		do_action('plug_shop_before_sidebar');
		dynamic_sidebar( 'sidebar-3' );
		do_action('plug_shop_after_sidebar');
	}

get_footer();
