<?php
/**
 * The Sidebar containing the primary blog sidebar
 *
 * @package Plug Shop WordPress Theme
 * @subpackage Plug Shop
 * @author Pressfore - www.pressfore.com
 */

// hide sidebars with sidebars=false custom field.
if ( is_singular() && get_post_meta($post->ID, "sidebars", $single = true) ===  "false" ) {
	return;
}

// Hide sidebar if full width wc template is used.
if ( plug_shop_is_wc_template() && 'full' === plug_shop_options('shop_layout', 'sidebar') ) {
	return;
}

if ( is_active_sidebar( 'sidebar-1' ) || is_active_sidebar( 'sidebar-2' ) || is_active_sidebar( 'sidebar-3' ) ) {
	do_action('plug_shop_before_sidebar');
	do_action('plug_shop_sidebar');
	do_action('plug_shop_after_sidebar');
}